/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;

public class DescribeReplicationInstancesPublisher
implements SdkPublisher<DescribeReplicationInstancesResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationInstancesPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationInstancesPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeReplicationInstancesPublisher resume(DescribeReplicationInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReplicationInstancesPublisher(this.client, (DescribeReplicationInstancesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReplicationInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReplicationInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReplicationInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationInstancesResponse> {
        private DescribeReplicationInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationInstancesResponse> nextPage(DescribeReplicationInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationInstancesPublisher.this.client.describeReplicationInstances(DescribeReplicationInstancesPublisher.this.firstRequest);
            }
            return DescribeReplicationInstancesPublisher.this.client.describeReplicationInstances((DescribeReplicationInstancesRequest)((Object)DescribeReplicationInstancesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

