/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.RedisAuthTypeValue;
import software.amazon.awssdk.services.databasemigration.model.SslSecurityProtocolValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedisSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedisSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(RedisSettings.getter(RedisSettings::serverName)).setter(RedisSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RedisSettings.getter(RedisSettings::port)).setter(RedisSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SSL_SECURITY_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslSecurityProtocol").getter(RedisSettings.getter(RedisSettings::sslSecurityProtocolAsString)).setter(RedisSettings.setter(Builder::sslSecurityProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslSecurityProtocol").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(RedisSettings.getter(RedisSettings::authTypeAsString)).setter(RedisSettings.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<String> AUTH_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthUserName").getter(RedisSettings.getter(RedisSettings::authUserName)).setter(RedisSettings.setter(Builder::authUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthUserName").build()}).build();
    private static final SdkField<String> AUTH_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthPassword").getter(RedisSettings.getter(RedisSettings::authPassword)).setter(RedisSettings.setter(Builder::authPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthPassword").build()}).build();
    private static final SdkField<String> SSL_CA_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslCaCertificateArn").getter(RedisSettings.getter(RedisSettings::sslCaCertificateArn)).setter(RedisSettings.setter(Builder::sslCaCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslCaCertificateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD, SSL_SECURITY_PROTOCOL_FIELD, AUTH_TYPE_FIELD, AUTH_USER_NAME_FIELD, AUTH_PASSWORD_FIELD, SSL_CA_CERTIFICATE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServerName", SERVER_NAME_FIELD);
            this.put("Port", PORT_FIELD);
            this.put("SslSecurityProtocol", SSL_SECURITY_PROTOCOL_FIELD);
            this.put("AuthType", AUTH_TYPE_FIELD);
            this.put("AuthUserName", AUTH_USER_NAME_FIELD);
            this.put("AuthPassword", AUTH_PASSWORD_FIELD);
            this.put("SslCaCertificateArn", SSL_CA_CERTIFICATE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String serverName;
    private final Integer port;
    private final String sslSecurityProtocol;
    private final String authType;
    private final String authUserName;
    private final String authPassword;
    private final String sslCaCertificateArn;

    private RedisSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.sslSecurityProtocol = builder.sslSecurityProtocol;
        this.authType = builder.authType;
        this.authUserName = builder.authUserName;
        this.authPassword = builder.authPassword;
        this.sslCaCertificateArn = builder.sslCaCertificateArn;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final SslSecurityProtocolValue sslSecurityProtocol() {
        return SslSecurityProtocolValue.fromValue(this.sslSecurityProtocol);
    }

    public final String sslSecurityProtocolAsString() {
        return this.sslSecurityProtocol;
    }

    public final RedisAuthTypeValue authType() {
        return RedisAuthTypeValue.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String authUserName() {
        return this.authUserName;
    }

    public final String authPassword() {
        return this.authPassword;
    }

    public final String sslCaCertificateArn() {
        return this.sslCaCertificateArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslSecurityProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslCaCertificateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedisSettings)) {
            return false;
        }
        RedisSettings other = (RedisSettings)obj;
        return Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.sslSecurityProtocolAsString(), other.sslSecurityProtocolAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.authUserName(), other.authUserName()) && Objects.equals(this.authPassword(), other.authPassword()) && Objects.equals(this.sslCaCertificateArn(), other.sslCaCertificateArn());
    }

    public final String toString() {
        return ToString.builder((String)"RedisSettings").add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("SslSecurityProtocol", (Object)this.sslSecurityProtocolAsString()).add("AuthType", (Object)this.authTypeAsString()).add("AuthUserName", (Object)this.authUserName()).add("AuthPassword", (Object)(this.authPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("SslCaCertificateArn", (Object)this.sslCaCertificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "SslSecurityProtocol": {
                return Optional.ofNullable(clazz.cast(this.sslSecurityProtocolAsString()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "AuthUserName": {
                return Optional.ofNullable(clazz.cast(this.authUserName()));
            }
            case "AuthPassword": {
                return Optional.ofNullable(clazz.cast(this.authPassword()));
            }
            case "SslCaCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.sslCaCertificateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RedisSettings, T> g) {
        return obj -> g.apply((RedisSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serverName;
        private Integer port;
        private String sslSecurityProtocol;
        private String authType;
        private String authUserName;
        private String authPassword;
        private String sslCaCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RedisSettings model) {
            this.serverName(model.serverName);
            this.port(model.port);
            this.sslSecurityProtocol(model.sslSecurityProtocol);
            this.authType(model.authType);
            this.authUserName(model.authUserName);
            this.authPassword(model.authPassword);
            this.sslCaCertificateArn(model.sslCaCertificateArn);
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslSecurityProtocol() {
            return this.sslSecurityProtocol;
        }

        public final void setSslSecurityProtocol(String sslSecurityProtocol) {
            this.sslSecurityProtocol = sslSecurityProtocol;
        }

        @Override
        public final Builder sslSecurityProtocol(String sslSecurityProtocol) {
            this.sslSecurityProtocol = sslSecurityProtocol;
            return this;
        }

        @Override
        public final Builder sslSecurityProtocol(SslSecurityProtocolValue sslSecurityProtocol) {
            this.sslSecurityProtocol(sslSecurityProtocol == null ? null : sslSecurityProtocol.toString());
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(RedisAuthTypeValue authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getAuthUserName() {
            return this.authUserName;
        }

        public final void setAuthUserName(String authUserName) {
            this.authUserName = authUserName;
        }

        @Override
        public final Builder authUserName(String authUserName) {
            this.authUserName = authUserName;
            return this;
        }

        public final String getAuthPassword() {
            return this.authPassword;
        }

        public final void setAuthPassword(String authPassword) {
            this.authPassword = authPassword;
        }

        @Override
        public final Builder authPassword(String authPassword) {
            this.authPassword = authPassword;
            return this;
        }

        public final String getSslCaCertificateArn() {
            return this.sslCaCertificateArn;
        }

        public final void setSslCaCertificateArn(String sslCaCertificateArn) {
            this.sslCaCertificateArn = sslCaCertificateArn;
        }

        @Override
        public final Builder sslCaCertificateArn(String sslCaCertificateArn) {
            this.sslCaCertificateArn = sslCaCertificateArn;
            return this;
        }

        public RedisSettings build() {
            return new RedisSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedisSettings> {
        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder sslSecurityProtocol(String var1);

        public Builder sslSecurityProtocol(SslSecurityProtocolValue var1);

        public Builder authType(String var1);

        public Builder authType(RedisAuthTypeValue var1);

        public Builder authUserName(String var1);

        public Builder authPassword(String var1);

        public Builder sslCaCertificateArn(String var1);
    }
}

