/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseShortInfoResponse;
import software.amazon.awssdk.services.databasemigration.model.SchemaShortInfoResponse;
import software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaResponse> {
    private static final SdkField<Long> CODE_LINE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeLineCount").getter(SchemaResponse.getter(SchemaResponse::codeLineCount)).setter(SchemaResponse.setter(Builder::codeLineCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeLineCount").build()}).build();
    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CodeSize").getter(SchemaResponse.getter(SchemaResponse::codeSize)).setter(SchemaResponse.setter(Builder::codeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()}).build();
    private static final SdkField<String> COMPLEXITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Complexity").getter(SchemaResponse.getter(SchemaResponse::complexity)).setter(SchemaResponse.setter(Builder::complexity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Complexity").build()}).build();
    private static final SdkField<ServerShortInfoResponse> SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Server").getter(SchemaResponse.getter(SchemaResponse::server)).setter(SchemaResponse.setter(Builder::server)).constructor(ServerShortInfoResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Server").build()}).build();
    private static final SdkField<DatabaseShortInfoResponse> DATABASE_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DatabaseInstance").getter(SchemaResponse.getter(SchemaResponse::databaseInstance)).setter(SchemaResponse.setter(Builder::databaseInstance)).constructor(DatabaseShortInfoResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstance").build()}).build();
    private static final SdkField<String> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaId").getter(SchemaResponse.getter(SchemaResponse::schemaId)).setter(SchemaResponse.setter(Builder::schemaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(SchemaResponse.getter(SchemaResponse::schemaName)).setter(SchemaResponse.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<SchemaShortInfoResponse> ORIGINAL_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginalSchema").getter(SchemaResponse.getter(SchemaResponse::originalSchema)).setter(SchemaResponse.setter(Builder::originalSchema)).constructor(SchemaShortInfoResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalSchema").build()}).build();
    private static final SdkField<Double> SIMILARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Similarity").getter(SchemaResponse.getter(SchemaResponse::similarity)).setter(SchemaResponse.setter(Builder::similarity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Similarity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_LINE_COUNT_FIELD, CODE_SIZE_FIELD, COMPLEXITY_FIELD, SERVER_FIELD, DATABASE_INSTANCE_FIELD, SCHEMA_ID_FIELD, SCHEMA_NAME_FIELD, ORIGINAL_SCHEMA_FIELD, SIMILARITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CodeLineCount", CODE_LINE_COUNT_FIELD);
            this.put("CodeSize", CODE_SIZE_FIELD);
            this.put("Complexity", COMPLEXITY_FIELD);
            this.put("Server", SERVER_FIELD);
            this.put("DatabaseInstance", DATABASE_INSTANCE_FIELD);
            this.put("SchemaId", SCHEMA_ID_FIELD);
            this.put("SchemaName", SCHEMA_NAME_FIELD);
            this.put("OriginalSchema", ORIGINAL_SCHEMA_FIELD);
            this.put("Similarity", SIMILARITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Long codeLineCount;
    private final Long codeSize;
    private final String complexity;
    private final ServerShortInfoResponse server;
    private final DatabaseShortInfoResponse databaseInstance;
    private final String schemaId;
    private final String schemaName;
    private final SchemaShortInfoResponse originalSchema;
    private final Double similarity;

    private SchemaResponse(BuilderImpl builder) {
        this.codeLineCount = builder.codeLineCount;
        this.codeSize = builder.codeSize;
        this.complexity = builder.complexity;
        this.server = builder.server;
        this.databaseInstance = builder.databaseInstance;
        this.schemaId = builder.schemaId;
        this.schemaName = builder.schemaName;
        this.originalSchema = builder.originalSchema;
        this.similarity = builder.similarity;
    }

    public final Long codeLineCount() {
        return this.codeLineCount;
    }

    public final Long codeSize() {
        return this.codeSize;
    }

    public final String complexity() {
        return this.complexity;
    }

    public final ServerShortInfoResponse server() {
        return this.server;
    }

    public final DatabaseShortInfoResponse databaseInstance() {
        return this.databaseInstance;
    }

    public final String schemaId() {
        return this.schemaId;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final SchemaShortInfoResponse originalSchema() {
        return this.originalSchema;
    }

    public final Double similarity() {
        return this.similarity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeLineCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.complexity());
        hashCode = 31 * hashCode + Objects.hashCode(this.server());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.similarity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaResponse)) {
            return false;
        }
        SchemaResponse other = (SchemaResponse)obj;
        return Objects.equals(this.codeLineCount(), other.codeLineCount()) && Objects.equals(this.codeSize(), other.codeSize()) && Objects.equals(this.complexity(), other.complexity()) && Objects.equals(this.server(), other.server()) && Objects.equals(this.databaseInstance(), other.databaseInstance()) && Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.originalSchema(), other.originalSchema()) && Objects.equals(this.similarity(), other.similarity());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaResponse").add("CodeLineCount", (Object)this.codeLineCount()).add("CodeSize", (Object)this.codeSize()).add("Complexity", (Object)this.complexity()).add("Server", (Object)this.server()).add("DatabaseInstance", (Object)this.databaseInstance()).add("SchemaId", (Object)this.schemaId()).add("SchemaName", (Object)this.schemaName()).add("OriginalSchema", (Object)this.originalSchema()).add("Similarity", (Object)this.similarity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeLineCount": {
                return Optional.ofNullable(clazz.cast(this.codeLineCount()));
            }
            case "CodeSize": {
                return Optional.ofNullable(clazz.cast(this.codeSize()));
            }
            case "Complexity": {
                return Optional.ofNullable(clazz.cast(this.complexity()));
            }
            case "Server": {
                return Optional.ofNullable(clazz.cast(this.server()));
            }
            case "DatabaseInstance": {
                return Optional.ofNullable(clazz.cast(this.databaseInstance()));
            }
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "OriginalSchema": {
                return Optional.ofNullable(clazz.cast(this.originalSchema()));
            }
            case "Similarity": {
                return Optional.ofNullable(clazz.cast(this.similarity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SchemaResponse, T> g) {
        return obj -> g.apply((SchemaResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long codeLineCount;
        private Long codeSize;
        private String complexity;
        private ServerShortInfoResponse server;
        private DatabaseShortInfoResponse databaseInstance;
        private String schemaId;
        private String schemaName;
        private SchemaShortInfoResponse originalSchema;
        private Double similarity;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaResponse model) {
            this.codeLineCount(model.codeLineCount);
            this.codeSize(model.codeSize);
            this.complexity(model.complexity);
            this.server(model.server);
            this.databaseInstance(model.databaseInstance);
            this.schemaId(model.schemaId);
            this.schemaName(model.schemaName);
            this.originalSchema(model.originalSchema);
            this.similarity(model.similarity);
        }

        public final Long getCodeLineCount() {
            return this.codeLineCount;
        }

        public final void setCodeLineCount(Long codeLineCount) {
            this.codeLineCount = codeLineCount;
        }

        @Override
        public final Builder codeLineCount(Long codeLineCount) {
            this.codeLineCount = codeLineCount;
            return this;
        }

        public final Long getCodeSize() {
            return this.codeSize;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final String getComplexity() {
            return this.complexity;
        }

        public final void setComplexity(String complexity) {
            this.complexity = complexity;
        }

        @Override
        public final Builder complexity(String complexity) {
            this.complexity = complexity;
            return this;
        }

        public final ServerShortInfoResponse.Builder getServer() {
            return this.server != null ? this.server.toBuilder() : null;
        }

        public final void setServer(ServerShortInfoResponse.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(ServerShortInfoResponse server) {
            this.server = server;
            return this;
        }

        public final DatabaseShortInfoResponse.Builder getDatabaseInstance() {
            return this.databaseInstance != null ? this.databaseInstance.toBuilder() : null;
        }

        public final void setDatabaseInstance(DatabaseShortInfoResponse.BuilderImpl databaseInstance) {
            this.databaseInstance = databaseInstance != null ? databaseInstance.build() : null;
        }

        @Override
        public final Builder databaseInstance(DatabaseShortInfoResponse databaseInstance) {
            this.databaseInstance = databaseInstance;
            return this;
        }

        public final String getSchemaId() {
            return this.schemaId;
        }

        public final void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        @Override
        public final Builder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final SchemaShortInfoResponse.Builder getOriginalSchema() {
            return this.originalSchema != null ? this.originalSchema.toBuilder() : null;
        }

        public final void setOriginalSchema(SchemaShortInfoResponse.BuilderImpl originalSchema) {
            this.originalSchema = originalSchema != null ? originalSchema.build() : null;
        }

        @Override
        public final Builder originalSchema(SchemaShortInfoResponse originalSchema) {
            this.originalSchema = originalSchema;
            return this;
        }

        public final Double getSimilarity() {
            return this.similarity;
        }

        public final void setSimilarity(Double similarity) {
            this.similarity = similarity;
        }

        @Override
        public final Builder similarity(Double similarity) {
            this.similarity = similarity;
            return this;
        }

        public SchemaResponse build() {
            return new SchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaResponse> {
        public Builder codeLineCount(Long var1);

        public Builder codeSize(Long var1);

        public Builder complexity(String var1);

        public Builder server(ServerShortInfoResponse var1);

        default public Builder server(Consumer<ServerShortInfoResponse.Builder> server) {
            return this.server((ServerShortInfoResponse)((ServerShortInfoResponse.Builder)ServerShortInfoResponse.builder().applyMutation(server)).build());
        }

        public Builder databaseInstance(DatabaseShortInfoResponse var1);

        default public Builder databaseInstance(Consumer<DatabaseShortInfoResponse.Builder> databaseInstance) {
            return this.databaseInstance((DatabaseShortInfoResponse)((DatabaseShortInfoResponse.Builder)DatabaseShortInfoResponse.builder().applyMutation(databaseInstance)).build());
        }

        public Builder schemaId(String var1);

        public Builder schemaName(String var1);

        public Builder originalSchema(SchemaShortInfoResponse var1);

        default public Builder originalSchema(Consumer<SchemaShortInfoResponse.Builder> originalSchema) {
            return this.originalSchema((SchemaShortInfoResponse)((SchemaShortInfoResponse.Builder)SchemaShortInfoResponse.builder().applyMutation(originalSchema)).build());
        }

        public Builder similarity(Double var1);
    }
}

