/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse;

public class DescribeReplicationTableStatisticsPublisher
implements SdkPublisher<DescribeReplicationTableStatisticsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationTableStatisticsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationTableStatisticsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationTableStatisticsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationTableStatisticsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationTableStatisticsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationTableStatisticsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationTableStatisticsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReplicationTableStatisticsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationTableStatisticsResponse> {
        private DescribeReplicationTableStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationTableStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationTableStatisticsResponse> nextPage(DescribeReplicationTableStatisticsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationTableStatisticsPublisher.this.client.describeReplicationTableStatistics(DescribeReplicationTableStatisticsPublisher.this.firstRequest);
            }
            return DescribeReplicationTableStatisticsPublisher.this.client.describeReplicationTableStatistics((DescribeReplicationTableStatisticsRequest)((Object)DescribeReplicationTableStatisticsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

