/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;

public class DescribeConnectionsPublisher
implements SdkPublisher<DescribeConnectionsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeConnectionsPublisher(DatabaseMigrationAsyncClient client, DescribeConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeConnectionsPublisher(DatabaseMigrationAsyncClient client, DescribeConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeConnectionsResponse> {
        private DescribeConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeConnectionsResponse> nextPage(DescribeConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeConnectionsPublisher.this.client.describeConnections(DescribeConnectionsPublisher.this.firstRequest);
            }
            return DescribeConnectionsPublisher.this.client.describeConnections((DescribeConnectionsRequest)((Object)DescribeConnectionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

