/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.ArnListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForResourceRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ListTagsForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ListTagsForResourceRequest.getter(ListTagsForResourceRequest::resourceArn)).setter(ListTagsForResourceRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<List<String>> RESOURCE_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceArnList").getter(ListTagsForResourceRequest.getter(ListTagsForResourceRequest::resourceArnList)).setter(ListTagsForResourceRequest.setter(Builder::resourceArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, RESOURCE_ARN_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("ResourceArnList", RESOURCE_ARN_LIST_FIELD);
        }
    });
    private final String resourceArn;
    private final List<String> resourceArnList;

    private ListTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.resourceArnList = builder.resourceArnList;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasResourceArnList() {
        return this.resourceArnList != null && !(this.resourceArnList instanceof SdkAutoConstructList);
    }

    public final List<String> resourceArnList() {
        return this.resourceArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceArnList() ? this.resourceArnList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceRequest)) {
            return false;
        }
        ListTagsForResourceRequest other = (ListTagsForResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasResourceArnList() == other.hasResourceArnList() && Objects.equals(this.resourceArnList(), other.resourceArnList());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsForResourceRequest").add("ResourceArn", (Object)this.resourceArn()).add("ResourceArnList", this.hasResourceArnList() ? this.resourceArnList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceArnList": {
                return Optional.ofNullable(clazz.cast(this.resourceArnList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceRequest, T> g) {
        return obj -> g.apply((ListTagsForResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<String> resourceArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.resourceArnList(model.resourceArnList);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Collection<String> getResourceArnList() {
            if (this.resourceArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceArnList;
        }

        public final void setResourceArnList(Collection<String> resourceArnList) {
            this.resourceArnList = ArnListCopier.copy(resourceArnList);
        }

        @Override
        public final Builder resourceArnList(Collection<String> resourceArnList) {
            this.resourceArnList = ArnListCopier.copy(resourceArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArnList(String ... resourceArnList) {
            this.resourceArnList(Arrays.asList(resourceArnList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForResourceRequest build() {
            return new ListTagsForResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsForResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder resourceArnList(Collection<String> var1);

        public Builder resourceArnList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

