/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.SourceDataSetting;
import software.amazon.awssdk.services.databasemigration.model.SourceDataSettingsCopier;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataMigrationRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateDataMigrationRequest> {
    private static final SdkField<String> DATA_MIGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationName").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::dataMigrationName)).setter(CreateDataMigrationRequest.setter(Builder::dataMigrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationName").build()}).build();
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::migrationProjectIdentifier)).setter(CreateDataMigrationRequest.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> DATA_MIGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataMigrationType").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::dataMigrationTypeAsString)).setter(CreateDataMigrationRequest.setter(Builder::dataMigrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationType").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::serviceAccessRoleArn)).setter(CreateDataMigrationRequest.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_CLOUDWATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCloudwatchLogs").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::enableCloudwatchLogs)).setter(CreateDataMigrationRequest.setter(Builder::enableCloudwatchLogs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogs").build()}).build();
    private static final SdkField<List<SourceDataSetting>> SOURCE_DATA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceDataSettings").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::sourceDataSettings)).setter(CreateDataMigrationRequest.setter(Builder::sourceDataSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceDataSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> NUMBER_OF_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfJobs").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::numberOfJobs)).setter(CreateDataMigrationRequest.setter(Builder::numberOfJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfJobs").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::tags)).setter(CreateDataMigrationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(CreateDataMigrationRequest.getter(CreateDataMigrationRequest::selectionRules)).setter(CreateDataMigrationRequest.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_MIGRATION_NAME_FIELD, MIGRATION_PROJECT_IDENTIFIER_FIELD, DATA_MIGRATION_TYPE_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, ENABLE_CLOUDWATCH_LOGS_FIELD, SOURCE_DATA_SETTINGS_FIELD, NUMBER_OF_JOBS_FIELD, TAGS_FIELD, SELECTION_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataMigrationName", DATA_MIGRATION_NAME_FIELD);
            this.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
            this.put("DataMigrationType", DATA_MIGRATION_TYPE_FIELD);
            this.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
            this.put("EnableCloudwatchLogs", ENABLE_CLOUDWATCH_LOGS_FIELD);
            this.put("SourceDataSettings", SOURCE_DATA_SETTINGS_FIELD);
            this.put("NumberOfJobs", NUMBER_OF_JOBS_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("SelectionRules", SELECTION_RULES_FIELD);
        }
    });
    private final String dataMigrationName;
    private final String migrationProjectIdentifier;
    private final String dataMigrationType;
    private final String serviceAccessRoleArn;
    private final Boolean enableCloudwatchLogs;
    private final List<SourceDataSetting> sourceDataSettings;
    private final Integer numberOfJobs;
    private final List<Tag> tags;
    private final String selectionRules;

    private CreateDataMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.dataMigrationName = builder.dataMigrationName;
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.dataMigrationType = builder.dataMigrationType;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.enableCloudwatchLogs = builder.enableCloudwatchLogs;
        this.sourceDataSettings = builder.sourceDataSettings;
        this.numberOfJobs = builder.numberOfJobs;
        this.tags = builder.tags;
        this.selectionRules = builder.selectionRules;
    }

    public final String dataMigrationName() {
        return this.dataMigrationName;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final MigrationTypeValue dataMigrationType() {
        return MigrationTypeValue.fromValue(this.dataMigrationType);
    }

    public final String dataMigrationTypeAsString() {
        return this.dataMigrationType;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final Boolean enableCloudwatchLogs() {
        return this.enableCloudwatchLogs;
    }

    public final boolean hasSourceDataSettings() {
        return this.sourceDataSettings != null && !(this.sourceDataSettings instanceof SdkAutoConstructList);
    }

    public final List<SourceDataSetting> sourceDataSettings() {
        return this.sourceDataSettings;
    }

    public final Integer numberOfJobs() {
        return this.numberOfJobs;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataMigrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceDataSettings() ? this.sourceDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataMigrationRequest)) {
            return false;
        }
        CreateDataMigrationRequest other = (CreateDataMigrationRequest)((Object)obj);
        return Objects.equals(this.dataMigrationName(), other.dataMigrationName()) && Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.dataMigrationTypeAsString(), other.dataMigrationTypeAsString()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.enableCloudwatchLogs(), other.enableCloudwatchLogs()) && this.hasSourceDataSettings() == other.hasSourceDataSettings() && Objects.equals(this.sourceDataSettings(), other.sourceDataSettings()) && Objects.equals(this.numberOfJobs(), other.numberOfJobs()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.selectionRules(), other.selectionRules());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataMigrationRequest").add("DataMigrationName", (Object)this.dataMigrationName()).add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("DataMigrationType", (Object)this.dataMigrationTypeAsString()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("EnableCloudwatchLogs", (Object)this.enableCloudwatchLogs()).add("SourceDataSettings", this.hasSourceDataSettings() ? this.sourceDataSettings() : null).add("NumberOfJobs", (Object)this.numberOfJobs()).add("Tags", this.hasTags() ? this.tags() : null).add("SelectionRules", (Object)(this.selectionRules() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataMigrationName": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationName()));
            }
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "DataMigrationType": {
                return Optional.ofNullable(clazz.cast(this.dataMigrationTypeAsString()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "EnableCloudwatchLogs": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogs()));
            }
            case "SourceDataSettings": {
                return Optional.ofNullable(clazz.cast(this.sourceDataSettings()));
            }
            case "NumberOfJobs": {
                return Optional.ofNullable(clazz.cast(this.numberOfJobs()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataMigrationRequest, T> g) {
        return obj -> g.apply((CreateDataMigrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String dataMigrationName;
        private String migrationProjectIdentifier;
        private String dataMigrationType;
        private String serviceAccessRoleArn;
        private Boolean enableCloudwatchLogs;
        private List<SourceDataSetting> sourceDataSettings = DefaultSdkAutoConstructList.getInstance();
        private Integer numberOfJobs;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataMigrationRequest model) {
            super(model);
            this.dataMigrationName(model.dataMigrationName);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.dataMigrationType(model.dataMigrationType);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.enableCloudwatchLogs(model.enableCloudwatchLogs);
            this.sourceDataSettings(model.sourceDataSettings);
            this.numberOfJobs(model.numberOfJobs);
            this.tags(model.tags);
            this.selectionRules(model.selectionRules);
        }

        public final String getDataMigrationName() {
            return this.dataMigrationName;
        }

        public final void setDataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
        }

        @Override
        public final Builder dataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
            return this;
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getDataMigrationType() {
            return this.dataMigrationType;
        }

        public final void setDataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
        }

        @Override
        public final Builder dataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
            return this;
        }

        @Override
        public final Builder dataMigrationType(MigrationTypeValue dataMigrationType) {
            this.dataMigrationType(dataMigrationType == null ? null : dataMigrationType.toString());
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final Boolean getEnableCloudwatchLogs() {
            return this.enableCloudwatchLogs;
        }

        public final void setEnableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
        }

        @Override
        public final Builder enableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
            return this;
        }

        public final List<SourceDataSetting.Builder> getSourceDataSettings() {
            List<SourceDataSetting.Builder> result = SourceDataSettingsCopier.copyToBuilder(this.sourceDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSettings(Collection<SourceDataSetting.BuilderImpl> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copyFromBuilder(sourceDataSettings);
        }

        @Override
        public final Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copy(sourceDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(SourceDataSetting ... sourceDataSettings) {
            this.sourceDataSettings(Arrays.asList(sourceDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(Consumer<SourceDataSetting.Builder> ... sourceDataSettings) {
            this.sourceDataSettings(Stream.of(sourceDataSettings).map(c -> (SourceDataSetting)((SourceDataSetting.Builder)SourceDataSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getNumberOfJobs() {
            return this.numberOfJobs;
        }

        public final void setNumberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
        }

        @Override
        public final Builder numberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataMigrationRequest build() {
            return new CreateDataMigrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataMigrationRequest> {
        public Builder dataMigrationName(String var1);

        public Builder migrationProjectIdentifier(String var1);

        public Builder dataMigrationType(String var1);

        public Builder dataMigrationType(MigrationTypeValue var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder enableCloudwatchLogs(Boolean var1);

        public Builder sourceDataSettings(Collection<SourceDataSetting> var1);

        public Builder sourceDataSettings(SourceDataSetting ... var1);

        public Builder sourceDataSettings(Consumer<SourceDataSetting.Builder> ... var1);

        public Builder numberOfJobs(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder selectionRules(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

