/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.AvailabilityZonesListCopier;
import software.amazon.awssdk.services.databasemigration.model.ReleaseStatusValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderableReplicationInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderableReplicationInstance> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::engineVersion)).setter(OrderableReplicationInstance.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceClass").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::replicationInstanceClass)).setter(OrderableReplicationInstance.setter(Builder::replicationInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::storageType)).setter(OrderableReplicationInstance.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Integer> MIN_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAllocatedStorage").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::minAllocatedStorage)).setter(OrderableReplicationInstance.setter(Builder::minAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinAllocatedStorage").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::maxAllocatedStorage)).setter(OrderableReplicationInstance.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<Integer> DEFAULT_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultAllocatedStorage").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::defaultAllocatedStorage)).setter(OrderableReplicationInstance.setter(Builder::defaultAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAllocatedStorage").build()}).build();
    private static final SdkField<Integer> INCLUDED_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IncludedAllocatedStorage").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::includedAllocatedStorage)).setter(OrderableReplicationInstance.setter(Builder::includedAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedAllocatedStorage").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::availabilityZones)).setter(OrderableReplicationInstance.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RELEASE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReleaseStatus").getter(OrderableReplicationInstance.getter(OrderableReplicationInstance::releaseStatusAsString)).setter(OrderableReplicationInstance.setter(Builder::releaseStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReleaseStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD, REPLICATION_INSTANCE_CLASS_FIELD, STORAGE_TYPE_FIELD, MIN_ALLOCATED_STORAGE_FIELD, MAX_ALLOCATED_STORAGE_FIELD, DEFAULT_ALLOCATED_STORAGE_FIELD, INCLUDED_ALLOCATED_STORAGE_FIELD, AVAILABILITY_ZONES_FIELD, RELEASE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EngineVersion", ENGINE_VERSION_FIELD);
            this.put("ReplicationInstanceClass", REPLICATION_INSTANCE_CLASS_FIELD);
            this.put("StorageType", STORAGE_TYPE_FIELD);
            this.put("MinAllocatedStorage", MIN_ALLOCATED_STORAGE_FIELD);
            this.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
            this.put("DefaultAllocatedStorage", DEFAULT_ALLOCATED_STORAGE_FIELD);
            this.put("IncludedAllocatedStorage", INCLUDED_ALLOCATED_STORAGE_FIELD);
            this.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
            this.put("ReleaseStatus", RELEASE_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String engineVersion;
    private final String replicationInstanceClass;
    private final String storageType;
    private final Integer minAllocatedStorage;
    private final Integer maxAllocatedStorage;
    private final Integer defaultAllocatedStorage;
    private final Integer includedAllocatedStorage;
    private final List<String> availabilityZones;
    private final String releaseStatus;

    private OrderableReplicationInstance(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.storageType = builder.storageType;
        this.minAllocatedStorage = builder.minAllocatedStorage;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.defaultAllocatedStorage = builder.defaultAllocatedStorage;
        this.includedAllocatedStorage = builder.includedAllocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.releaseStatus = builder.releaseStatus;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer minAllocatedStorage() {
        return this.minAllocatedStorage;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final Integer defaultAllocatedStorage() {
        return this.defaultAllocatedStorage;
    }

    public final Integer includedAllocatedStorage() {
        return this.includedAllocatedStorage;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final ReleaseStatusValues releaseStatus() {
        return ReleaseStatusValues.fromValue(this.releaseStatus);
    }

    public final String releaseStatusAsString() {
        return this.releaseStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.includedAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableReplicationInstance)) {
            return false;
        }
        OrderableReplicationInstance other = (OrderableReplicationInstance)obj;
        return Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.minAllocatedStorage(), other.minAllocatedStorage()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.defaultAllocatedStorage(), other.defaultAllocatedStorage()) && Objects.equals(this.includedAllocatedStorage(), other.includedAllocatedStorage()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.releaseStatusAsString(), other.releaseStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrderableReplicationInstance").add("EngineVersion", (Object)this.engineVersion()).add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("StorageType", (Object)this.storageType()).add("MinAllocatedStorage", (Object)this.minAllocatedStorage()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("DefaultAllocatedStorage", (Object)this.defaultAllocatedStorage()).add("IncludedAllocatedStorage", (Object)this.includedAllocatedStorage()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("ReleaseStatus", (Object)this.releaseStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "MinAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.minAllocatedStorage()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "DefaultAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.defaultAllocatedStorage()));
            }
            case "IncludedAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.includedAllocatedStorage()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "ReleaseStatus": {
                return Optional.ofNullable(clazz.cast(this.releaseStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OrderableReplicationInstance, T> g) {
        return obj -> g.apply((OrderableReplicationInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineVersion;
        private String replicationInstanceClass;
        private String storageType;
        private Integer minAllocatedStorage;
        private Integer maxAllocatedStorage;
        private Integer defaultAllocatedStorage;
        private Integer includedAllocatedStorage;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String releaseStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableReplicationInstance model) {
            this.engineVersion(model.engineVersion);
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.storageType(model.storageType);
            this.minAllocatedStorage(model.minAllocatedStorage);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.defaultAllocatedStorage(model.defaultAllocatedStorage);
            this.includedAllocatedStorage(model.includedAllocatedStorage);
            this.availabilityZones(model.availabilityZones);
            this.releaseStatus(model.releaseStatus);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getMinAllocatedStorage() {
            return this.minAllocatedStorage;
        }

        public final void setMinAllocatedStorage(Integer minAllocatedStorage) {
            this.minAllocatedStorage = minAllocatedStorage;
        }

        @Override
        public final Builder minAllocatedStorage(Integer minAllocatedStorage) {
            this.minAllocatedStorage = minAllocatedStorage;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Integer getDefaultAllocatedStorage() {
            return this.defaultAllocatedStorage;
        }

        public final void setDefaultAllocatedStorage(Integer defaultAllocatedStorage) {
            this.defaultAllocatedStorage = defaultAllocatedStorage;
        }

        @Override
        public final Builder defaultAllocatedStorage(Integer defaultAllocatedStorage) {
            this.defaultAllocatedStorage = defaultAllocatedStorage;
            return this;
        }

        public final Integer getIncludedAllocatedStorage() {
            return this.includedAllocatedStorage;
        }

        public final void setIncludedAllocatedStorage(Integer includedAllocatedStorage) {
            this.includedAllocatedStorage = includedAllocatedStorage;
        }

        @Override
        public final Builder includedAllocatedStorage(Integer includedAllocatedStorage) {
            this.includedAllocatedStorage = includedAllocatedStorage;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final String getReleaseStatus() {
            return this.releaseStatus;
        }

        public final void setReleaseStatus(String releaseStatus) {
            this.releaseStatus = releaseStatus;
        }

        @Override
        public final Builder releaseStatus(String releaseStatus) {
            this.releaseStatus = releaseStatus;
            return this;
        }

        @Override
        public final Builder releaseStatus(ReleaseStatusValues releaseStatus) {
            this.releaseStatus(releaseStatus == null ? null : releaseStatus.toString());
            return this;
        }

        public OrderableReplicationInstance build() {
            return new OrderableReplicationInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderableReplicationInstance> {
        public Builder engineVersion(String var1);

        public Builder replicationInstanceClass(String var1);

        public Builder storageType(String var1);

        public Builder minAllocatedStorage(Integer var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder defaultAllocatedStorage(Integer var1);

        public Builder includedAllocatedStorage(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder releaseStatus(String var1);

        public Builder releaseStatus(ReleaseStatusValues var1);
    }
}

