/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableStatistics> {
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaName").getter(TableStatistics.getter(TableStatistics::schemaName)).setter(TableStatistics.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(TableStatistics.getter(TableStatistics::tableName)).setter(TableStatistics.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Long> INSERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Inserts").getter(TableStatistics.getter(TableStatistics::inserts)).setter(TableStatistics.setter(Builder::inserts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inserts").build()}).build();
    private static final SdkField<Long> DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Deletes").getter(TableStatistics.getter(TableStatistics::deletes)).setter(TableStatistics.setter(Builder::deletes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deletes").build()}).build();
    private static final SdkField<Long> UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Updates").getter(TableStatistics.getter(TableStatistics::updates)).setter(TableStatistics.setter(Builder::updates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Updates").build()}).build();
    private static final SdkField<Long> DDLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Ddls").getter(TableStatistics.getter(TableStatistics::ddls)).setter(TableStatistics.setter(Builder::ddls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ddls").build()}).build();
    private static final SdkField<Long> APPLIED_INSERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AppliedInserts").getter(TableStatistics.getter(TableStatistics::appliedInserts)).setter(TableStatistics.setter(Builder::appliedInserts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedInserts").build()}).build();
    private static final SdkField<Long> APPLIED_DELETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AppliedDeletes").getter(TableStatistics.getter(TableStatistics::appliedDeletes)).setter(TableStatistics.setter(Builder::appliedDeletes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedDeletes").build()}).build();
    private static final SdkField<Long> APPLIED_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AppliedUpdates").getter(TableStatistics.getter(TableStatistics::appliedUpdates)).setter(TableStatistics.setter(Builder::appliedUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedUpdates").build()}).build();
    private static final SdkField<Long> APPLIED_DDLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AppliedDdls").getter(TableStatistics.getter(TableStatistics::appliedDdls)).setter(TableStatistics.setter(Builder::appliedDdls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedDdls").build()}).build();
    private static final SdkField<Long> FULL_LOAD_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FullLoadRows").getter(TableStatistics.getter(TableStatistics::fullLoadRows)).setter(TableStatistics.setter(Builder::fullLoadRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadRows").build()}).build();
    private static final SdkField<Long> FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FullLoadCondtnlChkFailedRows").getter(TableStatistics.getter(TableStatistics::fullLoadCondtnlChkFailedRows)).setter(TableStatistics.setter(Builder::fullLoadCondtnlChkFailedRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadCondtnlChkFailedRows").build()}).build();
    private static final SdkField<Long> FULL_LOAD_ERROR_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FullLoadErrorRows").getter(TableStatistics.getter(TableStatistics::fullLoadErrorRows)).setter(TableStatistics.setter(Builder::fullLoadErrorRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadErrorRows").build()}).build();
    private static final SdkField<Instant> FULL_LOAD_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FullLoadStartTime").getter(TableStatistics.getter(TableStatistics::fullLoadStartTime)).setter(TableStatistics.setter(Builder::fullLoadStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadStartTime").build()}).build();
    private static final SdkField<Instant> FULL_LOAD_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("FullLoadEndTime").getter(TableStatistics.getter(TableStatistics::fullLoadEndTime)).setter(TableStatistics.setter(Builder::fullLoadEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadEndTime").build()}).build();
    private static final SdkField<Boolean> FULL_LOAD_RELOADED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FullLoadReloaded").getter(TableStatistics.getter(TableStatistics::fullLoadReloaded)).setter(TableStatistics.setter(Builder::fullLoadReloaded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FullLoadReloaded").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(TableStatistics.getter(TableStatistics::lastUpdateTime)).setter(TableStatistics.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build()}).build();
    private static final SdkField<String> TABLE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableState").getter(TableStatistics.getter(TableStatistics::tableState)).setter(TableStatistics.setter(Builder::tableState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableState").build()}).build();
    private static final SdkField<Long> VALIDATION_PENDING_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ValidationPendingRecords").getter(TableStatistics.getter(TableStatistics::validationPendingRecords)).setter(TableStatistics.setter(Builder::validationPendingRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationPendingRecords").build()}).build();
    private static final SdkField<Long> VALIDATION_FAILED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ValidationFailedRecords").getter(TableStatistics.getter(TableStatistics::validationFailedRecords)).setter(TableStatistics.setter(Builder::validationFailedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationFailedRecords").build()}).build();
    private static final SdkField<Long> VALIDATION_SUSPENDED_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ValidationSuspendedRecords").getter(TableStatistics.getter(TableStatistics::validationSuspendedRecords)).setter(TableStatistics.setter(Builder::validationSuspendedRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationSuspendedRecords").build()}).build();
    private static final SdkField<String> VALIDATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationState").getter(TableStatistics.getter(TableStatistics::validationState)).setter(TableStatistics.setter(Builder::validationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationState").build()}).build();
    private static final SdkField<String> VALIDATION_STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationStateDetails").getter(TableStatistics.getter(TableStatistics::validationStateDetails)).setter(TableStatistics.setter(Builder::validationStateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationStateDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_FIELD, TABLE_NAME_FIELD, INSERTS_FIELD, DELETES_FIELD, UPDATES_FIELD, DDLS_FIELD, APPLIED_INSERTS_FIELD, APPLIED_DELETES_FIELD, APPLIED_UPDATES_FIELD, APPLIED_DDLS_FIELD, FULL_LOAD_ROWS_FIELD, FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD, FULL_LOAD_ERROR_ROWS_FIELD, FULL_LOAD_START_TIME_FIELD, FULL_LOAD_END_TIME_FIELD, FULL_LOAD_RELOADED_FIELD, LAST_UPDATE_TIME_FIELD, TABLE_STATE_FIELD, VALIDATION_PENDING_RECORDS_FIELD, VALIDATION_FAILED_RECORDS_FIELD, VALIDATION_SUSPENDED_RECORDS_FIELD, VALIDATION_STATE_FIELD, VALIDATION_STATE_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SchemaName", SCHEMA_NAME_FIELD);
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("Inserts", INSERTS_FIELD);
            this.put("Deletes", DELETES_FIELD);
            this.put("Updates", UPDATES_FIELD);
            this.put("Ddls", DDLS_FIELD);
            this.put("AppliedInserts", APPLIED_INSERTS_FIELD);
            this.put("AppliedDeletes", APPLIED_DELETES_FIELD);
            this.put("AppliedUpdates", APPLIED_UPDATES_FIELD);
            this.put("AppliedDdls", APPLIED_DDLS_FIELD);
            this.put("FullLoadRows", FULL_LOAD_ROWS_FIELD);
            this.put("FullLoadCondtnlChkFailedRows", FULL_LOAD_CONDTNL_CHK_FAILED_ROWS_FIELD);
            this.put("FullLoadErrorRows", FULL_LOAD_ERROR_ROWS_FIELD);
            this.put("FullLoadStartTime", FULL_LOAD_START_TIME_FIELD);
            this.put("FullLoadEndTime", FULL_LOAD_END_TIME_FIELD);
            this.put("FullLoadReloaded", FULL_LOAD_RELOADED_FIELD);
            this.put("LastUpdateTime", LAST_UPDATE_TIME_FIELD);
            this.put("TableState", TABLE_STATE_FIELD);
            this.put("ValidationPendingRecords", VALIDATION_PENDING_RECORDS_FIELD);
            this.put("ValidationFailedRecords", VALIDATION_FAILED_RECORDS_FIELD);
            this.put("ValidationSuspendedRecords", VALIDATION_SUSPENDED_RECORDS_FIELD);
            this.put("ValidationState", VALIDATION_STATE_FIELD);
            this.put("ValidationStateDetails", VALIDATION_STATE_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String schemaName;
    private final String tableName;
    private final Long inserts;
    private final Long deletes;
    private final Long updates;
    private final Long ddls;
    private final Long appliedInserts;
    private final Long appliedDeletes;
    private final Long appliedUpdates;
    private final Long appliedDdls;
    private final Long fullLoadRows;
    private final Long fullLoadCondtnlChkFailedRows;
    private final Long fullLoadErrorRows;
    private final Instant fullLoadStartTime;
    private final Instant fullLoadEndTime;
    private final Boolean fullLoadReloaded;
    private final Instant lastUpdateTime;
    private final String tableState;
    private final Long validationPendingRecords;
    private final Long validationFailedRecords;
    private final Long validationSuspendedRecords;
    private final String validationState;
    private final String validationStateDetails;

    private TableStatistics(BuilderImpl builder) {
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.inserts = builder.inserts;
        this.deletes = builder.deletes;
        this.updates = builder.updates;
        this.ddls = builder.ddls;
        this.appliedInserts = builder.appliedInserts;
        this.appliedDeletes = builder.appliedDeletes;
        this.appliedUpdates = builder.appliedUpdates;
        this.appliedDdls = builder.appliedDdls;
        this.fullLoadRows = builder.fullLoadRows;
        this.fullLoadCondtnlChkFailedRows = builder.fullLoadCondtnlChkFailedRows;
        this.fullLoadErrorRows = builder.fullLoadErrorRows;
        this.fullLoadStartTime = builder.fullLoadStartTime;
        this.fullLoadEndTime = builder.fullLoadEndTime;
        this.fullLoadReloaded = builder.fullLoadReloaded;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.tableState = builder.tableState;
        this.validationPendingRecords = builder.validationPendingRecords;
        this.validationFailedRecords = builder.validationFailedRecords;
        this.validationSuspendedRecords = builder.validationSuspendedRecords;
        this.validationState = builder.validationState;
        this.validationStateDetails = builder.validationStateDetails;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final Long inserts() {
        return this.inserts;
    }

    public final Long deletes() {
        return this.deletes;
    }

    public final Long updates() {
        return this.updates;
    }

    public final Long ddls() {
        return this.ddls;
    }

    public final Long appliedInserts() {
        return this.appliedInserts;
    }

    public final Long appliedDeletes() {
        return this.appliedDeletes;
    }

    public final Long appliedUpdates() {
        return this.appliedUpdates;
    }

    public final Long appliedDdls() {
        return this.appliedDdls;
    }

    public final Long fullLoadRows() {
        return this.fullLoadRows;
    }

    public final Long fullLoadCondtnlChkFailedRows() {
        return this.fullLoadCondtnlChkFailedRows;
    }

    public final Long fullLoadErrorRows() {
        return this.fullLoadErrorRows;
    }

    public final Instant fullLoadStartTime() {
        return this.fullLoadStartTime;
    }

    public final Instant fullLoadEndTime() {
        return this.fullLoadEndTime;
    }

    public final Boolean fullLoadReloaded() {
        return this.fullLoadReloaded;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public final String tableState() {
        return this.tableState;
    }

    public final Long validationPendingRecords() {
        return this.validationPendingRecords;
    }

    public final Long validationFailedRecords() {
        return this.validationFailedRecords;
    }

    public final Long validationSuspendedRecords() {
        return this.validationSuspendedRecords;
    }

    public final String validationState() {
        return this.validationState;
    }

    public final String validationStateDetails() {
        return this.validationStateDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inserts());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletes());
        hashCode = 31 * hashCode + Objects.hashCode(this.updates());
        hashCode = 31 * hashCode + Objects.hashCode(this.ddls());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedInserts());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedDeletes());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedDdls());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadCondtnlChkFailedRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadErrorRows());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fullLoadReloaded());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableState());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationPendingRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationFailedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSuspendedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStateDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableStatistics)) {
            return false;
        }
        TableStatistics other = (TableStatistics)obj;
        return Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.inserts(), other.inserts()) && Objects.equals(this.deletes(), other.deletes()) && Objects.equals(this.updates(), other.updates()) && Objects.equals(this.ddls(), other.ddls()) && Objects.equals(this.appliedInserts(), other.appliedInserts()) && Objects.equals(this.appliedDeletes(), other.appliedDeletes()) && Objects.equals(this.appliedUpdates(), other.appliedUpdates()) && Objects.equals(this.appliedDdls(), other.appliedDdls()) && Objects.equals(this.fullLoadRows(), other.fullLoadRows()) && Objects.equals(this.fullLoadCondtnlChkFailedRows(), other.fullLoadCondtnlChkFailedRows()) && Objects.equals(this.fullLoadErrorRows(), other.fullLoadErrorRows()) && Objects.equals(this.fullLoadStartTime(), other.fullLoadStartTime()) && Objects.equals(this.fullLoadEndTime(), other.fullLoadEndTime()) && Objects.equals(this.fullLoadReloaded(), other.fullLoadReloaded()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(this.tableState(), other.tableState()) && Objects.equals(this.validationPendingRecords(), other.validationPendingRecords()) && Objects.equals(this.validationFailedRecords(), other.validationFailedRecords()) && Objects.equals(this.validationSuspendedRecords(), other.validationSuspendedRecords()) && Objects.equals(this.validationState(), other.validationState()) && Objects.equals(this.validationStateDetails(), other.validationStateDetails());
    }

    public final String toString() {
        return ToString.builder((String)"TableStatistics").add("SchemaName", (Object)this.schemaName()).add("TableName", (Object)this.tableName()).add("Inserts", (Object)this.inserts()).add("Deletes", (Object)this.deletes()).add("Updates", (Object)this.updates()).add("Ddls", (Object)this.ddls()).add("AppliedInserts", (Object)this.appliedInserts()).add("AppliedDeletes", (Object)this.appliedDeletes()).add("AppliedUpdates", (Object)this.appliedUpdates()).add("AppliedDdls", (Object)this.appliedDdls()).add("FullLoadRows", (Object)this.fullLoadRows()).add("FullLoadCondtnlChkFailedRows", (Object)this.fullLoadCondtnlChkFailedRows()).add("FullLoadErrorRows", (Object)this.fullLoadErrorRows()).add("FullLoadStartTime", (Object)this.fullLoadStartTime()).add("FullLoadEndTime", (Object)this.fullLoadEndTime()).add("FullLoadReloaded", (Object)this.fullLoadReloaded()).add("LastUpdateTime", (Object)this.lastUpdateTime()).add("TableState", (Object)this.tableState()).add("ValidationPendingRecords", (Object)this.validationPendingRecords()).add("ValidationFailedRecords", (Object)this.validationFailedRecords()).add("ValidationSuspendedRecords", (Object)this.validationSuspendedRecords()).add("ValidationState", (Object)this.validationState()).add("ValidationStateDetails", (Object)this.validationStateDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Inserts": {
                return Optional.ofNullable(clazz.cast(this.inserts()));
            }
            case "Deletes": {
                return Optional.ofNullable(clazz.cast(this.deletes()));
            }
            case "Updates": {
                return Optional.ofNullable(clazz.cast(this.updates()));
            }
            case "Ddls": {
                return Optional.ofNullable(clazz.cast(this.ddls()));
            }
            case "AppliedInserts": {
                return Optional.ofNullable(clazz.cast(this.appliedInserts()));
            }
            case "AppliedDeletes": {
                return Optional.ofNullable(clazz.cast(this.appliedDeletes()));
            }
            case "AppliedUpdates": {
                return Optional.ofNullable(clazz.cast(this.appliedUpdates()));
            }
            case "AppliedDdls": {
                return Optional.ofNullable(clazz.cast(this.appliedDdls()));
            }
            case "FullLoadRows": {
                return Optional.ofNullable(clazz.cast(this.fullLoadRows()));
            }
            case "FullLoadCondtnlChkFailedRows": {
                return Optional.ofNullable(clazz.cast(this.fullLoadCondtnlChkFailedRows()));
            }
            case "FullLoadErrorRows": {
                return Optional.ofNullable(clazz.cast(this.fullLoadErrorRows()));
            }
            case "FullLoadStartTime": {
                return Optional.ofNullable(clazz.cast(this.fullLoadStartTime()));
            }
            case "FullLoadEndTime": {
                return Optional.ofNullable(clazz.cast(this.fullLoadEndTime()));
            }
            case "FullLoadReloaded": {
                return Optional.ofNullable(clazz.cast(this.fullLoadReloaded()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
            case "TableState": {
                return Optional.ofNullable(clazz.cast(this.tableState()));
            }
            case "ValidationPendingRecords": {
                return Optional.ofNullable(clazz.cast(this.validationPendingRecords()));
            }
            case "ValidationFailedRecords": {
                return Optional.ofNullable(clazz.cast(this.validationFailedRecords()));
            }
            case "ValidationSuspendedRecords": {
                return Optional.ofNullable(clazz.cast(this.validationSuspendedRecords()));
            }
            case "ValidationState": {
                return Optional.ofNullable(clazz.cast(this.validationState()));
            }
            case "ValidationStateDetails": {
                return Optional.ofNullable(clazz.cast(this.validationStateDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableStatistics, T> g) {
        return obj -> g.apply((TableStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaName;
        private String tableName;
        private Long inserts;
        private Long deletes;
        private Long updates;
        private Long ddls;
        private Long appliedInserts;
        private Long appliedDeletes;
        private Long appliedUpdates;
        private Long appliedDdls;
        private Long fullLoadRows;
        private Long fullLoadCondtnlChkFailedRows;
        private Long fullLoadErrorRows;
        private Instant fullLoadStartTime;
        private Instant fullLoadEndTime;
        private Boolean fullLoadReloaded;
        private Instant lastUpdateTime;
        private String tableState;
        private Long validationPendingRecords;
        private Long validationFailedRecords;
        private Long validationSuspendedRecords;
        private String validationState;
        private String validationStateDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(TableStatistics model) {
            this.schemaName(model.schemaName);
            this.tableName(model.tableName);
            this.inserts(model.inserts);
            this.deletes(model.deletes);
            this.updates(model.updates);
            this.ddls(model.ddls);
            this.appliedInserts(model.appliedInserts);
            this.appliedDeletes(model.appliedDeletes);
            this.appliedUpdates(model.appliedUpdates);
            this.appliedDdls(model.appliedDdls);
            this.fullLoadRows(model.fullLoadRows);
            this.fullLoadCondtnlChkFailedRows(model.fullLoadCondtnlChkFailedRows);
            this.fullLoadErrorRows(model.fullLoadErrorRows);
            this.fullLoadStartTime(model.fullLoadStartTime);
            this.fullLoadEndTime(model.fullLoadEndTime);
            this.fullLoadReloaded(model.fullLoadReloaded);
            this.lastUpdateTime(model.lastUpdateTime);
            this.tableState(model.tableState);
            this.validationPendingRecords(model.validationPendingRecords);
            this.validationFailedRecords(model.validationFailedRecords);
            this.validationSuspendedRecords(model.validationSuspendedRecords);
            this.validationState(model.validationState);
            this.validationStateDetails(model.validationStateDetails);
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Long getInserts() {
            return this.inserts;
        }

        public final void setInserts(Long inserts) {
            this.inserts = inserts;
        }

        @Override
        public final Builder inserts(Long inserts) {
            this.inserts = inserts;
            return this;
        }

        public final Long getDeletes() {
            return this.deletes;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final Long getUpdates() {
            return this.updates;
        }

        public final void setUpdates(Long updates) {
            this.updates = updates;
        }

        @Override
        public final Builder updates(Long updates) {
            this.updates = updates;
            return this;
        }

        public final Long getDdls() {
            return this.ddls;
        }

        public final void setDdls(Long ddls) {
            this.ddls = ddls;
        }

        @Override
        public final Builder ddls(Long ddls) {
            this.ddls = ddls;
            return this;
        }

        public final Long getAppliedInserts() {
            return this.appliedInserts;
        }

        public final void setAppliedInserts(Long appliedInserts) {
            this.appliedInserts = appliedInserts;
        }

        @Override
        public final Builder appliedInserts(Long appliedInserts) {
            this.appliedInserts = appliedInserts;
            return this;
        }

        public final Long getAppliedDeletes() {
            return this.appliedDeletes;
        }

        public final void setAppliedDeletes(Long appliedDeletes) {
            this.appliedDeletes = appliedDeletes;
        }

        @Override
        public final Builder appliedDeletes(Long appliedDeletes) {
            this.appliedDeletes = appliedDeletes;
            return this;
        }

        public final Long getAppliedUpdates() {
            return this.appliedUpdates;
        }

        public final void setAppliedUpdates(Long appliedUpdates) {
            this.appliedUpdates = appliedUpdates;
        }

        @Override
        public final Builder appliedUpdates(Long appliedUpdates) {
            this.appliedUpdates = appliedUpdates;
            return this;
        }

        public final Long getAppliedDdls() {
            return this.appliedDdls;
        }

        public final void setAppliedDdls(Long appliedDdls) {
            this.appliedDdls = appliedDdls;
        }

        @Override
        public final Builder appliedDdls(Long appliedDdls) {
            this.appliedDdls = appliedDdls;
            return this;
        }

        public final Long getFullLoadRows() {
            return this.fullLoadRows;
        }

        public final void setFullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
        }

        @Override
        public final Builder fullLoadRows(Long fullLoadRows) {
            this.fullLoadRows = fullLoadRows;
            return this;
        }

        public final Long getFullLoadCondtnlChkFailedRows() {
            return this.fullLoadCondtnlChkFailedRows;
        }

        public final void setFullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
        }

        @Override
        public final Builder fullLoadCondtnlChkFailedRows(Long fullLoadCondtnlChkFailedRows) {
            this.fullLoadCondtnlChkFailedRows = fullLoadCondtnlChkFailedRows;
            return this;
        }

        public final Long getFullLoadErrorRows() {
            return this.fullLoadErrorRows;
        }

        public final void setFullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
        }

        @Override
        public final Builder fullLoadErrorRows(Long fullLoadErrorRows) {
            this.fullLoadErrorRows = fullLoadErrorRows;
            return this;
        }

        public final Instant getFullLoadStartTime() {
            return this.fullLoadStartTime;
        }

        public final void setFullLoadStartTime(Instant fullLoadStartTime) {
            this.fullLoadStartTime = fullLoadStartTime;
        }

        @Override
        public final Builder fullLoadStartTime(Instant fullLoadStartTime) {
            this.fullLoadStartTime = fullLoadStartTime;
            return this;
        }

        public final Instant getFullLoadEndTime() {
            return this.fullLoadEndTime;
        }

        public final void setFullLoadEndTime(Instant fullLoadEndTime) {
            this.fullLoadEndTime = fullLoadEndTime;
        }

        @Override
        public final Builder fullLoadEndTime(Instant fullLoadEndTime) {
            this.fullLoadEndTime = fullLoadEndTime;
            return this;
        }

        public final Boolean getFullLoadReloaded() {
            return this.fullLoadReloaded;
        }

        public final void setFullLoadReloaded(Boolean fullLoadReloaded) {
            this.fullLoadReloaded = fullLoadReloaded;
        }

        @Override
        public final Builder fullLoadReloaded(Boolean fullLoadReloaded) {
            this.fullLoadReloaded = fullLoadReloaded;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getTableState() {
            return this.tableState;
        }

        public final void setTableState(String tableState) {
            this.tableState = tableState;
        }

        @Override
        public final Builder tableState(String tableState) {
            this.tableState = tableState;
            return this;
        }

        public final Long getValidationPendingRecords() {
            return this.validationPendingRecords;
        }

        public final void setValidationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
        }

        @Override
        public final Builder validationPendingRecords(Long validationPendingRecords) {
            this.validationPendingRecords = validationPendingRecords;
            return this;
        }

        public final Long getValidationFailedRecords() {
            return this.validationFailedRecords;
        }

        public final void setValidationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
        }

        @Override
        public final Builder validationFailedRecords(Long validationFailedRecords) {
            this.validationFailedRecords = validationFailedRecords;
            return this;
        }

        public final Long getValidationSuspendedRecords() {
            return this.validationSuspendedRecords;
        }

        public final void setValidationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
        }

        @Override
        public final Builder validationSuspendedRecords(Long validationSuspendedRecords) {
            this.validationSuspendedRecords = validationSuspendedRecords;
            return this;
        }

        public final String getValidationState() {
            return this.validationState;
        }

        public final void setValidationState(String validationState) {
            this.validationState = validationState;
        }

        @Override
        public final Builder validationState(String validationState) {
            this.validationState = validationState;
            return this;
        }

        public final String getValidationStateDetails() {
            return this.validationStateDetails;
        }

        public final void setValidationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
        }

        @Override
        public final Builder validationStateDetails(String validationStateDetails) {
            this.validationStateDetails = validationStateDetails;
            return this;
        }

        public TableStatistics build() {
            return new TableStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableStatistics> {
        public Builder schemaName(String var1);

        public Builder tableName(String var1);

        public Builder inserts(Long var1);

        public Builder deletes(Long var1);

        public Builder updates(Long var1);

        public Builder ddls(Long var1);

        public Builder appliedInserts(Long var1);

        public Builder appliedDeletes(Long var1);

        public Builder appliedUpdates(Long var1);

        public Builder appliedDdls(Long var1);

        public Builder fullLoadRows(Long var1);

        public Builder fullLoadCondtnlChkFailedRows(Long var1);

        public Builder fullLoadErrorRows(Long var1);

        public Builder fullLoadStartTime(Instant var1);

        public Builder fullLoadEndTime(Instant var1);

        public Builder fullLoadReloaded(Boolean var1);

        public Builder lastUpdateTime(Instant var1);

        public Builder tableState(String var1);

        public Builder validationPendingRecords(Long var1);

        public Builder validationFailedRecords(Long var1);

        public Builder validationSuspendedRecords(Long var1);

        public Builder validationState(String var1);

        public Builder validationStateDetails(String var1);
    }
}

