/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.ComputeConfig;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReplicationConfigRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateReplicationConfigRequest> {
    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigIdentifier").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::replicationConfigIdentifier)).setter(CreateReplicationConfigRequest.setter(Builder::replicationConfigIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEndpointArn").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::sourceEndpointArn)).setter(CreateReplicationConfigRequest.setter(Builder::sourceEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()}).build();
    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEndpointArn").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::targetEndpointArn)).setter(CreateReplicationConfigRequest.setter(Builder::targetEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()}).build();
    private static final SdkField<ComputeConfig> COMPUTE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ComputeConfig").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::computeConfig)).setter(CreateReplicationConfigRequest.setter(Builder::computeConfig)).constructor(ComputeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeConfig").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationType").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::replicationTypeAsString)).setter(CreateReplicationConfigRequest.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()}).build();
    private static final SdkField<String> TABLE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableMappings").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::tableMappings)).setter(CreateReplicationConfigRequest.setter(Builder::tableMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableMappings").build()}).build();
    private static final SdkField<String> REPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSettings").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::replicationSettings)).setter(CreateReplicationConfigRequest.setter(Builder::replicationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSettings").build()}).build();
    private static final SdkField<String> SUPPLEMENTAL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupplementalSettings").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::supplementalSettings)).setter(CreateReplicationConfigRequest.setter(Builder::supplementalSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupplementalSettings").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::resourceIdentifier)).setter(CreateReplicationConfigRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateReplicationConfigRequest.getter(CreateReplicationConfigRequest::tags)).setter(CreateReplicationConfigRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_IDENTIFIER_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD, COMPUTE_CONFIG_FIELD, REPLICATION_TYPE_FIELD, TABLE_MAPPINGS_FIELD, REPLICATION_SETTINGS_FIELD, SUPPLEMENTAL_SETTINGS_FIELD, RESOURCE_IDENTIFIER_FIELD, TAGS_FIELD));
    private final String replicationConfigIdentifier;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;
    private final ComputeConfig computeConfig;
    private final String replicationType;
    private final String tableMappings;
    private final String replicationSettings;
    private final String supplementalSettings;
    private final String resourceIdentifier;
    private final List<Tag> tags;

    private CreateReplicationConfigRequest(BuilderImpl builder) {
        super(builder);
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.computeConfig = builder.computeConfig;
        this.replicationType = builder.replicationType;
        this.tableMappings = builder.tableMappings;
        this.replicationSettings = builder.replicationSettings;
        this.supplementalSettings = builder.supplementalSettings;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.tags = builder.tags;
    }

    public final String replicationConfigIdentifier() {
        return this.replicationConfigIdentifier;
    }

    public final String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public final String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    public final ComputeConfig computeConfig() {
        return this.computeConfig;
    }

    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final String tableMappings() {
        return this.tableMappings;
    }

    public final String replicationSettings() {
        return this.replicationSettings;
    }

    public final String supplementalSettings() {
        return this.supplementalSettings;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.supplementalSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationConfigRequest)) {
            return false;
        }
        CreateReplicationConfigRequest other = (CreateReplicationConfigRequest)((Object)obj);
        return Objects.equals(this.replicationConfigIdentifier(), other.replicationConfigIdentifier()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(this.computeConfig(), other.computeConfig()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.tableMappings(), other.tableMappings()) && Objects.equals(this.replicationSettings(), other.replicationSettings()) && Objects.equals(this.supplementalSettings(), other.supplementalSettings()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReplicationConfigRequest").add("ReplicationConfigIdentifier", (Object)this.replicationConfigIdentifier()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).add("ComputeConfig", (Object)this.computeConfig()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("TableMappings", (Object)this.tableMappings()).add("ReplicationSettings", (Object)this.replicationSettings()).add("SupplementalSettings", (Object)this.supplementalSettings()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationConfigIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigIdentifier()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
            case "ComputeConfig": {
                return Optional.ofNullable(clazz.cast(this.computeConfig()));
            }
            case "ReplicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "TableMappings": {
                return Optional.ofNullable(clazz.cast(this.tableMappings()));
            }
            case "ReplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.replicationSettings()));
            }
            case "SupplementalSettings": {
                return Optional.ofNullable(clazz.cast(this.supplementalSettings()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReplicationConfigRequest, T> g) {
        return obj -> g.apply((CreateReplicationConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationConfigIdentifier;
        private String sourceEndpointArn;
        private String targetEndpointArn;
        private ComputeConfig computeConfig;
        private String replicationType;
        private String tableMappings;
        private String replicationSettings;
        private String supplementalSettings;
        private String resourceIdentifier;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReplicationConfigRequest model) {
            super(model);
            this.replicationConfigIdentifier(model.replicationConfigIdentifier);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
            this.computeConfig(model.computeConfig);
            this.replicationType(model.replicationType);
            this.tableMappings(model.tableMappings);
            this.replicationSettings(model.replicationSettings);
            this.supplementalSettings(model.supplementalSettings);
            this.resourceIdentifier(model.resourceIdentifier);
            this.tags(model.tags);
        }

        public final String getReplicationConfigIdentifier() {
            return this.replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final ComputeConfig.Builder getComputeConfig() {
            return this.computeConfig != null ? this.computeConfig.toBuilder() : null;
        }

        public final void setComputeConfig(ComputeConfig.BuilderImpl computeConfig) {
            this.computeConfig = computeConfig != null ? computeConfig.build() : null;
        }

        @Override
        public final Builder computeConfig(ComputeConfig computeConfig) {
            this.computeConfig = computeConfig;
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getTableMappings() {
            return this.tableMappings;
        }

        public final void setTableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
        }

        @Override
        public final Builder tableMappings(String tableMappings) {
            this.tableMappings = tableMappings;
            return this;
        }

        public final String getReplicationSettings() {
            return this.replicationSettings;
        }

        public final void setReplicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
        }

        @Override
        public final Builder replicationSettings(String replicationSettings) {
            this.replicationSettings = replicationSettings;
            return this;
        }

        public final String getSupplementalSettings() {
            return this.supplementalSettings;
        }

        public final void setSupplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
        }

        @Override
        public final Builder supplementalSettings(String supplementalSettings) {
            this.supplementalSettings = supplementalSettings;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReplicationConfigRequest build() {
            return new CreateReplicationConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReplicationConfigRequest> {
        public Builder replicationConfigIdentifier(String var1);

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder computeConfig(ComputeConfig var1);

        default public Builder computeConfig(Consumer<ComputeConfig.Builder> computeConfig) {
            return this.computeConfig((ComputeConfig)((ComputeConfig.Builder)ComputeConfig.builder().applyMutation(computeConfig)).build());
        }

        public Builder replicationType(String var1);

        public Builder replicationType(MigrationTypeValue var1);

        public Builder tableMappings(String var1);

        public Builder replicationSettings(String var1);

        public Builder supplementalSettings(String var1);

        public Builder resourceIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

