/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse;

public class DescribeMigrationProjectsPublisher
implements SdkPublisher<DescribeMigrationProjectsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeMigrationProjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMigrationProjectsPublisher(DatabaseMigrationAsyncClient client, DescribeMigrationProjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMigrationProjectsPublisher(DatabaseMigrationAsyncClient client, DescribeMigrationProjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMigrationProjectsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMigrationProjectsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeMigrationProjectsResponseFetcher
    implements AsyncPageFetcher<DescribeMigrationProjectsResponse> {
        private DescribeMigrationProjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMigrationProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeMigrationProjectsResponse> nextPage(DescribeMigrationProjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMigrationProjectsPublisher.this.client.describeMigrationProjects(DescribeMigrationProjectsPublisher.this.firstRequest);
            }
            return DescribeMigrationProjectsPublisher.this.client.describeMigrationProjects((DescribeMigrationProjectsRequest)((Object)DescribeMigrationProjectsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

