/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatabaseMode {
    DEFAULT("default"),
    BABELFISH("babelfish"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatabaseMode> VALUE_MAP;
    private final String value;

    private DatabaseMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatabaseMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatabaseMode> knownValues() {
        EnumSet<DatabaseMode> knownValues = EnumSet.allOf(DatabaseMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatabaseMode.class, DatabaseMode::toString);
    }
}

