/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;

public class DescribeTableStatisticsIterable
implements SdkIterable<DescribeTableStatisticsResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeTableStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTableStatisticsIterable(DatabaseMigrationClient client, DescribeTableStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTableStatisticsResponseFetcher();
    }

    public Iterator<DescribeTableStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeTableStatisticsResponseFetcher
    implements SyncPageFetcher<DescribeTableStatisticsResponse> {
        private DescribeTableStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTableStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeTableStatisticsResponse nextPage(DescribeTableStatisticsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTableStatisticsIterable.this.client.describeTableStatistics(DescribeTableStatisticsIterable.this.firstRequest);
            }
            return DescribeTableStatisticsIterable.this.client.describeTableStatistics((DescribeTableStatisticsRequest)((Object)DescribeTableStatisticsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

