/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KafkaSecurityProtocol {
    PLAINTEXT("plaintext"),
    SSL_AUTHENTICATION("ssl-authentication"),
    SSL_ENCRYPTION("ssl-encryption"),
    SASL_SSL("sasl-ssl"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KafkaSecurityProtocol> VALUE_MAP;
    private final String value;

    private KafkaSecurityProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KafkaSecurityProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KafkaSecurityProtocol> knownValues() {
        EnumSet<KafkaSecurityProtocol> knownValues = EnumSet.allOf(KafkaSecurityProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KafkaSecurityProtocol.class, KafkaSecurityProtocol::toString);
    }
}

