/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.EngineVersion;
import software.amazon.awssdk.services.databasemigration.model.EngineVersionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEngineVersionsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEngineVersionsResponse> {
    private static final SdkField<List<EngineVersion>> ENGINE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngineVersions").getter(DescribeEngineVersionsResponse.getter(DescribeEngineVersionsResponse::engineVersions)).setter(DescribeEngineVersionsResponse.setter(Builder::engineVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeEngineVersionsResponse.getter(DescribeEngineVersionsResponse::marker)).setter(DescribeEngineVersionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSIONS_FIELD, MARKER_FIELD));
    private final List<EngineVersion> engineVersions;
    private final String marker;

    private DescribeEngineVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.engineVersions = builder.engineVersions;
        this.marker = builder.marker;
    }

    public final boolean hasEngineVersions() {
        return this.engineVersions != null && !(this.engineVersions instanceof SdkAutoConstructList);
    }

    public final List<EngineVersion> engineVersions() {
        return this.engineVersions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngineVersions() ? this.engineVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEngineVersionsResponse)) {
            return false;
        }
        DescribeEngineVersionsResponse other = (DescribeEngineVersionsResponse)((Object)obj);
        return this.hasEngineVersions() == other.hasEngineVersions() && Objects.equals(this.engineVersions(), other.engineVersions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEngineVersionsResponse").add("EngineVersions", this.hasEngineVersions() ? this.engineVersions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineVersions": {
                return Optional.ofNullable(clazz.cast(this.engineVersions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEngineVersionsResponse, T> g) {
        return obj -> g.apply((DescribeEngineVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<EngineVersion> engineVersions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEngineVersionsResponse model) {
            super(model);
            this.engineVersions(model.engineVersions);
            this.marker(model.marker);
        }

        public final List<EngineVersion.Builder> getEngineVersions() {
            List<EngineVersion.Builder> result = EngineVersionListCopier.copyToBuilder(this.engineVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngineVersions(Collection<EngineVersion.BuilderImpl> engineVersions) {
            this.engineVersions = EngineVersionListCopier.copyFromBuilder(engineVersions);
        }

        @Override
        public final Builder engineVersions(Collection<EngineVersion> engineVersions) {
            this.engineVersions = EngineVersionListCopier.copy(engineVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(EngineVersion ... engineVersions) {
            this.engineVersions(Arrays.asList(engineVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineVersions(Consumer<EngineVersion.Builder> ... engineVersions) {
            this.engineVersions(Stream.of(engineVersions).map(c -> (EngineVersion)((EngineVersion.Builder)EngineVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeEngineVersionsResponse build() {
            return new DescribeEngineVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEngineVersionsResponse> {
        public Builder engineVersions(Collection<EngineVersion> var1);

        public Builder engineVersions(EngineVersion ... var1);

        public Builder engineVersions(Consumer<EngineVersion.Builder> ... var1);

        public Builder marker(String var1);
    }
}

