/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;

public class DescribeReplicationInstancesIterable
implements SdkIterable<DescribeReplicationInstancesResponse> {
    private final DatabaseMigrationClient client;
    private final DescribeReplicationInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReplicationInstancesIterable(DatabaseMigrationClient client, DescribeReplicationInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReplicationInstancesResponseFetcher();
    }

    public Iterator<DescribeReplicationInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeReplicationInstancesResponseFetcher
    implements SyncPageFetcher<DescribeReplicationInstancesResponse> {
        private DescribeReplicationInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReplicationInstancesResponse nextPage(DescribeReplicationInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationInstancesIterable.this.client.describeReplicationInstances(DescribeReplicationInstancesIterable.this.firstRequest);
            }
            return DescribeReplicationInstancesIterable.this.client.describeReplicationInstances((DescribeReplicationInstancesRequest)((Object)DescribeReplicationInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

