/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationSettings> {
    private static final SdkField<String> INSTANCE_SIZING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceSizingType").getter(RecommendationSettings.getter(RecommendationSettings::instanceSizingType)).setter(RecommendationSettings.setter(Builder::instanceSizingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSizingType").build()}).build();
    private static final SdkField<String> WORKLOAD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadType").getter(RecommendationSettings.getter(RecommendationSettings::workloadType)).setter(RecommendationSettings.setter(Builder::workloadType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_SIZING_TYPE_FIELD, WORKLOAD_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceSizingType;
    private final String workloadType;

    private RecommendationSettings(BuilderImpl builder) {
        this.instanceSizingType = builder.instanceSizingType;
        this.workloadType = builder.workloadType;
    }

    public final String instanceSizingType() {
        return this.instanceSizingType;
    }

    public final String workloadType() {
        return this.workloadType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSizingType());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSettings)) {
            return false;
        }
        RecommendationSettings other = (RecommendationSettings)obj;
        return Objects.equals(this.instanceSizingType(), other.instanceSizingType()) && Objects.equals(this.workloadType(), other.workloadType());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationSettings").add("InstanceSizingType", (Object)this.instanceSizingType()).add("WorkloadType", (Object)this.workloadType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceSizingType": {
                return Optional.ofNullable(clazz.cast(this.instanceSizingType()));
            }
            case "WorkloadType": {
                return Optional.ofNullable(clazz.cast(this.workloadType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSettings, T> g) {
        return obj -> g.apply((RecommendationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceSizingType;
        private String workloadType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSettings model) {
            this.instanceSizingType(model.instanceSizingType);
            this.workloadType(model.workloadType);
        }

        public final String getInstanceSizingType() {
            return this.instanceSizingType;
        }

        public final void setInstanceSizingType(String instanceSizingType) {
            this.instanceSizingType = instanceSizingType;
        }

        @Override
        public final Builder instanceSizingType(String instanceSizingType) {
            this.instanceSizingType = instanceSizingType;
            return this;
        }

        public final String getWorkloadType() {
            return this.workloadType;
        }

        public final void setWorkloadType(String workloadType) {
            this.workloadType = workloadType;
        }

        @Override
        public final Builder workloadType(String workloadType) {
            this.workloadType = workloadType;
            return this;
        }

        public RecommendationSettings build() {
            return new RecommendationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationSettings> {
        public Builder instanceSizingType(String var1);

        public Builder workloadType(String var1);
    }
}

