/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;

public class DescribeReplicationSubnetGroupsPublisher
implements SdkPublisher<DescribeReplicationSubnetGroupsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationSubnetGroupsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationSubnetGroupsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReplicationSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationSubnetGroupsResponse> {
        private DescribeReplicationSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationSubnetGroupsResponse> nextPage(DescribeReplicationSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationSubnetGroupsPublisher.this.client.describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeReplicationSubnetGroupsPublisher.this.client.describeReplicationSubnetGroups((DescribeReplicationSubnetGroupsRequest)((Object)DescribeReplicationSubnetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

