/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.PluginNameValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostgreSQLSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PostgreSQLSettings> {
    private static final SdkField<String> AFTER_CONNECT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfterConnectScript").getter(PostgreSQLSettings.getter(PostgreSQLSettings::afterConnectScript)).setter(PostgreSQLSettings.setter(Builder::afterConnectScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterConnectScript").build()}).build();
    private static final SdkField<Boolean> CAPTURE_DDLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CaptureDdls").getter(PostgreSQLSettings.getter(PostgreSQLSettings::captureDdls)).setter(PostgreSQLSettings.setter(Builder::captureDdls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureDdls").build()}).build();
    private static final SdkField<Integer> MAX_FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxFileSize").getter(PostgreSQLSettings.getter(PostgreSQLSettings::maxFileSize)).setter(PostgreSQLSettings.setter(Builder::maxFileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFileSize").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(PostgreSQLSettings.getter(PostgreSQLSettings::databaseName)).setter(PostgreSQLSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DDL_ARTIFACTS_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DdlArtifactsSchema").getter(PostgreSQLSettings.getter(PostgreSQLSettings::ddlArtifactsSchema)).setter(PostgreSQLSettings.setter(Builder::ddlArtifactsSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DdlArtifactsSchema").build()}).build();
    private static final SdkField<Integer> EXECUTE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecuteTimeout").getter(PostgreSQLSettings.getter(PostgreSQLSettings::executeTimeout)).setter(PostgreSQLSettings.setter(Builder::executeTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteTimeout").build()}).build();
    private static final SdkField<Boolean> FAIL_TASKS_ON_LOB_TRUNCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FailTasksOnLobTruncation").getter(PostgreSQLSettings.getter(PostgreSQLSettings::failTasksOnLobTruncation)).setter(PostgreSQLSettings.setter(Builder::failTasksOnLobTruncation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailTasksOnLobTruncation").build()}).build();
    private static final SdkField<Boolean> HEARTBEAT_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HeartbeatEnable").getter(PostgreSQLSettings.getter(PostgreSQLSettings::heartbeatEnable)).setter(PostgreSQLSettings.setter(Builder::heartbeatEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatEnable").build()}).build();
    private static final SdkField<String> HEARTBEAT_SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HeartbeatSchema").getter(PostgreSQLSettings.getter(PostgreSQLSettings::heartbeatSchema)).setter(PostgreSQLSettings.setter(Builder::heartbeatSchema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatSchema").build()}).build();
    private static final SdkField<Integer> HEARTBEAT_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HeartbeatFrequency").getter(PostgreSQLSettings.getter(PostgreSQLSettings::heartbeatFrequency)).setter(PostgreSQLSettings.setter(Builder::heartbeatFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeartbeatFrequency").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(PostgreSQLSettings.getter(PostgreSQLSettings::password)).setter(PostgreSQLSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(PostgreSQLSettings.getter(PostgreSQLSettings::port)).setter(PostgreSQLSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(PostgreSQLSettings.getter(PostgreSQLSettings::serverName)).setter(PostgreSQLSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(PostgreSQLSettings.getter(PostgreSQLSettings::username)).setter(PostgreSQLSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlotName").getter(PostgreSQLSettings.getter(PostgreSQLSettings::slotName)).setter(PostgreSQLSettings.setter(Builder::slotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlotName").build()}).build();
    private static final SdkField<String> PLUGIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PluginName").getter(PostgreSQLSettings.getter(PostgreSQLSettings::pluginNameAsString)).setter(PostgreSQLSettings.setter(Builder::pluginName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginName").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(PostgreSQLSettings.getter(PostgreSQLSettings::secretsManagerAccessRoleArn)).setter(PostgreSQLSettings.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(PostgreSQLSettings.getter(PostgreSQLSettings::secretsManagerSecretId)).setter(PostgreSQLSettings.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_CONNECT_SCRIPT_FIELD, CAPTURE_DDLS_FIELD, MAX_FILE_SIZE_FIELD, DATABASE_NAME_FIELD, DDL_ARTIFACTS_SCHEMA_FIELD, EXECUTE_TIMEOUT_FIELD, FAIL_TASKS_ON_LOB_TRUNCATION_FIELD, HEARTBEAT_ENABLE_FIELD, HEARTBEAT_SCHEMA_FIELD, HEARTBEAT_FREQUENCY_FIELD, PASSWORD_FIELD, PORT_FIELD, SERVER_NAME_FIELD, USERNAME_FIELD, SLOT_NAME_FIELD, PLUGIN_NAME_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String afterConnectScript;
    private final Boolean captureDdls;
    private final Integer maxFileSize;
    private final String databaseName;
    private final String ddlArtifactsSchema;
    private final Integer executeTimeout;
    private final Boolean failTasksOnLobTruncation;
    private final Boolean heartbeatEnable;
    private final String heartbeatSchema;
    private final Integer heartbeatFrequency;
    private final String password;
    private final Integer port;
    private final String serverName;
    private final String username;
    private final String slotName;
    private final String pluginName;
    private final String secretsManagerAccessRoleArn;
    private final String secretsManagerSecretId;

    private PostgreSQLSettings(BuilderImpl builder) {
        this.afterConnectScript = builder.afterConnectScript;
        this.captureDdls = builder.captureDdls;
        this.maxFileSize = builder.maxFileSize;
        this.databaseName = builder.databaseName;
        this.ddlArtifactsSchema = builder.ddlArtifactsSchema;
        this.executeTimeout = builder.executeTimeout;
        this.failTasksOnLobTruncation = builder.failTasksOnLobTruncation;
        this.heartbeatEnable = builder.heartbeatEnable;
        this.heartbeatSchema = builder.heartbeatSchema;
        this.heartbeatFrequency = builder.heartbeatFrequency;
        this.password = builder.password;
        this.port = builder.port;
        this.serverName = builder.serverName;
        this.username = builder.username;
        this.slotName = builder.slotName;
        this.pluginName = builder.pluginName;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
    }

    public final String afterConnectScript() {
        return this.afterConnectScript;
    }

    public final Boolean captureDdls() {
        return this.captureDdls;
    }

    public final Integer maxFileSize() {
        return this.maxFileSize;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String ddlArtifactsSchema() {
        return this.ddlArtifactsSchema;
    }

    public final Integer executeTimeout() {
        return this.executeTimeout;
    }

    public final Boolean failTasksOnLobTruncation() {
        return this.failTasksOnLobTruncation;
    }

    public final Boolean heartbeatEnable() {
        return this.heartbeatEnable;
    }

    public final String heartbeatSchema() {
        return this.heartbeatSchema;
    }

    public final Integer heartbeatFrequency() {
        return this.heartbeatFrequency;
    }

    public final String password() {
        return this.password;
    }

    public final Integer port() {
        return this.port;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String username() {
        return this.username;
    }

    public final String slotName() {
        return this.slotName;
    }

    public final PluginNameValue pluginName() {
        return PluginNameValue.fromValue(this.pluginName);
    }

    public final String pluginNameAsString() {
        return this.pluginName;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afterConnectScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.captureDdls());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ddlArtifactsSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.failTasksOnLobTruncation());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatSchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pluginNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostgreSQLSettings)) {
            return false;
        }
        PostgreSQLSettings other = (PostgreSQLSettings)obj;
        return Objects.equals(this.afterConnectScript(), other.afterConnectScript()) && Objects.equals(this.captureDdls(), other.captureDdls()) && Objects.equals(this.maxFileSize(), other.maxFileSize()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.ddlArtifactsSchema(), other.ddlArtifactsSchema()) && Objects.equals(this.executeTimeout(), other.executeTimeout()) && Objects.equals(this.failTasksOnLobTruncation(), other.failTasksOnLobTruncation()) && Objects.equals(this.heartbeatEnable(), other.heartbeatEnable()) && Objects.equals(this.heartbeatSchema(), other.heartbeatSchema()) && Objects.equals(this.heartbeatFrequency(), other.heartbeatFrequency()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.slotName(), other.slotName()) && Objects.equals(this.pluginNameAsString(), other.pluginNameAsString()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId());
    }

    public final String toString() {
        return ToString.builder((String)"PostgreSQLSettings").add("AfterConnectScript", (Object)this.afterConnectScript()).add("CaptureDdls", (Object)this.captureDdls()).add("MaxFileSize", (Object)this.maxFileSize()).add("DatabaseName", (Object)this.databaseName()).add("DdlArtifactsSchema", (Object)this.ddlArtifactsSchema()).add("ExecuteTimeout", (Object)this.executeTimeout()).add("FailTasksOnLobTruncation", (Object)this.failTasksOnLobTruncation()).add("HeartbeatEnable", (Object)this.heartbeatEnable()).add("HeartbeatSchema", (Object)this.heartbeatSchema()).add("HeartbeatFrequency", (Object)this.heartbeatFrequency()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("ServerName", (Object)this.serverName()).add("Username", (Object)this.username()).add("SlotName", (Object)this.slotName()).add("PluginName", (Object)this.pluginNameAsString()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfterConnectScript": {
                return Optional.ofNullable(clazz.cast(this.afterConnectScript()));
            }
            case "CaptureDdls": {
                return Optional.ofNullable(clazz.cast(this.captureDdls()));
            }
            case "MaxFileSize": {
                return Optional.ofNullable(clazz.cast(this.maxFileSize()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DdlArtifactsSchema": {
                return Optional.ofNullable(clazz.cast(this.ddlArtifactsSchema()));
            }
            case "ExecuteTimeout": {
                return Optional.ofNullable(clazz.cast(this.executeTimeout()));
            }
            case "FailTasksOnLobTruncation": {
                return Optional.ofNullable(clazz.cast(this.failTasksOnLobTruncation()));
            }
            case "HeartbeatEnable": {
                return Optional.ofNullable(clazz.cast(this.heartbeatEnable()));
            }
            case "HeartbeatSchema": {
                return Optional.ofNullable(clazz.cast(this.heartbeatSchema()));
            }
            case "HeartbeatFrequency": {
                return Optional.ofNullable(clazz.cast(this.heartbeatFrequency()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "SlotName": {
                return Optional.ofNullable(clazz.cast(this.slotName()));
            }
            case "PluginName": {
                return Optional.ofNullable(clazz.cast(this.pluginNameAsString()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostgreSQLSettings, T> g) {
        return obj -> g.apply((PostgreSQLSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String afterConnectScript;
        private Boolean captureDdls;
        private Integer maxFileSize;
        private String databaseName;
        private String ddlArtifactsSchema;
        private Integer executeTimeout;
        private Boolean failTasksOnLobTruncation;
        private Boolean heartbeatEnable;
        private String heartbeatSchema;
        private Integer heartbeatFrequency;
        private String password;
        private Integer port;
        private String serverName;
        private String username;
        private String slotName;
        private String pluginName;
        private String secretsManagerAccessRoleArn;
        private String secretsManagerSecretId;

        private BuilderImpl() {
        }

        private BuilderImpl(PostgreSQLSettings model) {
            this.afterConnectScript(model.afterConnectScript);
            this.captureDdls(model.captureDdls);
            this.maxFileSize(model.maxFileSize);
            this.databaseName(model.databaseName);
            this.ddlArtifactsSchema(model.ddlArtifactsSchema);
            this.executeTimeout(model.executeTimeout);
            this.failTasksOnLobTruncation(model.failTasksOnLobTruncation);
            this.heartbeatEnable(model.heartbeatEnable);
            this.heartbeatSchema(model.heartbeatSchema);
            this.heartbeatFrequency(model.heartbeatFrequency);
            this.password(model.password);
            this.port(model.port);
            this.serverName(model.serverName);
            this.username(model.username);
            this.slotName(model.slotName);
            this.pluginName(model.pluginName);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
        }

        public final String getAfterConnectScript() {
            return this.afterConnectScript;
        }

        public final void setAfterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
        }

        @Override
        @Transient
        public final Builder afterConnectScript(String afterConnectScript) {
            this.afterConnectScript = afterConnectScript;
            return this;
        }

        public final Boolean getCaptureDdls() {
            return this.captureDdls;
        }

        public final void setCaptureDdls(Boolean captureDdls) {
            this.captureDdls = captureDdls;
        }

        @Override
        @Transient
        public final Builder captureDdls(Boolean captureDdls) {
            this.captureDdls = captureDdls;
            return this;
        }

        public final Integer getMaxFileSize() {
            return this.maxFileSize;
        }

        public final void setMaxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
        }

        @Override
        @Transient
        public final Builder maxFileSize(Integer maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDdlArtifactsSchema() {
            return this.ddlArtifactsSchema;
        }

        public final void setDdlArtifactsSchema(String ddlArtifactsSchema) {
            this.ddlArtifactsSchema = ddlArtifactsSchema;
        }

        @Override
        @Transient
        public final Builder ddlArtifactsSchema(String ddlArtifactsSchema) {
            this.ddlArtifactsSchema = ddlArtifactsSchema;
            return this;
        }

        public final Integer getExecuteTimeout() {
            return this.executeTimeout;
        }

        public final void setExecuteTimeout(Integer executeTimeout) {
            this.executeTimeout = executeTimeout;
        }

        @Override
        @Transient
        public final Builder executeTimeout(Integer executeTimeout) {
            this.executeTimeout = executeTimeout;
            return this;
        }

        public final Boolean getFailTasksOnLobTruncation() {
            return this.failTasksOnLobTruncation;
        }

        public final void setFailTasksOnLobTruncation(Boolean failTasksOnLobTruncation) {
            this.failTasksOnLobTruncation = failTasksOnLobTruncation;
        }

        @Override
        @Transient
        public final Builder failTasksOnLobTruncation(Boolean failTasksOnLobTruncation) {
            this.failTasksOnLobTruncation = failTasksOnLobTruncation;
            return this;
        }

        public final Boolean getHeartbeatEnable() {
            return this.heartbeatEnable;
        }

        public final void setHeartbeatEnable(Boolean heartbeatEnable) {
            this.heartbeatEnable = heartbeatEnable;
        }

        @Override
        @Transient
        public final Builder heartbeatEnable(Boolean heartbeatEnable) {
            this.heartbeatEnable = heartbeatEnable;
            return this;
        }

        public final String getHeartbeatSchema() {
            return this.heartbeatSchema;
        }

        public final void setHeartbeatSchema(String heartbeatSchema) {
            this.heartbeatSchema = heartbeatSchema;
        }

        @Override
        @Transient
        public final Builder heartbeatSchema(String heartbeatSchema) {
            this.heartbeatSchema = heartbeatSchema;
            return this;
        }

        public final Integer getHeartbeatFrequency() {
            return this.heartbeatFrequency;
        }

        public final void setHeartbeatFrequency(Integer heartbeatFrequency) {
            this.heartbeatFrequency = heartbeatFrequency;
        }

        @Override
        @Transient
        public final Builder heartbeatFrequency(Integer heartbeatFrequency) {
            this.heartbeatFrequency = heartbeatFrequency;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        @Transient
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        @Transient
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getSlotName() {
            return this.slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        @Transient
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final String getPluginName() {
            return this.pluginName;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        @Override
        @Transient
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        @Override
        @Transient
        public final Builder pluginName(PluginNameValue pluginName) {
            this.pluginName(pluginName == null ? null : pluginName.toString());
            return this;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        @Override
        @Transient
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public PostgreSQLSettings build() {
            return new PostgreSQLSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PostgreSQLSettings> {
        public Builder afterConnectScript(String var1);

        public Builder captureDdls(Boolean var1);

        public Builder maxFileSize(Integer var1);

        public Builder databaseName(String var1);

        public Builder ddlArtifactsSchema(String var1);

        public Builder executeTimeout(Integer var1);

        public Builder failTasksOnLobTruncation(Boolean var1);

        public Builder heartbeatEnable(Boolean var1);

        public Builder heartbeatSchema(String var1);

        public Builder heartbeatFrequency(Integer var1);

        public Builder password(String var1);

        public Builder port(Integer var1);

        public Builder serverName(String var1);

        public Builder username(String var1);

        public Builder slotName(String var1);

        public Builder pluginName(String var1);

        public Builder pluginName(PluginNameValue var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder secretsManagerSecretId(String var1);
    }
}

