/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthTypeValue {
    NO("no"),
    PASSWORD("password"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthTypeValue> VALUE_MAP;
    private final String value;

    private AuthTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthTypeValue> knownValues() {
        EnumSet<AuthTypeValue> knownValues = EnumSet.allOf(AuthTypeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthTypeValue.class, AuthTypeValue::toString);
    }
}

