/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DmsSslModeValue;
import software.amazon.awssdk.services.databasemigration.model.DmsTransferSettings;
import software.amazon.awssdk.services.databasemigration.model.DocDbSettings;
import software.amazon.awssdk.services.databasemigration.model.DynamoDbSettings;
import software.amazon.awssdk.services.databasemigration.model.ElasticsearchSettings;
import software.amazon.awssdk.services.databasemigration.model.GcpMySQLSettings;
import software.amazon.awssdk.services.databasemigration.model.IBMDb2Settings;
import software.amazon.awssdk.services.databasemigration.model.KafkaSettings;
import software.amazon.awssdk.services.databasemigration.model.KinesisSettings;
import software.amazon.awssdk.services.databasemigration.model.MicrosoftSQLServerSettings;
import software.amazon.awssdk.services.databasemigration.model.MongoDbSettings;
import software.amazon.awssdk.services.databasemigration.model.MySQLSettings;
import software.amazon.awssdk.services.databasemigration.model.NeptuneSettings;
import software.amazon.awssdk.services.databasemigration.model.OracleSettings;
import software.amazon.awssdk.services.databasemigration.model.PostgreSQLSettings;
import software.amazon.awssdk.services.databasemigration.model.RedisSettings;
import software.amazon.awssdk.services.databasemigration.model.RedshiftSettings;
import software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue;
import software.amazon.awssdk.services.databasemigration.model.S3Settings;
import software.amazon.awssdk.services.databasemigration.model.SybaseSettings;
import software.amazon.awssdk.services.databasemigration.model.Tag;
import software.amazon.awssdk.services.databasemigration.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEndpointRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, CreateEndpointRequest> {
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointIdentifier").getter(CreateEndpointRequest.getter(CreateEndpointRequest::endpointIdentifier)).setter(CreateEndpointRequest.setter(Builder::endpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(CreateEndpointRequest.getter(CreateEndpointRequest::endpointTypeAsString)).setter(CreateEndpointRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineName").getter(CreateEndpointRequest.getter(CreateEndpointRequest::engineName)).setter(CreateEndpointRequest.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(CreateEndpointRequest.getter(CreateEndpointRequest::username)).setter(CreateEndpointRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(CreateEndpointRequest.getter(CreateEndpointRequest::password)).setter(CreateEndpointRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(CreateEndpointRequest.getter(CreateEndpointRequest::serverName)).setter(CreateEndpointRequest.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateEndpointRequest.getter(CreateEndpointRequest::port)).setter(CreateEndpointRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(CreateEndpointRequest.getter(CreateEndpointRequest::databaseName)).setter(CreateEndpointRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> EXTRA_CONNECTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExtraConnectionAttributes").getter(CreateEndpointRequest.getter(CreateEndpointRequest::extraConnectionAttributes)).setter(CreateEndpointRequest.setter(Builder::extraConnectionAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExtraConnectionAttributes").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateEndpointRequest.getter(CreateEndpointRequest::kmsKeyId)).setter(CreateEndpointRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateEndpointRequest.getter(CreateEndpointRequest::tags)).setter(CreateEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateArn").getter(CreateEndpointRequest.getter(CreateEndpointRequest::certificateArn)).setter(CreateEndpointRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()}).build();
    private static final SdkField<String> SSL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SslMode").getter(CreateEndpointRequest.getter(CreateEndpointRequest::sslModeAsString)).setter(CreateEndpointRequest.setter(Builder::sslMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()}).build();
    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceAccessRoleArn").getter(CreateEndpointRequest.getter(CreateEndpointRequest::serviceAccessRoleArn)).setter(CreateEndpointRequest.setter(Builder::serviceAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build()}).build();
    private static final SdkField<String> EXTERNAL_TABLE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalTableDefinition").getter(CreateEndpointRequest.getter(CreateEndpointRequest::externalTableDefinition)).setter(CreateEndpointRequest.setter(Builder::externalTableDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalTableDefinition").build()}).build();
    private static final SdkField<DynamoDbSettings> DYNAMO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DynamoDbSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::dynamoDbSettings)).setter(CreateEndpointRequest.setter(Builder::dynamoDbSettings)).constructor(DynamoDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamoDbSettings").build()}).build();
    private static final SdkField<S3Settings> S3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Settings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::s3Settings)).setter(CreateEndpointRequest.setter(Builder::s3Settings)).constructor(S3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Settings").build()}).build();
    private static final SdkField<DmsTransferSettings> DMS_TRANSFER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DmsTransferSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::dmsTransferSettings)).setter(CreateEndpointRequest.setter(Builder::dmsTransferSettings)).constructor(DmsTransferSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DmsTransferSettings").build()}).build();
    private static final SdkField<MongoDbSettings> MONGO_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MongoDbSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::mongoDbSettings)).setter(CreateEndpointRequest.setter(Builder::mongoDbSettings)).constructor(MongoDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MongoDbSettings").build()}).build();
    private static final SdkField<KinesisSettings> KINESIS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::kinesisSettings)).setter(CreateEndpointRequest.setter(Builder::kinesisSettings)).constructor(KinesisSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisSettings").build()}).build();
    private static final SdkField<KafkaSettings> KAFKA_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KafkaSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::kafkaSettings)).setter(CreateEndpointRequest.setter(Builder::kafkaSettings)).constructor(KafkaSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KafkaSettings").build()}).build();
    private static final SdkField<ElasticsearchSettings> ELASTICSEARCH_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticsearchSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::elasticsearchSettings)).setter(CreateEndpointRequest.setter(Builder::elasticsearchSettings)).constructor(ElasticsearchSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchSettings").build()}).build();
    private static final SdkField<NeptuneSettings> NEPTUNE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NeptuneSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::neptuneSettings)).setter(CreateEndpointRequest.setter(Builder::neptuneSettings)).constructor(NeptuneSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeptuneSettings").build()}).build();
    private static final SdkField<RedshiftSettings> REDSHIFT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::redshiftSettings)).setter(CreateEndpointRequest.setter(Builder::redshiftSettings)).constructor(RedshiftSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftSettings").build()}).build();
    private static final SdkField<PostgreSQLSettings> POSTGRE_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostgreSQLSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::postgreSQLSettings)).setter(CreateEndpointRequest.setter(Builder::postgreSQLSettings)).constructor(PostgreSQLSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostgreSQLSettings").build()}).build();
    private static final SdkField<MySQLSettings> MY_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MySQLSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::mySQLSettings)).setter(CreateEndpointRequest.setter(Builder::mySQLSettings)).constructor(MySQLSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MySQLSettings").build()}).build();
    private static final SdkField<OracleSettings> ORACLE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OracleSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::oracleSettings)).setter(CreateEndpointRequest.setter(Builder::oracleSettings)).constructor(OracleSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OracleSettings").build()}).build();
    private static final SdkField<SybaseSettings> SYBASE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SybaseSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::sybaseSettings)).setter(CreateEndpointRequest.setter(Builder::sybaseSettings)).constructor(SybaseSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SybaseSettings").build()}).build();
    private static final SdkField<MicrosoftSQLServerSettings> MICROSOFT_SQL_SERVER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MicrosoftSQLServerSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::microsoftSQLServerSettings)).setter(CreateEndpointRequest.setter(Builder::microsoftSQLServerSettings)).constructor(MicrosoftSQLServerSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MicrosoftSQLServerSettings").build()}).build();
    private static final SdkField<IBMDb2Settings> IBM_DB2_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IBMDb2Settings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::ibmDb2Settings)).setter(CreateEndpointRequest.setter(Builder::ibmDb2Settings)).constructor(IBMDb2Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IBMDb2Settings").build()}).build();
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(CreateEndpointRequest.getter(CreateEndpointRequest::resourceIdentifier)).setter(CreateEndpointRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<DocDbSettings> DOC_DB_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocDbSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::docDbSettings)).setter(CreateEndpointRequest.setter(Builder::docDbSettings)).constructor(DocDbSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocDbSettings").build()}).build();
    private static final SdkField<RedisSettings> REDIS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedisSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::redisSettings)).setter(CreateEndpointRequest.setter(Builder::redisSettings)).constructor(RedisSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedisSettings").build()}).build();
    private static final SdkField<GcpMySQLSettings> GCP_MY_SQL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GcpMySQLSettings").getter(CreateEndpointRequest.getter(CreateEndpointRequest::gcpMySQLSettings)).setter(CreateEndpointRequest.setter(Builder::gcpMySQLSettings)).constructor(GcpMySQLSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GcpMySQLSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, ENGINE_NAME_FIELD, USERNAME_FIELD, PASSWORD_FIELD, SERVER_NAME_FIELD, PORT_FIELD, DATABASE_NAME_FIELD, EXTRA_CONNECTION_ATTRIBUTES_FIELD, KMS_KEY_ID_FIELD, TAGS_FIELD, CERTIFICATE_ARN_FIELD, SSL_MODE_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, EXTERNAL_TABLE_DEFINITION_FIELD, DYNAMO_DB_SETTINGS_FIELD, S3_SETTINGS_FIELD, DMS_TRANSFER_SETTINGS_FIELD, MONGO_DB_SETTINGS_FIELD, KINESIS_SETTINGS_FIELD, KAFKA_SETTINGS_FIELD, ELASTICSEARCH_SETTINGS_FIELD, NEPTUNE_SETTINGS_FIELD, REDSHIFT_SETTINGS_FIELD, POSTGRE_SQL_SETTINGS_FIELD, MY_SQL_SETTINGS_FIELD, ORACLE_SETTINGS_FIELD, SYBASE_SETTINGS_FIELD, MICROSOFT_SQL_SERVER_SETTINGS_FIELD, IBM_DB2_SETTINGS_FIELD, RESOURCE_IDENTIFIER_FIELD, DOC_DB_SETTINGS_FIELD, REDIS_SETTINGS_FIELD, GCP_MY_SQL_SETTINGS_FIELD));
    private final String endpointIdentifier;
    private final String endpointType;
    private final String engineName;
    private final String username;
    private final String password;
    private final String serverName;
    private final Integer port;
    private final String databaseName;
    private final String extraConnectionAttributes;
    private final String kmsKeyId;
    private final List<Tag> tags;
    private final String certificateArn;
    private final String sslMode;
    private final String serviceAccessRoleArn;
    private final String externalTableDefinition;
    private final DynamoDbSettings dynamoDbSettings;
    private final S3Settings s3Settings;
    private final DmsTransferSettings dmsTransferSettings;
    private final MongoDbSettings mongoDbSettings;
    private final KinesisSettings kinesisSettings;
    private final KafkaSettings kafkaSettings;
    private final ElasticsearchSettings elasticsearchSettings;
    private final NeptuneSettings neptuneSettings;
    private final RedshiftSettings redshiftSettings;
    private final PostgreSQLSettings postgreSQLSettings;
    private final MySQLSettings mySQLSettings;
    private final OracleSettings oracleSettings;
    private final SybaseSettings sybaseSettings;
    private final MicrosoftSQLServerSettings microsoftSQLServerSettings;
    private final IBMDb2Settings ibmDb2Settings;
    private final String resourceIdentifier;
    private final DocDbSettings docDbSettings;
    private final RedisSettings redisSettings;
    private final GcpMySQLSettings gcpMySQLSettings;

    private CreateEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.endpointIdentifier = builder.endpointIdentifier;
        this.endpointType = builder.endpointType;
        this.engineName = builder.engineName;
        this.username = builder.username;
        this.password = builder.password;
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.extraConnectionAttributes = builder.extraConnectionAttributes;
        this.kmsKeyId = builder.kmsKeyId;
        this.tags = builder.tags;
        this.certificateArn = builder.certificateArn;
        this.sslMode = builder.sslMode;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.externalTableDefinition = builder.externalTableDefinition;
        this.dynamoDbSettings = builder.dynamoDbSettings;
        this.s3Settings = builder.s3Settings;
        this.dmsTransferSettings = builder.dmsTransferSettings;
        this.mongoDbSettings = builder.mongoDbSettings;
        this.kinesisSettings = builder.kinesisSettings;
        this.kafkaSettings = builder.kafkaSettings;
        this.elasticsearchSettings = builder.elasticsearchSettings;
        this.neptuneSettings = builder.neptuneSettings;
        this.redshiftSettings = builder.redshiftSettings;
        this.postgreSQLSettings = builder.postgreSQLSettings;
        this.mySQLSettings = builder.mySQLSettings;
        this.oracleSettings = builder.oracleSettings;
        this.sybaseSettings = builder.sybaseSettings;
        this.microsoftSQLServerSettings = builder.microsoftSQLServerSettings;
        this.ibmDb2Settings = builder.ibmDb2Settings;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.docDbSettings = builder.docDbSettings;
        this.redisSettings = builder.redisSettings;
        this.gcpMySQLSettings = builder.gcpMySQLSettings;
    }

    public final String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public final ReplicationEndpointTypeValue endpointType() {
        return ReplicationEndpointTypeValue.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String engineName() {
        return this.engineName;
    }

    public final String username() {
        return this.username;
    }

    public final String password() {
        return this.password;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Integer port() {
        return this.port;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String extraConnectionAttributes() {
        return this.extraConnectionAttributes;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(this.sslMode);
    }

    public final String sslModeAsString() {
        return this.sslMode;
    }

    public final String serviceAccessRoleArn() {
        return this.serviceAccessRoleArn;
    }

    public final String externalTableDefinition() {
        return this.externalTableDefinition;
    }

    public final DynamoDbSettings dynamoDbSettings() {
        return this.dynamoDbSettings;
    }

    public final S3Settings s3Settings() {
        return this.s3Settings;
    }

    public final DmsTransferSettings dmsTransferSettings() {
        return this.dmsTransferSettings;
    }

    public final MongoDbSettings mongoDbSettings() {
        return this.mongoDbSettings;
    }

    public final KinesisSettings kinesisSettings() {
        return this.kinesisSettings;
    }

    public final KafkaSettings kafkaSettings() {
        return this.kafkaSettings;
    }

    public final ElasticsearchSettings elasticsearchSettings() {
        return this.elasticsearchSettings;
    }

    public final NeptuneSettings neptuneSettings() {
        return this.neptuneSettings;
    }

    public final RedshiftSettings redshiftSettings() {
        return this.redshiftSettings;
    }

    public final PostgreSQLSettings postgreSQLSettings() {
        return this.postgreSQLSettings;
    }

    public final MySQLSettings mySQLSettings() {
        return this.mySQLSettings;
    }

    public final OracleSettings oracleSettings() {
        return this.oracleSettings;
    }

    public final SybaseSettings sybaseSettings() {
        return this.sybaseSettings;
    }

    public final MicrosoftSQLServerSettings microsoftSQLServerSettings() {
        return this.microsoftSQLServerSettings;
    }

    public final IBMDb2Settings ibmDb2Settings() {
        return this.ibmDb2Settings;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final DocDbSettings docDbSettings() {
        return this.docDbSettings;
    }

    public final RedisSettings redisSettings() {
        return this.redisSettings;
    }

    public final GcpMySQLSettings gcpMySQLSettings() {
        return this.gcpMySQLSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.extraConnectionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalTableDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dmsTransferSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mongoDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.kafkaSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticsearchSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.postgreSQLSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mySQLSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.oracleSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sybaseSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.microsoftSQLServerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ibmDb2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.docDbSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.redisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.gcpMySQLSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointRequest)) {
            return false;
        }
        CreateEndpointRequest other = (CreateEndpointRequest)((Object)obj);
        return Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.extraConnectionAttributes(), other.extraConnectionAttributes()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.sslModeAsString(), other.sslModeAsString()) && Objects.equals(this.serviceAccessRoleArn(), other.serviceAccessRoleArn()) && Objects.equals(this.externalTableDefinition(), other.externalTableDefinition()) && Objects.equals(this.dynamoDbSettings(), other.dynamoDbSettings()) && Objects.equals(this.s3Settings(), other.s3Settings()) && Objects.equals(this.dmsTransferSettings(), other.dmsTransferSettings()) && Objects.equals(this.mongoDbSettings(), other.mongoDbSettings()) && Objects.equals(this.kinesisSettings(), other.kinesisSettings()) && Objects.equals(this.kafkaSettings(), other.kafkaSettings()) && Objects.equals(this.elasticsearchSettings(), other.elasticsearchSettings()) && Objects.equals(this.neptuneSettings(), other.neptuneSettings()) && Objects.equals(this.redshiftSettings(), other.redshiftSettings()) && Objects.equals(this.postgreSQLSettings(), other.postgreSQLSettings()) && Objects.equals(this.mySQLSettings(), other.mySQLSettings()) && Objects.equals(this.oracleSettings(), other.oracleSettings()) && Objects.equals(this.sybaseSettings(), other.sybaseSettings()) && Objects.equals(this.microsoftSQLServerSettings(), other.microsoftSQLServerSettings()) && Objects.equals(this.ibmDb2Settings(), other.ibmDb2Settings()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.docDbSettings(), other.docDbSettings()) && Objects.equals(this.redisSettings(), other.redisSettings()) && Objects.equals(this.gcpMySQLSettings(), other.gcpMySQLSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEndpointRequest").add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("EndpointType", (Object)this.endpointTypeAsString()).add("EngineName", (Object)this.engineName()).add("Username", (Object)this.username()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("ServerName", (Object)this.serverName()).add("Port", (Object)this.port()).add("DatabaseName", (Object)this.databaseName()).add("ExtraConnectionAttributes", (Object)this.extraConnectionAttributes()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Tags", this.hasTags() ? this.tags() : null).add("CertificateArn", (Object)this.certificateArn()).add("SslMode", (Object)this.sslModeAsString()).add("ServiceAccessRoleArn", (Object)this.serviceAccessRoleArn()).add("ExternalTableDefinition", (Object)this.externalTableDefinition()).add("DynamoDbSettings", (Object)this.dynamoDbSettings()).add("S3Settings", (Object)this.s3Settings()).add("DmsTransferSettings", (Object)this.dmsTransferSettings()).add("MongoDbSettings", (Object)this.mongoDbSettings()).add("KinesisSettings", (Object)this.kinesisSettings()).add("KafkaSettings", (Object)this.kafkaSettings()).add("ElasticsearchSettings", (Object)this.elasticsearchSettings()).add("NeptuneSettings", (Object)this.neptuneSettings()).add("RedshiftSettings", (Object)this.redshiftSettings()).add("PostgreSQLSettings", (Object)this.postgreSQLSettings()).add("MySQLSettings", (Object)this.mySQLSettings()).add("OracleSettings", (Object)this.oracleSettings()).add("SybaseSettings", (Object)this.sybaseSettings()).add("MicrosoftSQLServerSettings", (Object)this.microsoftSQLServerSettings()).add("IBMDb2Settings", (Object)this.ibmDb2Settings()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("DocDbSettings", (Object)this.docDbSettings()).add("RedisSettings", (Object)this.redisSettings()).add("GcpMySQLSettings", (Object)this.gcpMySQLSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "ExtraConnectionAttributes": {
                return Optional.ofNullable(clazz.cast(this.extraConnectionAttributes()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "SslMode": {
                return Optional.ofNullable(clazz.cast(this.sslModeAsString()));
            }
            case "ServiceAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceAccessRoleArn()));
            }
            case "ExternalTableDefinition": {
                return Optional.ofNullable(clazz.cast(this.externalTableDefinition()));
            }
            case "DynamoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.dynamoDbSettings()));
            }
            case "S3Settings": {
                return Optional.ofNullable(clazz.cast(this.s3Settings()));
            }
            case "DmsTransferSettings": {
                return Optional.ofNullable(clazz.cast(this.dmsTransferSettings()));
            }
            case "MongoDbSettings": {
                return Optional.ofNullable(clazz.cast(this.mongoDbSettings()));
            }
            case "KinesisSettings": {
                return Optional.ofNullable(clazz.cast(this.kinesisSettings()));
            }
            case "KafkaSettings": {
                return Optional.ofNullable(clazz.cast(this.kafkaSettings()));
            }
            case "ElasticsearchSettings": {
                return Optional.ofNullable(clazz.cast(this.elasticsearchSettings()));
            }
            case "NeptuneSettings": {
                return Optional.ofNullable(clazz.cast(this.neptuneSettings()));
            }
            case "RedshiftSettings": {
                return Optional.ofNullable(clazz.cast(this.redshiftSettings()));
            }
            case "PostgreSQLSettings": {
                return Optional.ofNullable(clazz.cast(this.postgreSQLSettings()));
            }
            case "MySQLSettings": {
                return Optional.ofNullable(clazz.cast(this.mySQLSettings()));
            }
            case "OracleSettings": {
                return Optional.ofNullable(clazz.cast(this.oracleSettings()));
            }
            case "SybaseSettings": {
                return Optional.ofNullable(clazz.cast(this.sybaseSettings()));
            }
            case "MicrosoftSQLServerSettings": {
                return Optional.ofNullable(clazz.cast(this.microsoftSQLServerSettings()));
            }
            case "IBMDb2Settings": {
                return Optional.ofNullable(clazz.cast(this.ibmDb2Settings()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "DocDbSettings": {
                return Optional.ofNullable(clazz.cast(this.docDbSettings()));
            }
            case "RedisSettings": {
                return Optional.ofNullable(clazz.cast(this.redisSettings()));
            }
            case "GcpMySQLSettings": {
                return Optional.ofNullable(clazz.cast(this.gcpMySQLSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointRequest, T> g) {
        return obj -> g.apply((CreateEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String endpointIdentifier;
        private String endpointType;
        private String engineName;
        private String username;
        private String password;
        private String serverName;
        private Integer port;
        private String databaseName;
        private String extraConnectionAttributes;
        private String kmsKeyId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String certificateArn;
        private String sslMode;
        private String serviceAccessRoleArn;
        private String externalTableDefinition;
        private DynamoDbSettings dynamoDbSettings;
        private S3Settings s3Settings;
        private DmsTransferSettings dmsTransferSettings;
        private MongoDbSettings mongoDbSettings;
        private KinesisSettings kinesisSettings;
        private KafkaSettings kafkaSettings;
        private ElasticsearchSettings elasticsearchSettings;
        private NeptuneSettings neptuneSettings;
        private RedshiftSettings redshiftSettings;
        private PostgreSQLSettings postgreSQLSettings;
        private MySQLSettings mySQLSettings;
        private OracleSettings oracleSettings;
        private SybaseSettings sybaseSettings;
        private MicrosoftSQLServerSettings microsoftSQLServerSettings;
        private IBMDb2Settings ibmDb2Settings;
        private String resourceIdentifier;
        private DocDbSettings docDbSettings;
        private RedisSettings redisSettings;
        private GcpMySQLSettings gcpMySQLSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointRequest model) {
            super(model);
            this.endpointIdentifier(model.endpointIdentifier);
            this.endpointType(model.endpointType);
            this.engineName(model.engineName);
            this.username(model.username);
            this.password(model.password);
            this.serverName(model.serverName);
            this.port(model.port);
            this.databaseName(model.databaseName);
            this.extraConnectionAttributes(model.extraConnectionAttributes);
            this.kmsKeyId(model.kmsKeyId);
            this.tags(model.tags);
            this.certificateArn(model.certificateArn);
            this.sslMode(model.sslMode);
            this.serviceAccessRoleArn(model.serviceAccessRoleArn);
            this.externalTableDefinition(model.externalTableDefinition);
            this.dynamoDbSettings(model.dynamoDbSettings);
            this.s3Settings(model.s3Settings);
            this.dmsTransferSettings(model.dmsTransferSettings);
            this.mongoDbSettings(model.mongoDbSettings);
            this.kinesisSettings(model.kinesisSettings);
            this.kafkaSettings(model.kafkaSettings);
            this.elasticsearchSettings(model.elasticsearchSettings);
            this.neptuneSettings(model.neptuneSettings);
            this.redshiftSettings(model.redshiftSettings);
            this.postgreSQLSettings(model.postgreSQLSettings);
            this.mySQLSettings(model.mySQLSettings);
            this.oracleSettings(model.oracleSettings);
            this.sybaseSettings(model.sybaseSettings);
            this.microsoftSQLServerSettings(model.microsoftSQLServerSettings);
            this.ibmDb2Settings(model.ibmDb2Settings);
            this.resourceIdentifier(model.resourceIdentifier);
            this.docDbSettings(model.docDbSettings);
            this.redisSettings(model.redisSettings);
            this.gcpMySQLSettings(model.gcpMySQLSettings);
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ReplicationEndpointTypeValue endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getServerName() {
            return this.serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getExtraConnectionAttributes() {
            return this.extraConnectionAttributes;
        }

        public final void setExtraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
        }

        @Override
        public final Builder extraConnectionAttributes(String extraConnectionAttributes) {
            this.extraConnectionAttributes = extraConnectionAttributes;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getSslMode() {
            return this.sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return this.serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getExternalTableDefinition() {
            return this.externalTableDefinition;
        }

        public final void setExternalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
        }

        @Override
        public final Builder externalTableDefinition(String externalTableDefinition) {
            this.externalTableDefinition = externalTableDefinition;
            return this;
        }

        public final DynamoDbSettings.Builder getDynamoDbSettings() {
            return this.dynamoDbSettings != null ? this.dynamoDbSettings.toBuilder() : null;
        }

        public final void setDynamoDbSettings(DynamoDbSettings.BuilderImpl dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings != null ? dynamoDbSettings.build() : null;
        }

        @Override
        public final Builder dynamoDbSettings(DynamoDbSettings dynamoDbSettings) {
            this.dynamoDbSettings = dynamoDbSettings;
            return this;
        }

        public final S3Settings.Builder getS3Settings() {
            return this.s3Settings != null ? this.s3Settings.toBuilder() : null;
        }

        public final void setS3Settings(S3Settings.BuilderImpl s3Settings) {
            this.s3Settings = s3Settings != null ? s3Settings.build() : null;
        }

        @Override
        public final Builder s3Settings(S3Settings s3Settings) {
            this.s3Settings = s3Settings;
            return this;
        }

        public final DmsTransferSettings.Builder getDmsTransferSettings() {
            return this.dmsTransferSettings != null ? this.dmsTransferSettings.toBuilder() : null;
        }

        public final void setDmsTransferSettings(DmsTransferSettings.BuilderImpl dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings != null ? dmsTransferSettings.build() : null;
        }

        @Override
        public final Builder dmsTransferSettings(DmsTransferSettings dmsTransferSettings) {
            this.dmsTransferSettings = dmsTransferSettings;
            return this;
        }

        public final MongoDbSettings.Builder getMongoDbSettings() {
            return this.mongoDbSettings != null ? this.mongoDbSettings.toBuilder() : null;
        }

        public final void setMongoDbSettings(MongoDbSettings.BuilderImpl mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings != null ? mongoDbSettings.build() : null;
        }

        @Override
        public final Builder mongoDbSettings(MongoDbSettings mongoDbSettings) {
            this.mongoDbSettings = mongoDbSettings;
            return this;
        }

        public final KinesisSettings.Builder getKinesisSettings() {
            return this.kinesisSettings != null ? this.kinesisSettings.toBuilder() : null;
        }

        public final void setKinesisSettings(KinesisSettings.BuilderImpl kinesisSettings) {
            this.kinesisSettings = kinesisSettings != null ? kinesisSettings.build() : null;
        }

        @Override
        public final Builder kinesisSettings(KinesisSettings kinesisSettings) {
            this.kinesisSettings = kinesisSettings;
            return this;
        }

        public final KafkaSettings.Builder getKafkaSettings() {
            return this.kafkaSettings != null ? this.kafkaSettings.toBuilder() : null;
        }

        public final void setKafkaSettings(KafkaSettings.BuilderImpl kafkaSettings) {
            this.kafkaSettings = kafkaSettings != null ? kafkaSettings.build() : null;
        }

        @Override
        public final Builder kafkaSettings(KafkaSettings kafkaSettings) {
            this.kafkaSettings = kafkaSettings;
            return this;
        }

        public final ElasticsearchSettings.Builder getElasticsearchSettings() {
            return this.elasticsearchSettings != null ? this.elasticsearchSettings.toBuilder() : null;
        }

        public final void setElasticsearchSettings(ElasticsearchSettings.BuilderImpl elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings != null ? elasticsearchSettings.build() : null;
        }

        @Override
        public final Builder elasticsearchSettings(ElasticsearchSettings elasticsearchSettings) {
            this.elasticsearchSettings = elasticsearchSettings;
            return this;
        }

        public final NeptuneSettings.Builder getNeptuneSettings() {
            return this.neptuneSettings != null ? this.neptuneSettings.toBuilder() : null;
        }

        public final void setNeptuneSettings(NeptuneSettings.BuilderImpl neptuneSettings) {
            this.neptuneSettings = neptuneSettings != null ? neptuneSettings.build() : null;
        }

        @Override
        public final Builder neptuneSettings(NeptuneSettings neptuneSettings) {
            this.neptuneSettings = neptuneSettings;
            return this;
        }

        public final RedshiftSettings.Builder getRedshiftSettings() {
            return this.redshiftSettings != null ? this.redshiftSettings.toBuilder() : null;
        }

        public final void setRedshiftSettings(RedshiftSettings.BuilderImpl redshiftSettings) {
            this.redshiftSettings = redshiftSettings != null ? redshiftSettings.build() : null;
        }

        @Override
        public final Builder redshiftSettings(RedshiftSettings redshiftSettings) {
            this.redshiftSettings = redshiftSettings;
            return this;
        }

        public final PostgreSQLSettings.Builder getPostgreSQLSettings() {
            return this.postgreSQLSettings != null ? this.postgreSQLSettings.toBuilder() : null;
        }

        public final void setPostgreSQLSettings(PostgreSQLSettings.BuilderImpl postgreSQLSettings) {
            this.postgreSQLSettings = postgreSQLSettings != null ? postgreSQLSettings.build() : null;
        }

        @Override
        public final Builder postgreSQLSettings(PostgreSQLSettings postgreSQLSettings) {
            this.postgreSQLSettings = postgreSQLSettings;
            return this;
        }

        public final MySQLSettings.Builder getMySQLSettings() {
            return this.mySQLSettings != null ? this.mySQLSettings.toBuilder() : null;
        }

        public final void setMySQLSettings(MySQLSettings.BuilderImpl mySQLSettings) {
            this.mySQLSettings = mySQLSettings != null ? mySQLSettings.build() : null;
        }

        @Override
        public final Builder mySQLSettings(MySQLSettings mySQLSettings) {
            this.mySQLSettings = mySQLSettings;
            return this;
        }

        public final OracleSettings.Builder getOracleSettings() {
            return this.oracleSettings != null ? this.oracleSettings.toBuilder() : null;
        }

        public final void setOracleSettings(OracleSettings.BuilderImpl oracleSettings) {
            this.oracleSettings = oracleSettings != null ? oracleSettings.build() : null;
        }

        @Override
        public final Builder oracleSettings(OracleSettings oracleSettings) {
            this.oracleSettings = oracleSettings;
            return this;
        }

        public final SybaseSettings.Builder getSybaseSettings() {
            return this.sybaseSettings != null ? this.sybaseSettings.toBuilder() : null;
        }

        public final void setSybaseSettings(SybaseSettings.BuilderImpl sybaseSettings) {
            this.sybaseSettings = sybaseSettings != null ? sybaseSettings.build() : null;
        }

        @Override
        public final Builder sybaseSettings(SybaseSettings sybaseSettings) {
            this.sybaseSettings = sybaseSettings;
            return this;
        }

        public final MicrosoftSQLServerSettings.Builder getMicrosoftSQLServerSettings() {
            return this.microsoftSQLServerSettings != null ? this.microsoftSQLServerSettings.toBuilder() : null;
        }

        public final void setMicrosoftSQLServerSettings(MicrosoftSQLServerSettings.BuilderImpl microsoftSQLServerSettings) {
            this.microsoftSQLServerSettings = microsoftSQLServerSettings != null ? microsoftSQLServerSettings.build() : null;
        }

        @Override
        public final Builder microsoftSQLServerSettings(MicrosoftSQLServerSettings microsoftSQLServerSettings) {
            this.microsoftSQLServerSettings = microsoftSQLServerSettings;
            return this;
        }

        public final IBMDb2Settings.Builder getIbmDb2Settings() {
            return this.ibmDb2Settings != null ? this.ibmDb2Settings.toBuilder() : null;
        }

        public final void setIbmDb2Settings(IBMDb2Settings.BuilderImpl ibmDb2Settings) {
            this.ibmDb2Settings = ibmDb2Settings != null ? ibmDb2Settings.build() : null;
        }

        @Override
        public final Builder ibmDb2Settings(IBMDb2Settings ibmDb2Settings) {
            this.ibmDb2Settings = ibmDb2Settings;
            return this;
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final DocDbSettings.Builder getDocDbSettings() {
            return this.docDbSettings != null ? this.docDbSettings.toBuilder() : null;
        }

        public final void setDocDbSettings(DocDbSettings.BuilderImpl docDbSettings) {
            this.docDbSettings = docDbSettings != null ? docDbSettings.build() : null;
        }

        @Override
        public final Builder docDbSettings(DocDbSettings docDbSettings) {
            this.docDbSettings = docDbSettings;
            return this;
        }

        public final RedisSettings.Builder getRedisSettings() {
            return this.redisSettings != null ? this.redisSettings.toBuilder() : null;
        }

        public final void setRedisSettings(RedisSettings.BuilderImpl redisSettings) {
            this.redisSettings = redisSettings != null ? redisSettings.build() : null;
        }

        @Override
        public final Builder redisSettings(RedisSettings redisSettings) {
            this.redisSettings = redisSettings;
            return this;
        }

        public final GcpMySQLSettings.Builder getGcpMySQLSettings() {
            return this.gcpMySQLSettings != null ? this.gcpMySQLSettings.toBuilder() : null;
        }

        public final void setGcpMySQLSettings(GcpMySQLSettings.BuilderImpl gcpMySQLSettings) {
            this.gcpMySQLSettings = gcpMySQLSettings != null ? gcpMySQLSettings.build() : null;
        }

        @Override
        public final Builder gcpMySQLSettings(GcpMySQLSettings gcpMySQLSettings) {
            this.gcpMySQLSettings = gcpMySQLSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointRequest build() {
            return new CreateEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEndpointRequest> {
        public Builder endpointIdentifier(String var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ReplicationEndpointTypeValue var1);

        public Builder engineName(String var1);

        public Builder username(String var1);

        public Builder password(String var1);

        public Builder serverName(String var1);

        public Builder port(Integer var1);

        public Builder databaseName(String var1);

        public Builder extraConnectionAttributes(String var1);

        public Builder kmsKeyId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder certificateArn(String var1);

        public Builder sslMode(String var1);

        public Builder sslMode(DmsSslModeValue var1);

        public Builder serviceAccessRoleArn(String var1);

        public Builder externalTableDefinition(String var1);

        public Builder dynamoDbSettings(DynamoDbSettings var1);

        default public Builder dynamoDbSettings(Consumer<DynamoDbSettings.Builder> dynamoDbSettings) {
            return this.dynamoDbSettings((DynamoDbSettings)((DynamoDbSettings.Builder)DynamoDbSettings.builder().applyMutation(dynamoDbSettings)).build());
        }

        public Builder s3Settings(S3Settings var1);

        default public Builder s3Settings(Consumer<S3Settings.Builder> s3Settings) {
            return this.s3Settings((S3Settings)((S3Settings.Builder)S3Settings.builder().applyMutation(s3Settings)).build());
        }

        public Builder dmsTransferSettings(DmsTransferSettings var1);

        default public Builder dmsTransferSettings(Consumer<DmsTransferSettings.Builder> dmsTransferSettings) {
            return this.dmsTransferSettings((DmsTransferSettings)((DmsTransferSettings.Builder)DmsTransferSettings.builder().applyMutation(dmsTransferSettings)).build());
        }

        public Builder mongoDbSettings(MongoDbSettings var1);

        default public Builder mongoDbSettings(Consumer<MongoDbSettings.Builder> mongoDbSettings) {
            return this.mongoDbSettings((MongoDbSettings)((MongoDbSettings.Builder)MongoDbSettings.builder().applyMutation(mongoDbSettings)).build());
        }

        public Builder kinesisSettings(KinesisSettings var1);

        default public Builder kinesisSettings(Consumer<KinesisSettings.Builder> kinesisSettings) {
            return this.kinesisSettings((KinesisSettings)((KinesisSettings.Builder)KinesisSettings.builder().applyMutation(kinesisSettings)).build());
        }

        public Builder kafkaSettings(KafkaSettings var1);

        default public Builder kafkaSettings(Consumer<KafkaSettings.Builder> kafkaSettings) {
            return this.kafkaSettings((KafkaSettings)((KafkaSettings.Builder)KafkaSettings.builder().applyMutation(kafkaSettings)).build());
        }

        public Builder elasticsearchSettings(ElasticsearchSettings var1);

        default public Builder elasticsearchSettings(Consumer<ElasticsearchSettings.Builder> elasticsearchSettings) {
            return this.elasticsearchSettings((ElasticsearchSettings)((ElasticsearchSettings.Builder)ElasticsearchSettings.builder().applyMutation(elasticsearchSettings)).build());
        }

        public Builder neptuneSettings(NeptuneSettings var1);

        default public Builder neptuneSettings(Consumer<NeptuneSettings.Builder> neptuneSettings) {
            return this.neptuneSettings((NeptuneSettings)((NeptuneSettings.Builder)NeptuneSettings.builder().applyMutation(neptuneSettings)).build());
        }

        public Builder redshiftSettings(RedshiftSettings var1);

        default public Builder redshiftSettings(Consumer<RedshiftSettings.Builder> redshiftSettings) {
            return this.redshiftSettings((RedshiftSettings)((RedshiftSettings.Builder)RedshiftSettings.builder().applyMutation(redshiftSettings)).build());
        }

        public Builder postgreSQLSettings(PostgreSQLSettings var1);

        default public Builder postgreSQLSettings(Consumer<PostgreSQLSettings.Builder> postgreSQLSettings) {
            return this.postgreSQLSettings((PostgreSQLSettings)((PostgreSQLSettings.Builder)PostgreSQLSettings.builder().applyMutation(postgreSQLSettings)).build());
        }

        public Builder mySQLSettings(MySQLSettings var1);

        default public Builder mySQLSettings(Consumer<MySQLSettings.Builder> mySQLSettings) {
            return this.mySQLSettings((MySQLSettings)((MySQLSettings.Builder)MySQLSettings.builder().applyMutation(mySQLSettings)).build());
        }

        public Builder oracleSettings(OracleSettings var1);

        default public Builder oracleSettings(Consumer<OracleSettings.Builder> oracleSettings) {
            return this.oracleSettings((OracleSettings)((OracleSettings.Builder)OracleSettings.builder().applyMutation(oracleSettings)).build());
        }

        public Builder sybaseSettings(SybaseSettings var1);

        default public Builder sybaseSettings(Consumer<SybaseSettings.Builder> sybaseSettings) {
            return this.sybaseSettings((SybaseSettings)((SybaseSettings.Builder)SybaseSettings.builder().applyMutation(sybaseSettings)).build());
        }

        public Builder microsoftSQLServerSettings(MicrosoftSQLServerSettings var1);

        default public Builder microsoftSQLServerSettings(Consumer<MicrosoftSQLServerSettings.Builder> microsoftSQLServerSettings) {
            return this.microsoftSQLServerSettings((MicrosoftSQLServerSettings)((MicrosoftSQLServerSettings.Builder)MicrosoftSQLServerSettings.builder().applyMutation(microsoftSQLServerSettings)).build());
        }

        public Builder ibmDb2Settings(IBMDb2Settings var1);

        default public Builder ibmDb2Settings(Consumer<IBMDb2Settings.Builder> ibmDb2Settings) {
            return this.ibmDb2Settings((IBMDb2Settings)((IBMDb2Settings.Builder)IBMDb2Settings.builder().applyMutation(ibmDb2Settings)).build());
        }

        public Builder resourceIdentifier(String var1);

        public Builder docDbSettings(DocDbSettings var1);

        default public Builder docDbSettings(Consumer<DocDbSettings.Builder> docDbSettings) {
            return this.docDbSettings((DocDbSettings)((DocDbSettings.Builder)DocDbSettings.builder().applyMutation(docDbSettings)).build());
        }

        public Builder redisSettings(RedisSettings var1);

        default public Builder redisSettings(Consumer<RedisSettings.Builder> redisSettings) {
            return this.redisSettings((RedisSettings)((RedisSettings.Builder)RedisSettings.builder().applyMutation(redisSettings)).build());
        }

        public Builder gcpMySQLSettings(GcpMySQLSettings var1);

        default public Builder gcpMySQLSettings(Consumer<GcpMySQLSettings.Builder> gcpMySQLSettings) {
            return this.gcpMySQLSettings((GcpMySQLSettings)((GcpMySQLSettings.Builder)GcpMySQLSettings.builder().applyMutation(gcpMySQLSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

