/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.Subnet;
import software.amazon.awssdk.services.databasemigration.model.SubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationSubnetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationSubnetGroup> {
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSubnetGroupIdentifier").getter(ReplicationSubnetGroup.getter(ReplicationSubnetGroup::replicationSubnetGroupIdentifier)).setter(ReplicationSubnetGroup.setter(Builder::replicationSubnetGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSubnetGroupDescription").getter(ReplicationSubnetGroup.getter(ReplicationSubnetGroup::replicationSubnetGroupDescription)).setter(ReplicationSubnetGroup.setter(Builder::replicationSubnetGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupDescription").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ReplicationSubnetGroup.getter(ReplicationSubnetGroup::vpcId)).setter(ReplicationSubnetGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupStatus").getter(ReplicationSubnetGroup.getter(ReplicationSubnetGroup::subnetGroupStatus)).setter(ReplicationSubnetGroup.setter(Builder::subnetGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()}).build();
    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(ReplicationSubnetGroup.getter(ReplicationSubnetGroup::subnets)).setter(ReplicationSubnetGroup.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_SUBNET_GROUP_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationSubnetGroupIdentifier;
    private final String replicationSubnetGroupDescription;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;

    private ReplicationSubnetGroup(BuilderImpl builder) {
        this.replicationSubnetGroupIdentifier = builder.replicationSubnetGroupIdentifier;
        this.replicationSubnetGroupDescription = builder.replicationSubnetGroupDescription;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
    }

    public final String replicationSubnetGroupIdentifier() {
        return this.replicationSubnetGroupIdentifier;
    }

    public final String replicationSubnetGroupDescription() {
        return this.replicationSubnetGroupDescription;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<Subnet> subnets() {
        return this.subnets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSubnetGroup)) {
            return false;
        }
        ReplicationSubnetGroup other = (ReplicationSubnetGroup)obj;
        return Objects.equals(this.replicationSubnetGroupIdentifier(), other.replicationSubnetGroupIdentifier()) && Objects.equals(this.replicationSubnetGroupDescription(), other.replicationSubnetGroupDescription()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetGroupStatus(), other.subnetGroupStatus()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationSubnetGroup").add("ReplicationSubnetGroupIdentifier", (Object)this.replicationSubnetGroupIdentifier()).add("ReplicationSubnetGroupDescription", (Object)this.replicationSubnetGroupDescription()).add("VpcId", (Object)this.vpcId()).add("SubnetGroupStatus", (Object)this.subnetGroupStatus()).add("Subnets", this.hasSubnets() ? this.subnets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationSubnetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupIdentifier()));
            }
            case "ReplicationSubnetGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupDescription()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupStatus()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSubnetGroup, T> g) {
        return obj -> g.apply((ReplicationSubnetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationSubnetGroupIdentifier;
        private String replicationSubnetGroupDescription;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSubnetGroup model) {
            this.replicationSubnetGroupIdentifier(model.replicationSubnetGroupIdentifier);
            this.replicationSubnetGroupDescription(model.replicationSubnetGroupDescription);
            this.vpcId(model.vpcId);
            this.subnetGroupStatus(model.subnetGroupStatus);
            this.subnets(model.subnets);
        }

        public final String getReplicationSubnetGroupIdentifier() {
            return this.replicationSubnetGroupIdentifier;
        }

        public final void setReplicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
        }

        @Override
        @Transient
        public final Builder replicationSubnetGroupIdentifier(String replicationSubnetGroupIdentifier) {
            this.replicationSubnetGroupIdentifier = replicationSubnetGroupIdentifier;
            return this;
        }

        public final String getReplicationSubnetGroupDescription() {
            return this.replicationSubnetGroupDescription;
        }

        public final void setReplicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
        }

        @Override
        @Transient
        public final Builder replicationSubnetGroupDescription(String replicationSubnetGroupDescription) {
            this.replicationSubnetGroupDescription = replicationSubnetGroupDescription;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        @Override
        @Transient
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        @Transient
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (Subnet)((Subnet.Builder)Subnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReplicationSubnetGroup build() {
            return new ReplicationSubnetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationSubnetGroup> {
        public Builder replicationSubnetGroupIdentifier(String var1);

        public Builder replicationSubnetGroupDescription(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder subnets(Consumer<Subnet.Builder> ... var1);
    }
}

