/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.CharLengthSemantics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OracleSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OracleSettings> {
    private static final SdkField<Boolean> ADD_SUPPLEMENTAL_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AddSupplementalLogging").getter(OracleSettings.getter(OracleSettings::addSupplementalLogging)).setter(OracleSettings.setter(Builder::addSupplementalLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddSupplementalLogging").build()}).build();
    private static final SdkField<Integer> ARCHIVED_LOG_DEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ArchivedLogDestId").getter(OracleSettings.getter(OracleSettings::archivedLogDestId)).setter(OracleSettings.setter(Builder::archivedLogDestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedLogDestId").build()}).build();
    private static final SdkField<Integer> ADDITIONAL_ARCHIVED_LOG_DEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AdditionalArchivedLogDestId").getter(OracleSettings.getter(OracleSettings::additionalArchivedLogDestId)).setter(OracleSettings.setter(Builder::additionalArchivedLogDestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalArchivedLogDestId").build()}).build();
    private static final SdkField<Boolean> ALLOW_SELECT_NESTED_TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSelectNestedTables").getter(OracleSettings.getter(OracleSettings::allowSelectNestedTables)).setter(OracleSettings.setter(Builder::allowSelectNestedTables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSelectNestedTables").build()}).build();
    private static final SdkField<Integer> PARALLEL_ASM_READ_THREADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelAsmReadThreads").getter(OracleSettings.getter(OracleSettings::parallelAsmReadThreads)).setter(OracleSettings.setter(Builder::parallelAsmReadThreads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelAsmReadThreads").build()}).build();
    private static final SdkField<Integer> READ_AHEAD_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReadAheadBlocks").getter(OracleSettings.getter(OracleSettings::readAheadBlocks)).setter(OracleSettings.setter(Builder::readAheadBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadAheadBlocks").build()}).build();
    private static final SdkField<Boolean> ACCESS_ALTERNATE_DIRECTLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AccessAlternateDirectly").getter(OracleSettings.getter(OracleSettings::accessAlternateDirectly)).setter(OracleSettings.setter(Builder::accessAlternateDirectly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessAlternateDirectly").build()}).build();
    private static final SdkField<Boolean> USE_ALTERNATE_FOLDER_FOR_ONLINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseAlternateFolderForOnline").getter(OracleSettings.getter(OracleSettings::useAlternateFolderForOnline)).setter(OracleSettings.setter(Builder::useAlternateFolderForOnline)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAlternateFolderForOnline").build()}).build();
    private static final SdkField<String> ORACLE_PATH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OraclePathPrefix").getter(OracleSettings.getter(OracleSettings::oraclePathPrefix)).setter(OracleSettings.setter(Builder::oraclePathPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OraclePathPrefix").build()}).build();
    private static final SdkField<String> USE_PATH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UsePathPrefix").getter(OracleSettings.getter(OracleSettings::usePathPrefix)).setter(OracleSettings.setter(Builder::usePathPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePathPrefix").build()}).build();
    private static final SdkField<Boolean> REPLACE_PATH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReplacePathPrefix").getter(OracleSettings.getter(OracleSettings::replacePathPrefix)).setter(OracleSettings.setter(Builder::replacePathPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacePathPrefix").build()}).build();
    private static final SdkField<Boolean> ENABLE_HOMOGENOUS_TABLESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableHomogenousTablespace").getter(OracleSettings.getter(OracleSettings::enableHomogenousTablespace)).setter(OracleSettings.setter(Builder::enableHomogenousTablespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHomogenousTablespace").build()}).build();
    private static final SdkField<Boolean> DIRECT_PATH_NO_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DirectPathNoLog").getter(OracleSettings.getter(OracleSettings::directPathNoLog)).setter(OracleSettings.setter(Builder::directPathNoLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectPathNoLog").build()}).build();
    private static final SdkField<Boolean> ARCHIVED_LOGS_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ArchivedLogsOnly").getter(OracleSettings.getter(OracleSettings::archivedLogsOnly)).setter(OracleSettings.setter(Builder::archivedLogsOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivedLogsOnly").build()}).build();
    private static final SdkField<String> ASM_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmPassword").getter(OracleSettings.getter(OracleSettings::asmPassword)).setter(OracleSettings.setter(Builder::asmPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmPassword").build()}).build();
    private static final SdkField<String> ASM_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmServer").getter(OracleSettings.getter(OracleSettings::asmServer)).setter(OracleSettings.setter(Builder::asmServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmServer").build()}).build();
    private static final SdkField<String> ASM_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AsmUser").getter(OracleSettings.getter(OracleSettings::asmUser)).setter(OracleSettings.setter(Builder::asmUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmUser").build()}).build();
    private static final SdkField<String> CHAR_LENGTH_SEMANTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharLengthSemantics").getter(OracleSettings.getter(OracleSettings::charLengthSemanticsAsString)).setter(OracleSettings.setter(Builder::charLengthSemantics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharLengthSemantics").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(OracleSettings.getter(OracleSettings::databaseName)).setter(OracleSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<Boolean> DIRECT_PATH_PARALLEL_LOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DirectPathParallelLoad").getter(OracleSettings.getter(OracleSettings::directPathParallelLoad)).setter(OracleSettings.setter(Builder::directPathParallelLoad)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectPathParallelLoad").build()}).build();
    private static final SdkField<Boolean> FAIL_TASKS_ON_LOB_TRUNCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FailTasksOnLobTruncation").getter(OracleSettings.getter(OracleSettings::failTasksOnLobTruncation)).setter(OracleSettings.setter(Builder::failTasksOnLobTruncation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailTasksOnLobTruncation").build()}).build();
    private static final SdkField<Integer> NUMBER_DATATYPE_SCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberDatatypeScale").getter(OracleSettings.getter(OracleSettings::numberDatatypeScale)).setter(OracleSettings.setter(Builder::numberDatatypeScale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberDatatypeScale").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(OracleSettings.getter(OracleSettings::password)).setter(OracleSettings.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(OracleSettings.getter(OracleSettings::port)).setter(OracleSettings.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Boolean> READ_TABLE_SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReadTableSpaceName").getter(OracleSettings.getter(OracleSettings::readTableSpaceName)).setter(OracleSettings.setter(Builder::readTableSpaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadTableSpaceName").build()}).build();
    private static final SdkField<Integer> RETRY_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetryInterval").getter(OracleSettings.getter(OracleSettings::retryInterval)).setter(OracleSettings.setter(Builder::retryInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryInterval").build()}).build();
    private static final SdkField<String> SECURITY_DB_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityDbEncryption").getter(OracleSettings.getter(OracleSettings::securityDbEncryption)).setter(OracleSettings.setter(Builder::securityDbEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDbEncryption").build()}).build();
    private static final SdkField<String> SECURITY_DB_ENCRYPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityDbEncryptionName").getter(OracleSettings.getter(OracleSettings::securityDbEncryptionName)).setter(OracleSettings.setter(Builder::securityDbEncryptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityDbEncryptionName").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(OracleSettings.getter(OracleSettings::serverName)).setter(OracleSettings.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<String> SPATIAL_DATA_OPTION_TO_GEO_JSON_FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpatialDataOptionToGeoJsonFunctionName").getter(OracleSettings.getter(OracleSettings::spatialDataOptionToGeoJsonFunctionName)).setter(OracleSettings.setter(Builder::spatialDataOptionToGeoJsonFunctionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpatialDataOptionToGeoJsonFunctionName").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(OracleSettings.getter(OracleSettings::username)).setter(OracleSettings.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerAccessRoleArn").getter(OracleSettings.getter(OracleSettings::secretsManagerAccessRoleArn)).setter(OracleSettings.setter(Builder::secretsManagerAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerSecretId").getter(OracleSettings.getter(OracleSettings::secretsManagerSecretId)).setter(OracleSettings.setter(Builder::secretsManagerSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerSecretId").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerOracleAsmAccessRoleArn").getter(OracleSettings.getter(OracleSettings::secretsManagerOracleAsmAccessRoleArn)).setter(OracleSettings.setter(Builder::secretsManagerOracleAsmAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerOracleAsmAccessRoleArn").build()}).build();
    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretsManagerOracleAsmSecretId").getter(OracleSettings.getter(OracleSettings::secretsManagerOracleAsmSecretId)).setter(OracleSettings.setter(Builder::secretsManagerOracleAsmSecretId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerOracleAsmSecretId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_SUPPLEMENTAL_LOGGING_FIELD, ARCHIVED_LOG_DEST_ID_FIELD, ADDITIONAL_ARCHIVED_LOG_DEST_ID_FIELD, ALLOW_SELECT_NESTED_TABLES_FIELD, PARALLEL_ASM_READ_THREADS_FIELD, READ_AHEAD_BLOCKS_FIELD, ACCESS_ALTERNATE_DIRECTLY_FIELD, USE_ALTERNATE_FOLDER_FOR_ONLINE_FIELD, ORACLE_PATH_PREFIX_FIELD, USE_PATH_PREFIX_FIELD, REPLACE_PATH_PREFIX_FIELD, ENABLE_HOMOGENOUS_TABLESPACE_FIELD, DIRECT_PATH_NO_LOG_FIELD, ARCHIVED_LOGS_ONLY_FIELD, ASM_PASSWORD_FIELD, ASM_SERVER_FIELD, ASM_USER_FIELD, CHAR_LENGTH_SEMANTICS_FIELD, DATABASE_NAME_FIELD, DIRECT_PATH_PARALLEL_LOAD_FIELD, FAIL_TASKS_ON_LOB_TRUNCATION_FIELD, NUMBER_DATATYPE_SCALE_FIELD, PASSWORD_FIELD, PORT_FIELD, READ_TABLE_SPACE_NAME_FIELD, RETRY_INTERVAL_FIELD, SECURITY_DB_ENCRYPTION_FIELD, SECURITY_DB_ENCRYPTION_NAME_FIELD, SERVER_NAME_FIELD, SPATIAL_DATA_OPTION_TO_GEO_JSON_FUNCTION_NAME_FIELD, USERNAME_FIELD, SECRETS_MANAGER_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_SECRET_ID_FIELD, SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD, SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean addSupplementalLogging;
    private final Integer archivedLogDestId;
    private final Integer additionalArchivedLogDestId;
    private final Boolean allowSelectNestedTables;
    private final Integer parallelAsmReadThreads;
    private final Integer readAheadBlocks;
    private final Boolean accessAlternateDirectly;
    private final Boolean useAlternateFolderForOnline;
    private final String oraclePathPrefix;
    private final String usePathPrefix;
    private final Boolean replacePathPrefix;
    private final Boolean enableHomogenousTablespace;
    private final Boolean directPathNoLog;
    private final Boolean archivedLogsOnly;
    private final String asmPassword;
    private final String asmServer;
    private final String asmUser;
    private final String charLengthSemantics;
    private final String databaseName;
    private final Boolean directPathParallelLoad;
    private final Boolean failTasksOnLobTruncation;
    private final Integer numberDatatypeScale;
    private final String password;
    private final Integer port;
    private final Boolean readTableSpaceName;
    private final Integer retryInterval;
    private final String securityDbEncryption;
    private final String securityDbEncryptionName;
    private final String serverName;
    private final String spatialDataOptionToGeoJsonFunctionName;
    private final String username;
    private final String secretsManagerAccessRoleArn;
    private final String secretsManagerSecretId;
    private final String secretsManagerOracleAsmAccessRoleArn;
    private final String secretsManagerOracleAsmSecretId;

    private OracleSettings(BuilderImpl builder) {
        this.addSupplementalLogging = builder.addSupplementalLogging;
        this.archivedLogDestId = builder.archivedLogDestId;
        this.additionalArchivedLogDestId = builder.additionalArchivedLogDestId;
        this.allowSelectNestedTables = builder.allowSelectNestedTables;
        this.parallelAsmReadThreads = builder.parallelAsmReadThreads;
        this.readAheadBlocks = builder.readAheadBlocks;
        this.accessAlternateDirectly = builder.accessAlternateDirectly;
        this.useAlternateFolderForOnline = builder.useAlternateFolderForOnline;
        this.oraclePathPrefix = builder.oraclePathPrefix;
        this.usePathPrefix = builder.usePathPrefix;
        this.replacePathPrefix = builder.replacePathPrefix;
        this.enableHomogenousTablespace = builder.enableHomogenousTablespace;
        this.directPathNoLog = builder.directPathNoLog;
        this.archivedLogsOnly = builder.archivedLogsOnly;
        this.asmPassword = builder.asmPassword;
        this.asmServer = builder.asmServer;
        this.asmUser = builder.asmUser;
        this.charLengthSemantics = builder.charLengthSemantics;
        this.databaseName = builder.databaseName;
        this.directPathParallelLoad = builder.directPathParallelLoad;
        this.failTasksOnLobTruncation = builder.failTasksOnLobTruncation;
        this.numberDatatypeScale = builder.numberDatatypeScale;
        this.password = builder.password;
        this.port = builder.port;
        this.readTableSpaceName = builder.readTableSpaceName;
        this.retryInterval = builder.retryInterval;
        this.securityDbEncryption = builder.securityDbEncryption;
        this.securityDbEncryptionName = builder.securityDbEncryptionName;
        this.serverName = builder.serverName;
        this.spatialDataOptionToGeoJsonFunctionName = builder.spatialDataOptionToGeoJsonFunctionName;
        this.username = builder.username;
        this.secretsManagerAccessRoleArn = builder.secretsManagerAccessRoleArn;
        this.secretsManagerSecretId = builder.secretsManagerSecretId;
        this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
        this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
    }

    public final Boolean addSupplementalLogging() {
        return this.addSupplementalLogging;
    }

    public final Integer archivedLogDestId() {
        return this.archivedLogDestId;
    }

    public final Integer additionalArchivedLogDestId() {
        return this.additionalArchivedLogDestId;
    }

    public final Boolean allowSelectNestedTables() {
        return this.allowSelectNestedTables;
    }

    public final Integer parallelAsmReadThreads() {
        return this.parallelAsmReadThreads;
    }

    public final Integer readAheadBlocks() {
        return this.readAheadBlocks;
    }

    public final Boolean accessAlternateDirectly() {
        return this.accessAlternateDirectly;
    }

    public final Boolean useAlternateFolderForOnline() {
        return this.useAlternateFolderForOnline;
    }

    public final String oraclePathPrefix() {
        return this.oraclePathPrefix;
    }

    public final String usePathPrefix() {
        return this.usePathPrefix;
    }

    public final Boolean replacePathPrefix() {
        return this.replacePathPrefix;
    }

    public final Boolean enableHomogenousTablespace() {
        return this.enableHomogenousTablespace;
    }

    public final Boolean directPathNoLog() {
        return this.directPathNoLog;
    }

    public final Boolean archivedLogsOnly() {
        return this.archivedLogsOnly;
    }

    public final String asmPassword() {
        return this.asmPassword;
    }

    public final String asmServer() {
        return this.asmServer;
    }

    public final String asmUser() {
        return this.asmUser;
    }

    public final CharLengthSemantics charLengthSemantics() {
        return CharLengthSemantics.fromValue(this.charLengthSemantics);
    }

    public final String charLengthSemanticsAsString() {
        return this.charLengthSemantics;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final Boolean directPathParallelLoad() {
        return this.directPathParallelLoad;
    }

    public final Boolean failTasksOnLobTruncation() {
        return this.failTasksOnLobTruncation;
    }

    public final Integer numberDatatypeScale() {
        return this.numberDatatypeScale;
    }

    public final String password() {
        return this.password;
    }

    public final Integer port() {
        return this.port;
    }

    public final Boolean readTableSpaceName() {
        return this.readTableSpaceName;
    }

    public final Integer retryInterval() {
        return this.retryInterval;
    }

    public final String securityDbEncryption() {
        return this.securityDbEncryption;
    }

    public final String securityDbEncryptionName() {
        return this.securityDbEncryptionName;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final String spatialDataOptionToGeoJsonFunctionName() {
        return this.spatialDataOptionToGeoJsonFunctionName;
    }

    public final String username() {
        return this.username;
    }

    public final String secretsManagerAccessRoleArn() {
        return this.secretsManagerAccessRoleArn;
    }

    public final String secretsManagerSecretId() {
        return this.secretsManagerSecretId;
    }

    public final String secretsManagerOracleAsmAccessRoleArn() {
        return this.secretsManagerOracleAsmAccessRoleArn;
    }

    public final String secretsManagerOracleAsmSecretId() {
        return this.secretsManagerOracleAsmSecretId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addSupplementalLogging());
        hashCode = 31 * hashCode + Objects.hashCode(this.archivedLogDestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalArchivedLogDestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSelectNestedTables());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelAsmReadThreads());
        hashCode = 31 * hashCode + Objects.hashCode(this.readAheadBlocks());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessAlternateDirectly());
        hashCode = 31 * hashCode + Objects.hashCode(this.useAlternateFolderForOnline());
        hashCode = 31 * hashCode + Objects.hashCode(this.oraclePathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.replacePathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableHomogenousTablespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.directPathNoLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.archivedLogsOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.asmPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.asmServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.asmUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.charLengthSemanticsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.directPathParallelLoad());
        hashCode = 31 * hashCode + Objects.hashCode(this.failTasksOnLobTruncation());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberDatatypeScale());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.readTableSpaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDbEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDbEncryptionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialDataOptionToGeoJsonFunctionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerOracleAsmAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerOracleAsmSecretId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OracleSettings)) {
            return false;
        }
        OracleSettings other = (OracleSettings)obj;
        return Objects.equals(this.addSupplementalLogging(), other.addSupplementalLogging()) && Objects.equals(this.archivedLogDestId(), other.archivedLogDestId()) && Objects.equals(this.additionalArchivedLogDestId(), other.additionalArchivedLogDestId()) && Objects.equals(this.allowSelectNestedTables(), other.allowSelectNestedTables()) && Objects.equals(this.parallelAsmReadThreads(), other.parallelAsmReadThreads()) && Objects.equals(this.readAheadBlocks(), other.readAheadBlocks()) && Objects.equals(this.accessAlternateDirectly(), other.accessAlternateDirectly()) && Objects.equals(this.useAlternateFolderForOnline(), other.useAlternateFolderForOnline()) && Objects.equals(this.oraclePathPrefix(), other.oraclePathPrefix()) && Objects.equals(this.usePathPrefix(), other.usePathPrefix()) && Objects.equals(this.replacePathPrefix(), other.replacePathPrefix()) && Objects.equals(this.enableHomogenousTablespace(), other.enableHomogenousTablespace()) && Objects.equals(this.directPathNoLog(), other.directPathNoLog()) && Objects.equals(this.archivedLogsOnly(), other.archivedLogsOnly()) && Objects.equals(this.asmPassword(), other.asmPassword()) && Objects.equals(this.asmServer(), other.asmServer()) && Objects.equals(this.asmUser(), other.asmUser()) && Objects.equals(this.charLengthSemanticsAsString(), other.charLengthSemanticsAsString()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.directPathParallelLoad(), other.directPathParallelLoad()) && Objects.equals(this.failTasksOnLobTruncation(), other.failTasksOnLobTruncation()) && Objects.equals(this.numberDatatypeScale(), other.numberDatatypeScale()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.readTableSpaceName(), other.readTableSpaceName()) && Objects.equals(this.retryInterval(), other.retryInterval()) && Objects.equals(this.securityDbEncryption(), other.securityDbEncryption()) && Objects.equals(this.securityDbEncryptionName(), other.securityDbEncryptionName()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.spatialDataOptionToGeoJsonFunctionName(), other.spatialDataOptionToGeoJsonFunctionName()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.secretsManagerAccessRoleArn(), other.secretsManagerAccessRoleArn()) && Objects.equals(this.secretsManagerSecretId(), other.secretsManagerSecretId()) && Objects.equals(this.secretsManagerOracleAsmAccessRoleArn(), other.secretsManagerOracleAsmAccessRoleArn()) && Objects.equals(this.secretsManagerOracleAsmSecretId(), other.secretsManagerOracleAsmSecretId());
    }

    public final String toString() {
        return ToString.builder((String)"OracleSettings").add("AddSupplementalLogging", (Object)this.addSupplementalLogging()).add("ArchivedLogDestId", (Object)this.archivedLogDestId()).add("AdditionalArchivedLogDestId", (Object)this.additionalArchivedLogDestId()).add("AllowSelectNestedTables", (Object)this.allowSelectNestedTables()).add("ParallelAsmReadThreads", (Object)this.parallelAsmReadThreads()).add("ReadAheadBlocks", (Object)this.readAheadBlocks()).add("AccessAlternateDirectly", (Object)this.accessAlternateDirectly()).add("UseAlternateFolderForOnline", (Object)this.useAlternateFolderForOnline()).add("OraclePathPrefix", (Object)this.oraclePathPrefix()).add("UsePathPrefix", (Object)this.usePathPrefix()).add("ReplacePathPrefix", (Object)this.replacePathPrefix()).add("EnableHomogenousTablespace", (Object)this.enableHomogenousTablespace()).add("DirectPathNoLog", (Object)this.directPathNoLog()).add("ArchivedLogsOnly", (Object)this.archivedLogsOnly()).add("AsmPassword", (Object)(this.asmPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("AsmServer", (Object)this.asmServer()).add("AsmUser", (Object)this.asmUser()).add("CharLengthSemantics", (Object)this.charLengthSemanticsAsString()).add("DatabaseName", (Object)this.databaseName()).add("DirectPathParallelLoad", (Object)this.directPathParallelLoad()).add("FailTasksOnLobTruncation", (Object)this.failTasksOnLobTruncation()).add("NumberDatatypeScale", (Object)this.numberDatatypeScale()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("ReadTableSpaceName", (Object)this.readTableSpaceName()).add("RetryInterval", (Object)this.retryInterval()).add("SecurityDbEncryption", (Object)(this.securityDbEncryption() == null ? null : "*** Sensitive Data Redacted ***")).add("SecurityDbEncryptionName", (Object)this.securityDbEncryptionName()).add("ServerName", (Object)this.serverName()).add("SpatialDataOptionToGeoJsonFunctionName", (Object)this.spatialDataOptionToGeoJsonFunctionName()).add("Username", (Object)this.username()).add("SecretsManagerAccessRoleArn", (Object)this.secretsManagerAccessRoleArn()).add("SecretsManagerSecretId", (Object)this.secretsManagerSecretId()).add("SecretsManagerOracleAsmAccessRoleArn", (Object)this.secretsManagerOracleAsmAccessRoleArn()).add("SecretsManagerOracleAsmSecretId", (Object)this.secretsManagerOracleAsmSecretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddSupplementalLogging": {
                return Optional.ofNullable(clazz.cast(this.addSupplementalLogging()));
            }
            case "ArchivedLogDestId": {
                return Optional.ofNullable(clazz.cast(this.archivedLogDestId()));
            }
            case "AdditionalArchivedLogDestId": {
                return Optional.ofNullable(clazz.cast(this.additionalArchivedLogDestId()));
            }
            case "AllowSelectNestedTables": {
                return Optional.ofNullable(clazz.cast(this.allowSelectNestedTables()));
            }
            case "ParallelAsmReadThreads": {
                return Optional.ofNullable(clazz.cast(this.parallelAsmReadThreads()));
            }
            case "ReadAheadBlocks": {
                return Optional.ofNullable(clazz.cast(this.readAheadBlocks()));
            }
            case "AccessAlternateDirectly": {
                return Optional.ofNullable(clazz.cast(this.accessAlternateDirectly()));
            }
            case "UseAlternateFolderForOnline": {
                return Optional.ofNullable(clazz.cast(this.useAlternateFolderForOnline()));
            }
            case "OraclePathPrefix": {
                return Optional.ofNullable(clazz.cast(this.oraclePathPrefix()));
            }
            case "UsePathPrefix": {
                return Optional.ofNullable(clazz.cast(this.usePathPrefix()));
            }
            case "ReplacePathPrefix": {
                return Optional.ofNullable(clazz.cast(this.replacePathPrefix()));
            }
            case "EnableHomogenousTablespace": {
                return Optional.ofNullable(clazz.cast(this.enableHomogenousTablespace()));
            }
            case "DirectPathNoLog": {
                return Optional.ofNullable(clazz.cast(this.directPathNoLog()));
            }
            case "ArchivedLogsOnly": {
                return Optional.ofNullable(clazz.cast(this.archivedLogsOnly()));
            }
            case "AsmPassword": {
                return Optional.ofNullable(clazz.cast(this.asmPassword()));
            }
            case "AsmServer": {
                return Optional.ofNullable(clazz.cast(this.asmServer()));
            }
            case "AsmUser": {
                return Optional.ofNullable(clazz.cast(this.asmUser()));
            }
            case "CharLengthSemantics": {
                return Optional.ofNullable(clazz.cast(this.charLengthSemanticsAsString()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DirectPathParallelLoad": {
                return Optional.ofNullable(clazz.cast(this.directPathParallelLoad()));
            }
            case "FailTasksOnLobTruncation": {
                return Optional.ofNullable(clazz.cast(this.failTasksOnLobTruncation()));
            }
            case "NumberDatatypeScale": {
                return Optional.ofNullable(clazz.cast(this.numberDatatypeScale()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "ReadTableSpaceName": {
                return Optional.ofNullable(clazz.cast(this.readTableSpaceName()));
            }
            case "RetryInterval": {
                return Optional.ofNullable(clazz.cast(this.retryInterval()));
            }
            case "SecurityDbEncryption": {
                return Optional.ofNullable(clazz.cast(this.securityDbEncryption()));
            }
            case "SecurityDbEncryptionName": {
                return Optional.ofNullable(clazz.cast(this.securityDbEncryptionName()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "SpatialDataOptionToGeoJsonFunctionName": {
                return Optional.ofNullable(clazz.cast(this.spatialDataOptionToGeoJsonFunctionName()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "SecretsManagerAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerAccessRoleArn()));
            }
            case "SecretsManagerSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecretId()));
            }
            case "SecretsManagerOracleAsmAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerOracleAsmAccessRoleArn()));
            }
            case "SecretsManagerOracleAsmSecretId": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerOracleAsmSecretId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OracleSettings, T> g) {
        return obj -> g.apply((OracleSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean addSupplementalLogging;
        private Integer archivedLogDestId;
        private Integer additionalArchivedLogDestId;
        private Boolean allowSelectNestedTables;
        private Integer parallelAsmReadThreads;
        private Integer readAheadBlocks;
        private Boolean accessAlternateDirectly;
        private Boolean useAlternateFolderForOnline;
        private String oraclePathPrefix;
        private String usePathPrefix;
        private Boolean replacePathPrefix;
        private Boolean enableHomogenousTablespace;
        private Boolean directPathNoLog;
        private Boolean archivedLogsOnly;
        private String asmPassword;
        private String asmServer;
        private String asmUser;
        private String charLengthSemantics;
        private String databaseName;
        private Boolean directPathParallelLoad;
        private Boolean failTasksOnLobTruncation;
        private Integer numberDatatypeScale;
        private String password;
        private Integer port;
        private Boolean readTableSpaceName;
        private Integer retryInterval;
        private String securityDbEncryption;
        private String securityDbEncryptionName;
        private String serverName;
        private String spatialDataOptionToGeoJsonFunctionName;
        private String username;
        private String secretsManagerAccessRoleArn;
        private String secretsManagerSecretId;
        private String secretsManagerOracleAsmAccessRoleArn;
        private String secretsManagerOracleAsmSecretId;

        private BuilderImpl() {
        }

        private BuilderImpl(OracleSettings model) {
            this.addSupplementalLogging(model.addSupplementalLogging);
            this.archivedLogDestId(model.archivedLogDestId);
            this.additionalArchivedLogDestId(model.additionalArchivedLogDestId);
            this.allowSelectNestedTables(model.allowSelectNestedTables);
            this.parallelAsmReadThreads(model.parallelAsmReadThreads);
            this.readAheadBlocks(model.readAheadBlocks);
            this.accessAlternateDirectly(model.accessAlternateDirectly);
            this.useAlternateFolderForOnline(model.useAlternateFolderForOnline);
            this.oraclePathPrefix(model.oraclePathPrefix);
            this.usePathPrefix(model.usePathPrefix);
            this.replacePathPrefix(model.replacePathPrefix);
            this.enableHomogenousTablespace(model.enableHomogenousTablespace);
            this.directPathNoLog(model.directPathNoLog);
            this.archivedLogsOnly(model.archivedLogsOnly);
            this.asmPassword(model.asmPassword);
            this.asmServer(model.asmServer);
            this.asmUser(model.asmUser);
            this.charLengthSemantics(model.charLengthSemantics);
            this.databaseName(model.databaseName);
            this.directPathParallelLoad(model.directPathParallelLoad);
            this.failTasksOnLobTruncation(model.failTasksOnLobTruncation);
            this.numberDatatypeScale(model.numberDatatypeScale);
            this.password(model.password);
            this.port(model.port);
            this.readTableSpaceName(model.readTableSpaceName);
            this.retryInterval(model.retryInterval);
            this.securityDbEncryption(model.securityDbEncryption);
            this.securityDbEncryptionName(model.securityDbEncryptionName);
            this.serverName(model.serverName);
            this.spatialDataOptionToGeoJsonFunctionName(model.spatialDataOptionToGeoJsonFunctionName);
            this.username(model.username);
            this.secretsManagerAccessRoleArn(model.secretsManagerAccessRoleArn);
            this.secretsManagerSecretId(model.secretsManagerSecretId);
            this.secretsManagerOracleAsmAccessRoleArn(model.secretsManagerOracleAsmAccessRoleArn);
            this.secretsManagerOracleAsmSecretId(model.secretsManagerOracleAsmSecretId);
        }

        public final Boolean getAddSupplementalLogging() {
            return this.addSupplementalLogging;
        }

        @Override
        public final Builder addSupplementalLogging(Boolean addSupplementalLogging) {
            this.addSupplementalLogging = addSupplementalLogging;
            return this;
        }

        public final void setAddSupplementalLogging(Boolean addSupplementalLogging) {
            this.addSupplementalLogging = addSupplementalLogging;
        }

        public final Integer getArchivedLogDestId() {
            return this.archivedLogDestId;
        }

        @Override
        public final Builder archivedLogDestId(Integer archivedLogDestId) {
            this.archivedLogDestId = archivedLogDestId;
            return this;
        }

        public final void setArchivedLogDestId(Integer archivedLogDestId) {
            this.archivedLogDestId = archivedLogDestId;
        }

        public final Integer getAdditionalArchivedLogDestId() {
            return this.additionalArchivedLogDestId;
        }

        @Override
        public final Builder additionalArchivedLogDestId(Integer additionalArchivedLogDestId) {
            this.additionalArchivedLogDestId = additionalArchivedLogDestId;
            return this;
        }

        public final void setAdditionalArchivedLogDestId(Integer additionalArchivedLogDestId) {
            this.additionalArchivedLogDestId = additionalArchivedLogDestId;
        }

        public final Boolean getAllowSelectNestedTables() {
            return this.allowSelectNestedTables;
        }

        @Override
        public final Builder allowSelectNestedTables(Boolean allowSelectNestedTables) {
            this.allowSelectNestedTables = allowSelectNestedTables;
            return this;
        }

        public final void setAllowSelectNestedTables(Boolean allowSelectNestedTables) {
            this.allowSelectNestedTables = allowSelectNestedTables;
        }

        public final Integer getParallelAsmReadThreads() {
            return this.parallelAsmReadThreads;
        }

        @Override
        public final Builder parallelAsmReadThreads(Integer parallelAsmReadThreads) {
            this.parallelAsmReadThreads = parallelAsmReadThreads;
            return this;
        }

        public final void setParallelAsmReadThreads(Integer parallelAsmReadThreads) {
            this.parallelAsmReadThreads = parallelAsmReadThreads;
        }

        public final Integer getReadAheadBlocks() {
            return this.readAheadBlocks;
        }

        @Override
        public final Builder readAheadBlocks(Integer readAheadBlocks) {
            this.readAheadBlocks = readAheadBlocks;
            return this;
        }

        public final void setReadAheadBlocks(Integer readAheadBlocks) {
            this.readAheadBlocks = readAheadBlocks;
        }

        public final Boolean getAccessAlternateDirectly() {
            return this.accessAlternateDirectly;
        }

        @Override
        public final Builder accessAlternateDirectly(Boolean accessAlternateDirectly) {
            this.accessAlternateDirectly = accessAlternateDirectly;
            return this;
        }

        public final void setAccessAlternateDirectly(Boolean accessAlternateDirectly) {
            this.accessAlternateDirectly = accessAlternateDirectly;
        }

        public final Boolean getUseAlternateFolderForOnline() {
            return this.useAlternateFolderForOnline;
        }

        @Override
        public final Builder useAlternateFolderForOnline(Boolean useAlternateFolderForOnline) {
            this.useAlternateFolderForOnline = useAlternateFolderForOnline;
            return this;
        }

        public final void setUseAlternateFolderForOnline(Boolean useAlternateFolderForOnline) {
            this.useAlternateFolderForOnline = useAlternateFolderForOnline;
        }

        public final String getOraclePathPrefix() {
            return this.oraclePathPrefix;
        }

        @Override
        public final Builder oraclePathPrefix(String oraclePathPrefix) {
            this.oraclePathPrefix = oraclePathPrefix;
            return this;
        }

        public final void setOraclePathPrefix(String oraclePathPrefix) {
            this.oraclePathPrefix = oraclePathPrefix;
        }

        public final String getUsePathPrefix() {
            return this.usePathPrefix;
        }

        @Override
        public final Builder usePathPrefix(String usePathPrefix) {
            this.usePathPrefix = usePathPrefix;
            return this;
        }

        public final void setUsePathPrefix(String usePathPrefix) {
            this.usePathPrefix = usePathPrefix;
        }

        public final Boolean getReplacePathPrefix() {
            return this.replacePathPrefix;
        }

        @Override
        public final Builder replacePathPrefix(Boolean replacePathPrefix) {
            this.replacePathPrefix = replacePathPrefix;
            return this;
        }

        public final void setReplacePathPrefix(Boolean replacePathPrefix) {
            this.replacePathPrefix = replacePathPrefix;
        }

        public final Boolean getEnableHomogenousTablespace() {
            return this.enableHomogenousTablespace;
        }

        @Override
        public final Builder enableHomogenousTablespace(Boolean enableHomogenousTablespace) {
            this.enableHomogenousTablespace = enableHomogenousTablespace;
            return this;
        }

        public final void setEnableHomogenousTablespace(Boolean enableHomogenousTablespace) {
            this.enableHomogenousTablespace = enableHomogenousTablespace;
        }

        public final Boolean getDirectPathNoLog() {
            return this.directPathNoLog;
        }

        @Override
        public final Builder directPathNoLog(Boolean directPathNoLog) {
            this.directPathNoLog = directPathNoLog;
            return this;
        }

        public final void setDirectPathNoLog(Boolean directPathNoLog) {
            this.directPathNoLog = directPathNoLog;
        }

        public final Boolean getArchivedLogsOnly() {
            return this.archivedLogsOnly;
        }

        @Override
        public final Builder archivedLogsOnly(Boolean archivedLogsOnly) {
            this.archivedLogsOnly = archivedLogsOnly;
            return this;
        }

        public final void setArchivedLogsOnly(Boolean archivedLogsOnly) {
            this.archivedLogsOnly = archivedLogsOnly;
        }

        public final String getAsmPassword() {
            return this.asmPassword;
        }

        @Override
        public final Builder asmPassword(String asmPassword) {
            this.asmPassword = asmPassword;
            return this;
        }

        public final void setAsmPassword(String asmPassword) {
            this.asmPassword = asmPassword;
        }

        public final String getAsmServer() {
            return this.asmServer;
        }

        @Override
        public final Builder asmServer(String asmServer) {
            this.asmServer = asmServer;
            return this;
        }

        public final void setAsmServer(String asmServer) {
            this.asmServer = asmServer;
        }

        public final String getAsmUser() {
            return this.asmUser;
        }

        @Override
        public final Builder asmUser(String asmUser) {
            this.asmUser = asmUser;
            return this;
        }

        public final void setAsmUser(String asmUser) {
            this.asmUser = asmUser;
        }

        public final String getCharLengthSemantics() {
            return this.charLengthSemantics;
        }

        @Override
        public final Builder charLengthSemantics(String charLengthSemantics) {
            this.charLengthSemantics = charLengthSemantics;
            return this;
        }

        @Override
        public final Builder charLengthSemantics(CharLengthSemantics charLengthSemantics) {
            this.charLengthSemantics(charLengthSemantics == null ? null : charLengthSemantics.toString());
            return this;
        }

        public final void setCharLengthSemantics(String charLengthSemantics) {
            this.charLengthSemantics = charLengthSemantics;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final Boolean getDirectPathParallelLoad() {
            return this.directPathParallelLoad;
        }

        @Override
        public final Builder directPathParallelLoad(Boolean directPathParallelLoad) {
            this.directPathParallelLoad = directPathParallelLoad;
            return this;
        }

        public final void setDirectPathParallelLoad(Boolean directPathParallelLoad) {
            this.directPathParallelLoad = directPathParallelLoad;
        }

        public final Boolean getFailTasksOnLobTruncation() {
            return this.failTasksOnLobTruncation;
        }

        @Override
        public final Builder failTasksOnLobTruncation(Boolean failTasksOnLobTruncation) {
            this.failTasksOnLobTruncation = failTasksOnLobTruncation;
            return this;
        }

        public final void setFailTasksOnLobTruncation(Boolean failTasksOnLobTruncation) {
            this.failTasksOnLobTruncation = failTasksOnLobTruncation;
        }

        public final Integer getNumberDatatypeScale() {
            return this.numberDatatypeScale;
        }

        @Override
        public final Builder numberDatatypeScale(Integer numberDatatypeScale) {
            this.numberDatatypeScale = numberDatatypeScale;
            return this;
        }

        public final void setNumberDatatypeScale(Integer numberDatatypeScale) {
            this.numberDatatypeScale = numberDatatypeScale;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final Boolean getReadTableSpaceName() {
            return this.readTableSpaceName;
        }

        @Override
        public final Builder readTableSpaceName(Boolean readTableSpaceName) {
            this.readTableSpaceName = readTableSpaceName;
            return this;
        }

        public final void setReadTableSpaceName(Boolean readTableSpaceName) {
            this.readTableSpaceName = readTableSpaceName;
        }

        public final Integer getRetryInterval() {
            return this.retryInterval;
        }

        @Override
        public final Builder retryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public final void setRetryInterval(Integer retryInterval) {
            this.retryInterval = retryInterval;
        }

        public final String getSecurityDbEncryption() {
            return this.securityDbEncryption;
        }

        @Override
        public final Builder securityDbEncryption(String securityDbEncryption) {
            this.securityDbEncryption = securityDbEncryption;
            return this;
        }

        public final void setSecurityDbEncryption(String securityDbEncryption) {
            this.securityDbEncryption = securityDbEncryption;
        }

        public final String getSecurityDbEncryptionName() {
            return this.securityDbEncryptionName;
        }

        @Override
        public final Builder securityDbEncryptionName(String securityDbEncryptionName) {
            this.securityDbEncryptionName = securityDbEncryptionName;
            return this;
        }

        public final void setSecurityDbEncryptionName(String securityDbEncryptionName) {
            this.securityDbEncryptionName = securityDbEncryptionName;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final String getSpatialDataOptionToGeoJsonFunctionName() {
            return this.spatialDataOptionToGeoJsonFunctionName;
        }

        @Override
        public final Builder spatialDataOptionToGeoJsonFunctionName(String spatialDataOptionToGeoJsonFunctionName) {
            this.spatialDataOptionToGeoJsonFunctionName = spatialDataOptionToGeoJsonFunctionName;
            return this;
        }

        public final void setSpatialDataOptionToGeoJsonFunctionName(String spatialDataOptionToGeoJsonFunctionName) {
            this.spatialDataOptionToGeoJsonFunctionName = spatialDataOptionToGeoJsonFunctionName;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getSecretsManagerAccessRoleArn() {
            return this.secretsManagerAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
            return this;
        }

        public final void setSecretsManagerAccessRoleArn(String secretsManagerAccessRoleArn) {
            this.secretsManagerAccessRoleArn = secretsManagerAccessRoleArn;
        }

        public final String getSecretsManagerSecretId() {
            return this.secretsManagerSecretId;
        }

        @Override
        public final Builder secretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
            return this;
        }

        public final void setSecretsManagerSecretId(String secretsManagerSecretId) {
            this.secretsManagerSecretId = secretsManagerSecretId;
        }

        public final String getSecretsManagerOracleAsmAccessRoleArn() {
            return this.secretsManagerOracleAsmAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
            return this;
        }

        public final void setSecretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
        }

        public final String getSecretsManagerOracleAsmSecretId() {
            return this.secretsManagerOracleAsmSecretId;
        }

        @Override
        public final Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
            return this;
        }

        public final void setSecretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
        }

        public OracleSettings build() {
            return new OracleSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OracleSettings> {
        public Builder addSupplementalLogging(Boolean var1);

        public Builder archivedLogDestId(Integer var1);

        public Builder additionalArchivedLogDestId(Integer var1);

        public Builder allowSelectNestedTables(Boolean var1);

        public Builder parallelAsmReadThreads(Integer var1);

        public Builder readAheadBlocks(Integer var1);

        public Builder accessAlternateDirectly(Boolean var1);

        public Builder useAlternateFolderForOnline(Boolean var1);

        public Builder oraclePathPrefix(String var1);

        public Builder usePathPrefix(String var1);

        public Builder replacePathPrefix(Boolean var1);

        public Builder enableHomogenousTablespace(Boolean var1);

        public Builder directPathNoLog(Boolean var1);

        public Builder archivedLogsOnly(Boolean var1);

        public Builder asmPassword(String var1);

        public Builder asmServer(String var1);

        public Builder asmUser(String var1);

        public Builder charLengthSemantics(String var1);

        public Builder charLengthSemantics(CharLengthSemantics var1);

        public Builder databaseName(String var1);

        public Builder directPathParallelLoad(Boolean var1);

        public Builder failTasksOnLobTruncation(Boolean var1);

        public Builder numberDatatypeScale(Integer var1);

        public Builder password(String var1);

        public Builder port(Integer var1);

        public Builder readTableSpaceName(Boolean var1);

        public Builder retryInterval(Integer var1);

        public Builder securityDbEncryption(String var1);

        public Builder securityDbEncryptionName(String var1);

        public Builder serverName(String var1);

        public Builder spatialDataOptionToGeoJsonFunctionName(String var1);

        public Builder username(String var1);

        public Builder secretsManagerAccessRoleArn(String var1);

        public Builder secretsManagerSecretId(String var1);

        public Builder secretsManagerOracleAsmAccessRoleArn(String var1);

        public Builder secretsManagerOracleAsmSecretId(String var1);
    }
}

