/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;

public class DescribeEndpointSettingsPublisher
implements SdkPublisher<DescribeEndpointSettingsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeEndpointSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEndpointSettingsPublisher(DatabaseMigrationAsyncClient client, DescribeEndpointSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEndpointSettingsPublisher(DatabaseMigrationAsyncClient client, DescribeEndpointSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEndpointSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEndpointSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeEndpointSettingsResponseFetcher
    implements AsyncPageFetcher<DescribeEndpointSettingsResponse> {
        private DescribeEndpointSettingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEndpointSettingsResponse> nextPage(DescribeEndpointSettingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointSettingsPublisher.this.client.describeEndpointSettings(DescribeEndpointSettingsPublisher.this.firstRequest);
            }
            return DescribeEndpointSettingsPublisher.this.client.describeEndpointSettings((DescribeEndpointSettingsRequest)((Object)DescribeEndpointSettingsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

