/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.MessageFormatValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KafkaSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KafkaSettings> {
    private static final SdkField<String> BROKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Broker").getter(KafkaSettings.getter(KafkaSettings::broker)).setter(KafkaSettings.setter(Builder::broker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Broker").build()}).build();
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Topic").getter(KafkaSettings.getter(KafkaSettings::topic)).setter(KafkaSettings.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Topic").build()}).build();
    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageFormat").getter(KafkaSettings.getter(KafkaSettings::messageFormatAsString)).setter(KafkaSettings.setter(Builder::messageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TRANSACTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTransactionDetails").getter(KafkaSettings.getter(KafkaSettings::includeTransactionDetails)).setter(KafkaSettings.setter(Builder::includeTransactionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTransactionDetails").build()}).build();
    private static final SdkField<Boolean> INCLUDE_PARTITION_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludePartitionValue").getter(KafkaSettings.getter(KafkaSettings::includePartitionValue)).setter(KafkaSettings.setter(Builder::includePartitionValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePartitionValue").build()}).build();
    private static final SdkField<Boolean> PARTITION_INCLUDE_SCHEMA_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PartitionIncludeSchemaTable").getter(KafkaSettings.getter(KafkaSettings::partitionIncludeSchemaTable)).setter(KafkaSettings.setter(Builder::partitionIncludeSchemaTable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIncludeSchemaTable").build()}).build();
    private static final SdkField<Boolean> INCLUDE_TABLE_ALTER_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeTableAlterOperations").getter(KafkaSettings.getter(KafkaSettings::includeTableAlterOperations)).setter(KafkaSettings.setter(Builder::includeTableAlterOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTableAlterOperations").build()}).build();
    private static final SdkField<Boolean> INCLUDE_CONTROL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeControlDetails").getter(KafkaSettings.getter(KafkaSettings::includeControlDetails)).setter(KafkaSettings.setter(Builder::includeControlDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeControlDetails").build()}).build();
    private static final SdkField<Integer> MESSAGE_MAX_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MessageMaxBytes").getter(KafkaSettings.getter(KafkaSettings::messageMaxBytes)).setter(KafkaSettings.setter(Builder::messageMaxBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageMaxBytes").build()}).build();
    private static final SdkField<Boolean> INCLUDE_NULL_AND_EMPTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeNullAndEmpty").getter(KafkaSettings.getter(KafkaSettings::includeNullAndEmpty)).setter(KafkaSettings.setter(Builder::includeNullAndEmpty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNullAndEmpty").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_FIELD, TOPIC_FIELD, MESSAGE_FORMAT_FIELD, INCLUDE_TRANSACTION_DETAILS_FIELD, INCLUDE_PARTITION_VALUE_FIELD, PARTITION_INCLUDE_SCHEMA_TABLE_FIELD, INCLUDE_TABLE_ALTER_OPERATIONS_FIELD, INCLUDE_CONTROL_DETAILS_FIELD, MESSAGE_MAX_BYTES_FIELD, INCLUDE_NULL_AND_EMPTY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String broker;
    private final String topic;
    private final String messageFormat;
    private final Boolean includeTransactionDetails;
    private final Boolean includePartitionValue;
    private final Boolean partitionIncludeSchemaTable;
    private final Boolean includeTableAlterOperations;
    private final Boolean includeControlDetails;
    private final Integer messageMaxBytes;
    private final Boolean includeNullAndEmpty;

    private KafkaSettings(BuilderImpl builder) {
        this.broker = builder.broker;
        this.topic = builder.topic;
        this.messageFormat = builder.messageFormat;
        this.includeTransactionDetails = builder.includeTransactionDetails;
        this.includePartitionValue = builder.includePartitionValue;
        this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
        this.includeTableAlterOperations = builder.includeTableAlterOperations;
        this.includeControlDetails = builder.includeControlDetails;
        this.messageMaxBytes = builder.messageMaxBytes;
        this.includeNullAndEmpty = builder.includeNullAndEmpty;
    }

    public final String broker() {
        return this.broker;
    }

    public final String topic() {
        return this.topic;
    }

    public final MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(this.messageFormat);
    }

    public final String messageFormatAsString() {
        return this.messageFormat;
    }

    public final Boolean includeTransactionDetails() {
        return this.includeTransactionDetails;
    }

    public final Boolean includePartitionValue() {
        return this.includePartitionValue;
    }

    public final Boolean partitionIncludeSchemaTable() {
        return this.partitionIncludeSchemaTable;
    }

    public final Boolean includeTableAlterOperations() {
        return this.includeTableAlterOperations;
    }

    public final Boolean includeControlDetails() {
        return this.includeControlDetails;
    }

    public final Integer messageMaxBytes() {
        return this.messageMaxBytes;
    }

    public final Boolean includeNullAndEmpty() {
        return this.includeNullAndEmpty;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.broker());
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTransactionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.includePartitionValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionIncludeSchemaTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeTableAlterOperations());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeControlDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageMaxBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNullAndEmpty());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KafkaSettings)) {
            return false;
        }
        KafkaSettings other = (KafkaSettings)obj;
        return Objects.equals(this.broker(), other.broker()) && Objects.equals(this.topic(), other.topic()) && Objects.equals(this.messageFormatAsString(), other.messageFormatAsString()) && Objects.equals(this.includeTransactionDetails(), other.includeTransactionDetails()) && Objects.equals(this.includePartitionValue(), other.includePartitionValue()) && Objects.equals(this.partitionIncludeSchemaTable(), other.partitionIncludeSchemaTable()) && Objects.equals(this.includeTableAlterOperations(), other.includeTableAlterOperations()) && Objects.equals(this.includeControlDetails(), other.includeControlDetails()) && Objects.equals(this.messageMaxBytes(), other.messageMaxBytes()) && Objects.equals(this.includeNullAndEmpty(), other.includeNullAndEmpty());
    }

    public final String toString() {
        return ToString.builder((String)"KafkaSettings").add("Broker", (Object)this.broker()).add("Topic", (Object)this.topic()).add("MessageFormat", (Object)this.messageFormatAsString()).add("IncludeTransactionDetails", (Object)this.includeTransactionDetails()).add("IncludePartitionValue", (Object)this.includePartitionValue()).add("PartitionIncludeSchemaTable", (Object)this.partitionIncludeSchemaTable()).add("IncludeTableAlterOperations", (Object)this.includeTableAlterOperations()).add("IncludeControlDetails", (Object)this.includeControlDetails()).add("MessageMaxBytes", (Object)this.messageMaxBytes()).add("IncludeNullAndEmpty", (Object)this.includeNullAndEmpty()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Broker": {
                return Optional.ofNullable(clazz.cast(this.broker()));
            }
            case "Topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "MessageFormat": {
                return Optional.ofNullable(clazz.cast(this.messageFormatAsString()));
            }
            case "IncludeTransactionDetails": {
                return Optional.ofNullable(clazz.cast(this.includeTransactionDetails()));
            }
            case "IncludePartitionValue": {
                return Optional.ofNullable(clazz.cast(this.includePartitionValue()));
            }
            case "PartitionIncludeSchemaTable": {
                return Optional.ofNullable(clazz.cast(this.partitionIncludeSchemaTable()));
            }
            case "IncludeTableAlterOperations": {
                return Optional.ofNullable(clazz.cast(this.includeTableAlterOperations()));
            }
            case "IncludeControlDetails": {
                return Optional.ofNullable(clazz.cast(this.includeControlDetails()));
            }
            case "MessageMaxBytes": {
                return Optional.ofNullable(clazz.cast(this.messageMaxBytes()));
            }
            case "IncludeNullAndEmpty": {
                return Optional.ofNullable(clazz.cast(this.includeNullAndEmpty()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KafkaSettings, T> g) {
        return obj -> g.apply((KafkaSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String broker;
        private String topic;
        private String messageFormat;
        private Boolean includeTransactionDetails;
        private Boolean includePartitionValue;
        private Boolean partitionIncludeSchemaTable;
        private Boolean includeTableAlterOperations;
        private Boolean includeControlDetails;
        private Integer messageMaxBytes;
        private Boolean includeNullAndEmpty;

        private BuilderImpl() {
        }

        private BuilderImpl(KafkaSettings model) {
            this.broker(model.broker);
            this.topic(model.topic);
            this.messageFormat(model.messageFormat);
            this.includeTransactionDetails(model.includeTransactionDetails);
            this.includePartitionValue(model.includePartitionValue);
            this.partitionIncludeSchemaTable(model.partitionIncludeSchemaTable);
            this.includeTableAlterOperations(model.includeTableAlterOperations);
            this.includeControlDetails(model.includeControlDetails);
            this.messageMaxBytes(model.messageMaxBytes);
            this.includeNullAndEmpty(model.includeNullAndEmpty);
        }

        public final String getBroker() {
            return this.broker;
        }

        @Override
        public final Builder broker(String broker) {
            this.broker = broker;
            return this;
        }

        public final void setBroker(String broker) {
            this.broker = broker;
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final String getMessageFormat() {
            return this.messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        public final Boolean getIncludeTransactionDetails() {
            return this.includeTransactionDetails;
        }

        @Override
        public final Builder includeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
            return this;
        }

        public final void setIncludeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
        }

        public final Boolean getIncludePartitionValue() {
            return this.includePartitionValue;
        }

        @Override
        public final Builder includePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
            return this;
        }

        public final void setIncludePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
        }

        public final Boolean getPartitionIncludeSchemaTable() {
            return this.partitionIncludeSchemaTable;
        }

        @Override
        public final Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
            return this;
        }

        public final void setPartitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
        }

        public final Boolean getIncludeTableAlterOperations() {
            return this.includeTableAlterOperations;
        }

        @Override
        public final Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
            return this;
        }

        public final void setIncludeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
        }

        public final Boolean getIncludeControlDetails() {
            return this.includeControlDetails;
        }

        @Override
        public final Builder includeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
            return this;
        }

        public final void setIncludeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
        }

        public final Integer getMessageMaxBytes() {
            return this.messageMaxBytes;
        }

        @Override
        public final Builder messageMaxBytes(Integer messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
            return this;
        }

        public final void setMessageMaxBytes(Integer messageMaxBytes) {
            this.messageMaxBytes = messageMaxBytes;
        }

        public final Boolean getIncludeNullAndEmpty() {
            return this.includeNullAndEmpty;
        }

        @Override
        public final Builder includeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
            return this;
        }

        public final void setIncludeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
        }

        public KafkaSettings build() {
            return new KafkaSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KafkaSettings> {
        public Builder broker(String var1);

        public Builder topic(String var1);

        public Builder messageFormat(String var1);

        public Builder messageFormat(MessageFormatValue var1);

        public Builder includeTransactionDetails(Boolean var1);

        public Builder includePartitionValue(Boolean var1);

        public Builder partitionIncludeSchemaTable(Boolean var1);

        public Builder includeTableAlterOperations(Boolean var1);

        public Builder includeControlDetails(Boolean var1);

        public Builder messageMaxBytes(Integer var1);

        public Builder includeNullAndEmpty(Boolean var1);
    }
}

