/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.EventCategoryGroup;
import software.amazon.awssdk.services.databasemigration.model.EventCategoryGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventCategoriesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeEventCategoriesResponse> {
    private static final SdkField<List<EventCategoryGroup>> EVENT_CATEGORY_GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventCategoryGroupList").getter(DescribeEventCategoriesResponse.getter(DescribeEventCategoriesResponse::eventCategoryGroupList)).setter(DescribeEventCategoriesResponse.setter(Builder::eventCategoryGroupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoryGroupList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventCategoryGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CATEGORY_GROUP_LIST_FIELD));
    private final List<EventCategoryGroup> eventCategoryGroupList;

    private DescribeEventCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.eventCategoryGroupList = builder.eventCategoryGroupList;
    }

    public boolean hasEventCategoryGroupList() {
        return this.eventCategoryGroupList != null && !(this.eventCategoryGroupList instanceof SdkAutoConstructList);
    }

    public List<EventCategoryGroup> eventCategoryGroupList() {
        return this.eventCategoryGroupList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventCategoryGroupList() ? this.eventCategoryGroupList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesResponse)) {
            return false;
        }
        DescribeEventCategoriesResponse other = (DescribeEventCategoriesResponse)((Object)obj);
        return this.hasEventCategoryGroupList() == other.hasEventCategoryGroupList() && Objects.equals(this.eventCategoryGroupList(), other.eventCategoryGroupList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventCategoriesResponse").add("EventCategoryGroupList", this.hasEventCategoryGroupList() ? this.eventCategoryGroupList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventCategoryGroupList": {
                return Optional.ofNullable(clazz.cast(this.eventCategoryGroupList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventCategoriesResponse, T> g) {
        return obj -> g.apply((DescribeEventCategoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private List<EventCategoryGroup> eventCategoryGroupList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesResponse model) {
            super(model);
            this.eventCategoryGroupList(model.eventCategoryGroupList);
        }

        public final Collection<EventCategoryGroup.Builder> getEventCategoryGroupList() {
            if (this.eventCategoryGroupList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventCategoryGroupList != null ? (Collection)this.eventCategoryGroupList.stream().map(EventCategoryGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventCategoryGroupList(Collection<EventCategoryGroup> eventCategoryGroupList) {
            this.eventCategoryGroupList = EventCategoryGroupListCopier.copy(eventCategoryGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoryGroupList(EventCategoryGroup ... eventCategoryGroupList) {
            this.eventCategoryGroupList(Arrays.asList(eventCategoryGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoryGroupList(Consumer<EventCategoryGroup.Builder> ... eventCategoryGroupList) {
            this.eventCategoryGroupList(Stream.of(eventCategoryGroupList).map(c -> (EventCategoryGroup)((EventCategoryGroup.Builder)EventCategoryGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventCategoryGroupList(Collection<EventCategoryGroup.BuilderImpl> eventCategoryGroupList) {
            this.eventCategoryGroupList = EventCategoryGroupListCopier.copyFromBuilder(eventCategoryGroupList);
        }

        @Override
        public DescribeEventCategoriesResponse build() {
            return new DescribeEventCategoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventCategoriesResponse> {
        public Builder eventCategoryGroupList(Collection<EventCategoryGroup> var1);

        public Builder eventCategoryGroupList(EventCategoryGroup ... var1);

        public Builder eventCategoryGroupList(Consumer<EventCategoryGroup.Builder> ... var1);
    }
}

