/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessment;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskIndividualAssessmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationTaskIndividualAssessmentsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationTaskIndividualAssessmentsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReplicationTaskIndividualAssessmentsResponse.getter(DescribeReplicationTaskIndividualAssessmentsResponse::marker)).setter(DescribeReplicationTaskIndividualAssessmentsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationTaskIndividualAssessment>> REPLICATION_TASK_INDIVIDUAL_ASSESSMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationTaskIndividualAssessments").getter(DescribeReplicationTaskIndividualAssessmentsResponse.getter(DescribeReplicationTaskIndividualAssessmentsResponse::replicationTaskIndividualAssessments)).setter(DescribeReplicationTaskIndividualAssessmentsResponse.setter(Builder::replicationTaskIndividualAssessments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskIndividualAssessments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationTaskIndividualAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_TASK_INDIVIDUAL_ASSESSMENTS_FIELD));
    private final String marker;
    private final List<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments;

    private DescribeReplicationTaskIndividualAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationTaskIndividualAssessments = builder.replicationTaskIndividualAssessments;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasReplicationTaskIndividualAssessments() {
        return this.replicationTaskIndividualAssessments != null && !(this.replicationTaskIndividualAssessments instanceof SdkAutoConstructList);
    }

    public List<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments() {
        return this.replicationTaskIndividualAssessments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationTaskIndividualAssessments() ? this.replicationTaskIndividualAssessments() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskIndividualAssessmentsResponse)) {
            return false;
        }
        DescribeReplicationTaskIndividualAssessmentsResponse other = (DescribeReplicationTaskIndividualAssessmentsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasReplicationTaskIndividualAssessments() == other.hasReplicationTaskIndividualAssessments() && Objects.equals(this.replicationTaskIndividualAssessments(), other.replicationTaskIndividualAssessments());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationTaskIndividualAssessmentsResponse").add("Marker", (Object)this.marker()).add("ReplicationTaskIndividualAssessments", this.hasReplicationTaskIndividualAssessments() ? this.replicationTaskIndividualAssessments() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationTaskIndividualAssessments": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskIndividualAssessments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTaskIndividualAssessmentsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTaskIndividualAssessmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskIndividualAssessmentsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationTaskIndividualAssessments(model.replicationTaskIndividualAssessments);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationTaskIndividualAssessment.Builder> getReplicationTaskIndividualAssessments() {
            if (this.replicationTaskIndividualAssessments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationTaskIndividualAssessments != null ? (Collection)this.replicationTaskIndividualAssessments.stream().map(ReplicationTaskIndividualAssessment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationTaskIndividualAssessments(Collection<ReplicationTaskIndividualAssessment> replicationTaskIndividualAssessments) {
            this.replicationTaskIndividualAssessments = ReplicationTaskIndividualAssessmentListCopier.copy(replicationTaskIndividualAssessments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskIndividualAssessments(ReplicationTaskIndividualAssessment ... replicationTaskIndividualAssessments) {
            this.replicationTaskIndividualAssessments(Arrays.asList(replicationTaskIndividualAssessments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskIndividualAssessments(Consumer<ReplicationTaskIndividualAssessment.Builder> ... replicationTaskIndividualAssessments) {
            this.replicationTaskIndividualAssessments(Stream.of(replicationTaskIndividualAssessments).map(c -> (ReplicationTaskIndividualAssessment)((ReplicationTaskIndividualAssessment.Builder)ReplicationTaskIndividualAssessment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationTaskIndividualAssessments(Collection<ReplicationTaskIndividualAssessment.BuilderImpl> replicationTaskIndividualAssessments) {
            this.replicationTaskIndividualAssessments = ReplicationTaskIndividualAssessmentListCopier.copyFromBuilder(replicationTaskIndividualAssessments);
        }

        @Override
        public DescribeReplicationTaskIndividualAssessmentsResponse build() {
            return new DescribeReplicationTaskIndividualAssessmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationTaskIndividualAssessmentsResponse> {
        public Builder marker(String var1);

        public Builder replicationTaskIndividualAssessments(Collection<ReplicationTaskIndividualAssessment> var1);

        public Builder replicationTaskIndividualAssessments(ReplicationTaskIndividualAssessment ... var1);

        public Builder replicationTaskIndividualAssessments(Consumer<ReplicationTaskIndividualAssessment.Builder> ... var1);
    }
}

