/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AuthMechanismValue {
    DEFAULT("default"),
    MONGODB_CR("mongodb_cr"),
    SCRAM_SHA_1("scram_sha_1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AuthMechanismValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthMechanismValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AuthMechanismValue.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthMechanismValue> knownValues() {
        return Stream.of(AuthMechanismValue.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

