/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadOptionValue;
import software.amazon.awssdk.services.databasemigration.model.TableListToReloadCopier;
import software.amazon.awssdk.services.databasemigration.model.TableToReload;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReloadTablesRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ReloadTablesRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReloadTablesRequest.getter(ReloadTablesRequest::replicationTaskArn)).setter(ReloadTablesRequest.setter(Builder::replicationTaskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build()}).build();
    private static final SdkField<List<TableToReload>> TABLES_TO_RELOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReloadTablesRequest.getter(ReloadTablesRequest::tablesToReload)).setter(ReloadTablesRequest.setter(Builder::tablesToReload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesToReload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableToReload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RELOAD_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReloadTablesRequest.getter(ReloadTablesRequest::reloadOptionAsString)).setter(ReloadTablesRequest.setter(Builder::reloadOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReloadOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD, TABLES_TO_RELOAD_FIELD, RELOAD_OPTION_FIELD));
    private final String replicationTaskArn;
    private final List<TableToReload> tablesToReload;
    private final String reloadOption;

    private ReloadTablesRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.tablesToReload = builder.tablesToReload;
        this.reloadOption = builder.reloadOption;
    }

    public String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public boolean hasTablesToReload() {
        return this.tablesToReload != null && !(this.tablesToReload instanceof SdkAutoConstructList);
    }

    public List<TableToReload> tablesToReload() {
        return this.tablesToReload;
    }

    public ReloadOptionValue reloadOption() {
        return ReloadOptionValue.fromValue(this.reloadOption);
    }

    public String reloadOptionAsString() {
        return this.reloadOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesToReload());
        hashCode = 31 * hashCode + Objects.hashCode(this.reloadOptionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadTablesRequest)) {
            return false;
        }
        ReloadTablesRequest other = (ReloadTablesRequest)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.tablesToReload(), other.tablesToReload()) && Objects.equals(this.reloadOptionAsString(), other.reloadOptionAsString());
    }

    public String toString() {
        return ToString.builder((String)"ReloadTablesRequest").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("TablesToReload", this.tablesToReload()).add("ReloadOption", (Object)this.reloadOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "TablesToReload": {
                return Optional.ofNullable(clazz.cast(this.tablesToReload()));
            }
            case "ReloadOption": {
                return Optional.ofNullable(clazz.cast(this.reloadOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReloadTablesRequest, T> g) {
        return obj -> g.apply((ReloadTablesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private List<TableToReload> tablesToReload = DefaultSdkAutoConstructList.getInstance();
        private String reloadOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ReloadTablesRequest model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.tablesToReload(model.tablesToReload);
            this.reloadOption(model.reloadOption);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final Collection<TableToReload.Builder> getTablesToReload() {
            return this.tablesToReload != null ? (Collection)this.tablesToReload.stream().map(TableToReload::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tablesToReload(Collection<TableToReload> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copy(tablesToReload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(TableToReload ... tablesToReload) {
            this.tablesToReload(Arrays.asList(tablesToReload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(Consumer<TableToReload.Builder> ... tablesToReload) {
            this.tablesToReload(Stream.of(tablesToReload).map(c -> (TableToReload)((TableToReload.Builder)TableToReload.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTablesToReload(Collection<TableToReload.BuilderImpl> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copyFromBuilder(tablesToReload);
        }

        public final String getReloadOption() {
            return this.reloadOption;
        }

        @Override
        public final Builder reloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
            return this;
        }

        @Override
        public final Builder reloadOption(ReloadOptionValue reloadOption) {
            this.reloadOption(reloadOption == null ? null : reloadOption.toString());
            return this;
        }

        public final void setReloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReloadTablesRequest build() {
            return new ReloadTablesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ReloadTablesRequest> {
        public Builder replicationTaskArn(String var1);

        public Builder tablesToReload(Collection<TableToReload> var1);

        public Builder tablesToReload(TableToReload ... var1);

        public Builder tablesToReload(Consumer<TableToReload.Builder> ... var1);

        public Builder reloadOption(String var1);

        public Builder reloadOption(ReloadOptionValue var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

