/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Connection> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::replicationInstanceArn)).setter(Connection.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::endpointArn)).setter(Connection.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::status)).setter(Connection.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::lastFailureMessage)).setter(Connection.setter(Builder::lastFailureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build()}).build();
    private static final SdkField<String> ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::endpointIdentifier)).setter(Connection.setter(Builder::endpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Connection.getter(Connection::replicationInstanceIdentifier)).setter(Connection.setter(Builder::replicationInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_INSTANCE_ARN_FIELD, ENDPOINT_ARN_FIELD, STATUS_FIELD, LAST_FAILURE_MESSAGE_FIELD, ENDPOINT_IDENTIFIER_FIELD, REPLICATION_INSTANCE_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replicationInstanceArn;
    private final String endpointArn;
    private final String status;
    private final String lastFailureMessage;
    private final String endpointIdentifier;
    private final String replicationInstanceIdentifier;

    private Connection(BuilderImpl builder) {
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.endpointArn = builder.endpointArn;
        this.status = builder.status;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.endpointIdentifier = builder.endpointIdentifier;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public String endpointArn() {
        return this.endpointArn;
    }

    public String status() {
        return this.status;
    }

    public String lastFailureMessage() {
        return this.lastFailureMessage;
    }

    public String endpointIdentifier() {
        return this.endpointIdentifier;
    }

    public String replicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastFailureMessage(), other.lastFailureMessage()) && Objects.equals(this.endpointIdentifier(), other.endpointIdentifier()) && Objects.equals(this.replicationInstanceIdentifier(), other.replicationInstanceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"Connection").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("EndpointArn", (Object)this.endpointArn()).add("Status", (Object)this.status()).add("LastFailureMessage", (Object)this.lastFailureMessage()).add("EndpointIdentifier", (Object)this.endpointIdentifier()).add("ReplicationInstanceIdentifier", (Object)this.replicationInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastFailureMessage": {
                return Optional.ofNullable(clazz.cast(this.lastFailureMessage()));
            }
            case "EndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.endpointIdentifier()));
            }
            case "ReplicationInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Connection, T> g) {
        return obj -> g.apply((Connection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private String endpointArn;
        private String status;
        private String lastFailureMessage;
        private String endpointIdentifier;
        private String replicationInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(Connection model) {
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.endpointArn(model.endpointArn);
            this.status(model.status);
            this.lastFailureMessage(model.lastFailureMessage);
            this.endpointIdentifier(model.endpointIdentifier);
            this.replicationInstanceIdentifier(model.replicationInstanceIdentifier);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getLastFailureMessage() {
            return this.lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public final String getEndpointIdentifier() {
            return this.endpointIdentifier;
        }

        @Override
        public final Builder endpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
            return this;
        }

        public final void setEndpointIdentifier(String endpointIdentifier) {
            this.endpointIdentifier = endpointIdentifier;
        }

        public final String getReplicationInstanceIdentifier() {
            return this.replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        public Connection build() {
            return new Connection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Connection> {
        public Builder replicationInstanceArn(String var1);

        public Builder endpointArn(String var1);

        public Builder status(String var1);

        public Builder lastFailureMessage(String var1);

        public Builder endpointIdentifier(String var1);

        public Builder replicationInstanceIdentifier(String var1);
    }
}

