/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.EventCategoriesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventCategoryGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventCategoryGroup> {
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EventCategoryGroup.getter(EventCategoryGroup::sourceType)).setter(EventCategoryGroup.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<List<String>> EVENT_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(EventCategoryGroup.getter(EventCategoryGroup::eventCategories)).setter(EventCategoryGroup.setter(Builder::eventCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TYPE_FIELD, EVENT_CATEGORIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceType;
    private final List<String> eventCategories;

    private EventCategoryGroup(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoryGroup)) {
            return false;
        }
        EventCategoryGroup other = (EventCategoryGroup)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.eventCategories(), other.eventCategories());
    }

    public String toString() {
        return ToString.builder((String)"EventCategoryGroup").add("SourceType", (Object)this.sourceType()).add("EventCategories", this.eventCategories()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceType()));
            }
            case "EventCategories": {
                return Optional.ofNullable(clazz.cast(this.eventCategories()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventCategoryGroup, T> g) {
        return obj -> g.apply((EventCategoryGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<String> eventCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoryGroup model) {
            this.sourceType(model.sourceType);
            this.eventCategories(model.eventCategories);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public EventCategoryGroup build() {
            return new EventCategoryGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventCategoryGroup> {
        public Builder sourceType(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);
    }
}

