/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;

public class DescribeReplicationTasksPublisher
implements SdkPublisher<DescribeReplicationTasksResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationTasksPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationTasksPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final DescribeReplicationTasksPublisher resume(DescribeReplicationTasksResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReplicationTasksPublisher(this.client, (DescribeReplicationTasksRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReplicationTasksPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReplicationTasksResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReplicationTasksResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationTasksResponse> {
        private DescribeReplicationTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationTasksResponse> nextPage(DescribeReplicationTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationTasksPublisher.this.client.describeReplicationTasks(DescribeReplicationTasksPublisher.this.firstRequest);
            }
            return DescribeReplicationTasksPublisher.this.client.describeReplicationTasks((DescribeReplicationTasksRequest)((Object)DescribeReplicationTasksPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

