/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroup;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationSubnetGroupsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeReplicationSubnetGroupsResponse.getter(DescribeReplicationSubnetGroupsResponse::marker)).setter(DescribeReplicationSubnetGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ReplicationSubnetGroup>> REPLICATION_SUBNET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeReplicationSubnetGroupsResponse.getter(DescribeReplicationSubnetGroupsResponse::replicationSubnetGroups)).setter(DescribeReplicationSubnetGroupsResponse.setter(Builder::replicationSubnetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, REPLICATION_SUBNET_GROUPS_FIELD));
    private final String marker;
    private final List<ReplicationSubnetGroup> replicationSubnetGroups;

    private DescribeReplicationSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.replicationSubnetGroups = builder.replicationSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReplicationSubnetGroup> replicationSubnetGroups() {
        return this.replicationSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationSubnetGroupsResponse)) {
            return false;
        }
        DescribeReplicationSubnetGroupsResponse other = (DescribeReplicationSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.replicationSubnetGroups(), other.replicationSubnetGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("ReplicationSubnetGroups", this.replicationSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ReplicationSubnetGroups": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationSubnetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ReplicationSubnetGroup> replicationSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.replicationSubnetGroups(model.replicationSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReplicationSubnetGroup.Builder> getReplicationSubnetGroups() {
            return this.replicationSubnetGroups != null ? (Collection)this.replicationSubnetGroups.stream().map(ReplicationSubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationSubnetGroups(Collection<ReplicationSubnetGroup> replicationSubnetGroups) {
            this.replicationSubnetGroups = ReplicationSubnetGroupsCopier.copy(replicationSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationSubnetGroups(ReplicationSubnetGroup ... replicationSubnetGroups) {
            this.replicationSubnetGroups(Arrays.asList(replicationSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationSubnetGroups(Consumer<ReplicationSubnetGroup.Builder> ... replicationSubnetGroups) {
            this.replicationSubnetGroups(Stream.of(replicationSubnetGroups).map(c -> (ReplicationSubnetGroup)((ReplicationSubnetGroup.Builder)ReplicationSubnetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationSubnetGroups(Collection<ReplicationSubnetGroup.BuilderImpl> replicationSubnetGroups) {
            this.replicationSubnetGroups = ReplicationSubnetGroupsCopier.copyFromBuilder(replicationSubnetGroups);
        }

        @Override
        public DescribeReplicationSubnetGroupsResponse build() {
            return new DescribeReplicationSubnetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReplicationSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder replicationSubnetGroups(Collection<ReplicationSubnetGroup> var1);

        public Builder replicationSubnetGroups(ReplicationSubnetGroup ... var1);

        public Builder replicationSubnetGroups(Consumer<ReplicationSubnetGroup.Builder> ... var1);
    }
}

