/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListUploadJobsResponse;
import software.amazon.awssdk.services.customerprofiles.model.UploadJobItem;

public class ListUploadJobsIterable
implements SdkIterable<ListUploadJobsResponse> {
    private final CustomerProfilesClient client;
    private final ListUploadJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUploadJobsIterable(CustomerProfilesClient client, ListUploadJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUploadJobsResponseFetcher();
    }

    public Iterator<ListUploadJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UploadJobItem> items() {
        Function<ListUploadJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUploadJobsResponseFetcher
    implements SyncPageFetcher<ListUploadJobsResponse> {
        private ListUploadJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListUploadJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUploadJobsResponse nextPage(ListUploadJobsResponse previousPage) {
            if (previousPage == null) {
                return ListUploadJobsIterable.this.client.listUploadJobs(ListUploadJobsIterable.this.firstRequest);
            }
            return ListUploadJobsIterable.this.client.listUploadJobs((ListUploadJobsRequest)((Object)ListUploadJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

