/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListRuleBasedMatchesResponse;

public class ListRuleBasedMatchesIterable
implements SdkIterable<ListRuleBasedMatchesResponse> {
    private final CustomerProfilesClient client;
    private final ListRuleBasedMatchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRuleBasedMatchesIterable(CustomerProfilesClient client, ListRuleBasedMatchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRuleBasedMatchesResponseFetcher();
    }

    public Iterator<ListRuleBasedMatchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> matchIds() {
        Function<ListRuleBasedMatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.matchIds() != null) {
                return response.matchIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRuleBasedMatchesResponseFetcher
    implements SyncPageFetcher<ListRuleBasedMatchesResponse> {
        private ListRuleBasedMatchesResponseFetcher() {
        }

        public boolean hasNextPage(ListRuleBasedMatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRuleBasedMatchesResponse nextPage(ListRuleBasedMatchesResponse previousPage) {
            if (previousPage == null) {
                return ListRuleBasedMatchesIterable.this.client.listRuleBasedMatches(ListRuleBasedMatchesIterable.this.firstRequest);
            }
            return ListRuleBasedMatchesIterable.this.client.listRuleBasedMatches((ListRuleBasedMatchesRequest)((Object)ListRuleBasedMatchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

