/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListRecommenderRecipesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListRecommenderRecipesResponse;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderRecipe;

public class ListRecommenderRecipesPublisher
implements SdkPublisher<ListRecommenderRecipesResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListRecommenderRecipesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommenderRecipesPublisher(CustomerProfilesAsyncClient client, ListRecommenderRecipesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommenderRecipesPublisher(CustomerProfilesAsyncClient client, ListRecommenderRecipesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommenderRecipesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommenderRecipesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommenderRecipe> recommenderRecipes() {
        Function<ListRecommenderRecipesResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommenderRecipes() != null) {
                return response.recommenderRecipes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommenderRecipesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommenderRecipesResponseFetcher
    implements AsyncPageFetcher<ListRecommenderRecipesResponse> {
        private ListRecommenderRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommenderRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommenderRecipesResponse> nextPage(ListRecommenderRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommenderRecipesPublisher.this.client.listRecommenderRecipes(ListRecommenderRecipesPublisher.this.firstRequest);
            }
            return ListRecommenderRecipesPublisher.this.client.listRecommenderRecipes((ListRecommenderRecipesRequest)((Object)ListRecommenderRecipesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

