/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerSummaryItem;
import software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersResponse;

public class ListEventTriggersPublisher
implements SdkPublisher<ListEventTriggersResponse> {
    private final CustomerProfilesAsyncClient client;
    private final ListEventTriggersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventTriggersPublisher(CustomerProfilesAsyncClient client, ListEventTriggersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventTriggersPublisher(CustomerProfilesAsyncClient client, ListEventTriggersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventTriggersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventTriggersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventTriggerSummaryItem> items() {
        Function<ListEventTriggersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventTriggersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventTriggersResponseFetcher
    implements AsyncPageFetcher<ListEventTriggersResponse> {
        private ListEventTriggersResponseFetcher() {
        }

        public boolean hasNextPage(ListEventTriggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventTriggersResponse> nextPage(ListEventTriggersResponse previousPage) {
            if (previousPage == null) {
                return ListEventTriggersPublisher.this.client.listEventTriggers(ListEventTriggersPublisher.this.firstRequest);
            }
            return ListEventTriggersPublisher.this.client.listEventTriggers((ListEventTriggersRequest)((Object)ListEventTriggersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

