/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.EventTriggerSummaryItem;
import software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventTriggersResponse;

public class ListEventTriggersIterable
implements SdkIterable<ListEventTriggersResponse> {
    private final CustomerProfilesClient client;
    private final ListEventTriggersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventTriggersIterable(CustomerProfilesClient client, ListEventTriggersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventTriggersResponseFetcher();
    }

    public Iterator<ListEventTriggersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventTriggerSummaryItem> items() {
        Function<ListEventTriggersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventTriggersResponseFetcher
    implements SyncPageFetcher<ListEventTriggersResponse> {
        private ListEventTriggersResponseFetcher() {
        }

        public boolean hasNextPage(ListEventTriggersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventTriggersResponse nextPage(ListEventTriggersResponse previousPage) {
            if (previousPage == null) {
                return ListEventTriggersIterable.this.client.listEventTriggers(ListEventTriggersIterable.this.firstRequest);
            }
            return ListEventTriggersIterable.this.client.listEventTriggers((ListEventTriggersRequest)((Object)ListEventTriggersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

