/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.DomainObjectTypesListItem;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainObjectTypesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainObjectTypesResponse;

public class ListDomainObjectTypesIterable
implements SdkIterable<ListDomainObjectTypesResponse> {
    private final CustomerProfilesClient client;
    private final ListDomainObjectTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDomainObjectTypesIterable(CustomerProfilesClient client, ListDomainObjectTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDomainObjectTypesResponseFetcher();
    }

    public Iterator<ListDomainObjectTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DomainObjectTypesListItem> items() {
        Function<ListDomainObjectTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDomainObjectTypesResponseFetcher
    implements SyncPageFetcher<ListDomainObjectTypesResponse> {
        private ListDomainObjectTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainObjectTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDomainObjectTypesResponse nextPage(ListDomainObjectTypesResponse previousPage) {
            if (previousPage == null) {
                return ListDomainObjectTypesIterable.this.client.listDomainObjectTypes(ListDomainObjectTypesIterable.this.firstRequest);
            }
            return ListDomainObjectTypesIterable.this.client.listDomainObjectTypes((ListDomainObjectTypesRequest)((Object)ListDomainObjectTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

