/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.MetricsCopier;
import software.amazon.awssdk.services.customerprofiles.model.TrainingMetricName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingMetrics> {
    private static final SdkField<Instant> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Time").getter(TrainingMetrics.getter(TrainingMetrics::time)).setter(TrainingMetrics.setter(Builder::time)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final SdkField<Map<String, Double>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(TrainingMetrics.getter(TrainingMetrics::metricsAsStrings)).setter(TrainingMetrics.setter(Builder::metricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD, METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrainingMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant time;
    private final Map<String, Double> metrics;

    private TrainingMetrics(BuilderImpl builder) {
        this.time = builder.time;
        this.metrics = builder.metrics;
    }

    public final Instant time() {
        return this.time;
    }

    public final Map<TrainingMetricName, Double> metrics() {
        return MetricsCopier.copyStringToEnum(this.metrics);
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> metricsAsStrings() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metricsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingMetrics)) {
            return false;
        }
        TrainingMetrics other = (TrainingMetrics)obj;
        return Objects.equals(this.time(), other.time()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metricsAsStrings(), other.metricsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingMetrics").add("Time", (Object)this.time()).add("Metrics", this.hasMetrics() ? this.metricsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Time", TIME_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrainingMetrics, T> g) {
        return obj -> g.apply((TrainingMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant time;
        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingMetrics model) {
            this.time(model.time);
            this.metricsWithStrings(model.metrics);
        }

        public final Instant getTime() {
            return this.time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final Map<String, Double> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        @Override
        public final Builder metricsWithStrings(Map<String, Double> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        public final Builder metrics(Map<TrainingMetricName, Double> metrics) {
            this.metrics = MetricsCopier.copyEnumToString(metrics);
            return this;
        }

        public TrainingMetrics build() {
            return new TrainingMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingMetrics> {
        public Builder time(Instant var1);

        public Builder metricsWithStrings(Map<String, Double> var1);

        public Builder metrics(Map<TrainingMetricName, Double> var1);
    }
}

