/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingMetricName {
    HIT("hit"),
    COVERAGE("coverage"),
    RECALL("recall"),
    POPULARITY("popularity"),
    FRESHNESS("freshness"),
    SIMILARITY("similarity"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingMetricName> VALUE_MAP;
    private final String value;

    private TrainingMetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingMetricName> knownValues() {
        EnumSet<TrainingMetricName> knownValues = EnumSet.allOf(TrainingMetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingMetricName.class, TrainingMetricName::toString);
    }
}

