/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.Unit;
import software.amazon.awssdk.services.customerprofiles.model.ValueRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Range
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Range> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Value").getter(Range.getter(Range::value)).setter(Range.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(Range.getter(Range::unitAsString)).setter(Range.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final SdkField<ValueRange> VALUE_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueRange").getter(Range.getter(Range::valueRange)).setter(Range.setter(Builder::valueRange)).constructor(ValueRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueRange").build()}).build();
    private static final SdkField<String> TIMESTAMP_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampSource").getter(Range.getter(Range::timestampSource)).setter(Range.setter(Builder::timestampSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampSource").build()}).build();
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimestampFormat").getter(Range.getter(Range::timestampFormat)).setter(Range.setter(Builder::timestampFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNIT_FIELD, VALUE_RANGE_FIELD, TIMESTAMP_SOURCE_FIELD, TIMESTAMP_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Range.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer value;
    private final String unit;
    private final ValueRange valueRange;
    private final String timestampSource;
    private final String timestampFormat;

    private Range(BuilderImpl builder) {
        this.value = builder.value;
        this.unit = builder.unit;
        this.valueRange = builder.valueRange;
        this.timestampSource = builder.timestampSource;
        this.timestampFormat = builder.timestampFormat;
    }

    public final Integer value() {
        return this.value;
    }

    public final Unit unit() {
        return Unit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final ValueRange valueRange() {
        return this.valueRange;
    }

    public final String timestampSource() {
        return this.timestampSource;
    }

    public final String timestampFormat() {
        return this.timestampFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampFormat());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.valueRange(), other.valueRange()) && Objects.equals(this.timestampSource(), other.timestampSource()) && Objects.equals(this.timestampFormat(), other.timestampFormat());
    }

    public final String toString() {
        return ToString.builder((String)"Range").add("Value", (Object)this.value()).add("Unit", (Object)this.unitAsString()).add("ValueRange", (Object)this.valueRange()).add("TimestampSource", (Object)this.timestampSource()).add("TimestampFormat", (Object)this.timestampFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "ValueRange": {
                return Optional.ofNullable(clazz.cast(this.valueRange()));
            }
            case "TimestampSource": {
                return Optional.ofNullable(clazz.cast(this.timestampSource()));
            }
            case "TimestampFormat": {
                return Optional.ofNullable(clazz.cast(this.timestampFormat()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Value", VALUE_FIELD);
        map.put("Unit", UNIT_FIELD);
        map.put("ValueRange", VALUE_RANGE_FIELD);
        map.put("TimestampSource", TIMESTAMP_SOURCE_FIELD);
        map.put("TimestampFormat", TIMESTAMP_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer value;
        private String unit;
        private ValueRange valueRange;
        private String timestampSource;
        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            this.value(model.value);
            this.unit(model.unit);
            this.valueRange(model.valueRange);
            this.timestampSource(model.timestampSource);
            this.timestampFormat(model.timestampFormat);
        }

        public final Integer getValue() {
            return this.value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final ValueRange.Builder getValueRange() {
            return this.valueRange != null ? this.valueRange.toBuilder() : null;
        }

        public final void setValueRange(ValueRange.BuilderImpl valueRange) {
            this.valueRange = valueRange != null ? valueRange.build() : null;
        }

        @Override
        public final Builder valueRange(ValueRange valueRange) {
            this.valueRange = valueRange;
            return this;
        }

        public final String getTimestampSource() {
            return this.timestampSource;
        }

        public final void setTimestampSource(String timestampSource) {
            this.timestampSource = timestampSource;
        }

        @Override
        public final Builder timestampSource(String timestampSource) {
            this.timestampSource = timestampSource;
            return this;
        }

        public final String getTimestampFormat() {
            return this.timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public Range build() {
            return new Range(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Range> {
        public Builder value(Integer var1);

        public Builder unit(String var1);

        public Builder unit(Unit var1);

        public Builder valueRange(ValueRange var1);

        default public Builder valueRange(Consumer<ValueRange.Builder> valueRange) {
            return this.valueRange((ValueRange)((ValueRange.Builder)ValueRange.builder().applyMutation(valueRange)).build());
        }

        public Builder timestampSource(String var1);

        public Builder timestampFormat(String var1);
    }
}

