/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRecommenderRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, GetRecommenderRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetRecommenderRequest.getter(GetRecommenderRequest::domainName)).setter(GetRecommenderRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> RECOMMENDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderName").getter(GetRecommenderRequest.getter(GetRecommenderRequest::recommenderName)).setter(GetRecommenderRequest.setter(Builder::recommenderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RecommenderName").build()}).build();
    private static final SdkField<Integer> TRAINING_METRICS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TrainingMetricsCount").getter(GetRecommenderRequest.getter(GetRecommenderRequest::trainingMetricsCount)).setter(GetRecommenderRequest.setter(Builder::trainingMetricsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("training-metrics-count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RECOMMENDER_NAME_FIELD, TRAINING_METRICS_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRecommenderRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String recommenderName;
    private final Integer trainingMetricsCount;

    private GetRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.recommenderName = builder.recommenderName;
        this.trainingMetricsCount = builder.trainingMetricsCount;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String recommenderName() {
        return this.recommenderName;
    }

    public final Integer trainingMetricsCount() {
        return this.trainingMetricsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingMetricsCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecommenderRequest)) {
            return false;
        }
        GetRecommenderRequest other = (GetRecommenderRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.recommenderName(), other.recommenderName()) && Objects.equals(this.trainingMetricsCount(), other.trainingMetricsCount());
    }

    public final String toString() {
        return ToString.builder((String)"GetRecommenderRequest").add("DomainName", (Object)this.domainName()).add("RecommenderName", (Object)this.recommenderName()).add("TrainingMetricsCount", (Object)this.trainingMetricsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "RecommenderName": {
                return Optional.ofNullable(clazz.cast(this.recommenderName()));
            }
            case "TrainingMetricsCount": {
                return Optional.ofNullable(clazz.cast(this.trainingMetricsCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("RecommenderName", RECOMMENDER_NAME_FIELD);
        map.put("training-metrics-count", TRAINING_METRICS_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecommenderRequest, T> g) {
        return obj -> g.apply((GetRecommenderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String recommenderName;
        private Integer trainingMetricsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecommenderRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.recommenderName(model.recommenderName);
            this.trainingMetricsCount(model.trainingMetricsCount);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getRecommenderName() {
            return this.recommenderName;
        }

        public final void setRecommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
        }

        @Override
        public final Builder recommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
            return this;
        }

        public final Integer getTrainingMetricsCount() {
            return this.trainingMetricsCount;
        }

        public final void setTrainingMetricsCount(Integer trainingMetricsCount) {
            this.trainingMetricsCount = trainingMetricsCount;
        }

        @Override
        public final Builder trainingMetricsCount(Integer trainingMetricsCount) {
            this.trainingMetricsCount = trainingMetricsCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecommenderRequest build() {
            return new GetRecommenderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRecommenderRequest> {
        public Builder domainName(String var1);

        public Builder recommenderName(String var1);

        public Builder trainingMetricsCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

