/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.AutoMerging;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ExportingLocation;
import software.amazon.awssdk.services.customerprofiles.model.IdentityResolutionJobStatus;
import software.amazon.awssdk.services.customerprofiles.model.JobStats;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityResolutionJobResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetIdentityResolutionJobResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::domainName)).setter(GetIdentityResolutionJobResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::jobId)).setter(GetIdentityResolutionJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::statusAsString)).setter(GetIdentityResolutionJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::message)).setter(GetIdentityResolutionJobResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Instant> JOB_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobStartTime").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::jobStartTime)).setter(GetIdentityResolutionJobResponse.setter(Builder::jobStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStartTime").build()}).build();
    private static final SdkField<Instant> JOB_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobEndTime").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::jobEndTime)).setter(GetIdentityResolutionJobResponse.setter(Builder::jobEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobEndTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::lastUpdatedAt)).setter(GetIdentityResolutionJobResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Instant> JOB_EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobExpirationTime").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::jobExpirationTime)).setter(GetIdentityResolutionJobResponse.setter(Builder::jobExpirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobExpirationTime").build()}).build();
    private static final SdkField<AutoMerging> AUTO_MERGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoMerging").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::autoMerging)).setter(GetIdentityResolutionJobResponse.setter(Builder::autoMerging)).constructor(AutoMerging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMerging").build()}).build();
    private static final SdkField<ExportingLocation> EXPORTING_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportingLocation").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::exportingLocation)).setter(GetIdentityResolutionJobResponse.setter(Builder::exportingLocation)).constructor(ExportingLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingLocation").build()}).build();
    private static final SdkField<JobStats> JOB_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobStats").getter(GetIdentityResolutionJobResponse.getter(GetIdentityResolutionJobResponse::jobStats)).setter(GetIdentityResolutionJobResponse.setter(Builder::jobStats)).constructor(JobStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStats").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, JOB_ID_FIELD, STATUS_FIELD, MESSAGE_FIELD, JOB_START_TIME_FIELD, JOB_END_TIME_FIELD, LAST_UPDATED_AT_FIELD, JOB_EXPIRATION_TIME_FIELD, AUTO_MERGING_FIELD, EXPORTING_LOCATION_FIELD, JOB_STATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIdentityResolutionJobResponse.memberNameToFieldInitializer();
    private final String domainName;
    private final String jobId;
    private final String status;
    private final String message;
    private final Instant jobStartTime;
    private final Instant jobEndTime;
    private final Instant lastUpdatedAt;
    private final Instant jobExpirationTime;
    private final AutoMerging autoMerging;
    private final ExportingLocation exportingLocation;
    private final JobStats jobStats;

    private GetIdentityResolutionJobResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.message = builder.message;
        this.jobStartTime = builder.jobStartTime;
        this.jobEndTime = builder.jobEndTime;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.jobExpirationTime = builder.jobExpirationTime;
        this.autoMerging = builder.autoMerging;
        this.exportingLocation = builder.exportingLocation;
        this.jobStats = builder.jobStats;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final IdentityResolutionJobStatus status() {
        return IdentityResolutionJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final Instant jobStartTime() {
        return this.jobStartTime;
    }

    public final Instant jobEndTime() {
        return this.jobEndTime;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Instant jobExpirationTime() {
        return this.jobExpirationTime;
    }

    public final AutoMerging autoMerging() {
        return this.autoMerging;
    }

    public final ExportingLocation exportingLocation() {
        return this.exportingLocation;
    }

    public final JobStats jobStats() {
        return this.jobStats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMerging());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStats());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityResolutionJobResponse)) {
            return false;
        }
        GetIdentityResolutionJobResponse other = (GetIdentityResolutionJobResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.jobStartTime(), other.jobStartTime()) && Objects.equals(this.jobEndTime(), other.jobEndTime()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.jobExpirationTime(), other.jobExpirationTime()) && Objects.equals(this.autoMerging(), other.autoMerging()) && Objects.equals(this.exportingLocation(), other.exportingLocation()) && Objects.equals(this.jobStats(), other.jobStats());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityResolutionJobResponse").add("DomainName", (Object)this.domainName()).add("JobId", (Object)this.jobId()).add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("JobStartTime", (Object)this.jobStartTime()).add("JobEndTime", (Object)this.jobEndTime()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("JobExpirationTime", (Object)this.jobExpirationTime()).add("AutoMerging", (Object)this.autoMerging()).add("ExportingLocation", (Object)this.exportingLocation()).add("JobStats", (Object)this.jobStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "JobStartTime": {
                return Optional.ofNullable(clazz.cast(this.jobStartTime()));
            }
            case "JobEndTime": {
                return Optional.ofNullable(clazz.cast(this.jobEndTime()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "JobExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.jobExpirationTime()));
            }
            case "AutoMerging": {
                return Optional.ofNullable(clazz.cast(this.autoMerging()));
            }
            case "ExportingLocation": {
                return Optional.ofNullable(clazz.cast(this.exportingLocation()));
            }
            case "JobStats": {
                return Optional.ofNullable(clazz.cast(this.jobStats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("JobStartTime", JOB_START_TIME_FIELD);
        map.put("JobEndTime", JOB_END_TIME_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("JobExpirationTime", JOB_EXPIRATION_TIME_FIELD);
        map.put("AutoMerging", AUTO_MERGING_FIELD);
        map.put("ExportingLocation", EXPORTING_LOCATION_FIELD);
        map.put("JobStats", JOB_STATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityResolutionJobResponse, T> g) {
        return obj -> g.apply((GetIdentityResolutionJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String jobId;
        private String status;
        private String message;
        private Instant jobStartTime;
        private Instant jobEndTime;
        private Instant lastUpdatedAt;
        private Instant jobExpirationTime;
        private AutoMerging autoMerging;
        private ExportingLocation exportingLocation;
        private JobStats jobStats;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityResolutionJobResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.jobId(model.jobId);
            this.status(model.status);
            this.message(model.message);
            this.jobStartTime(model.jobStartTime);
            this.jobEndTime(model.jobEndTime);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.jobExpirationTime(model.jobExpirationTime);
            this.autoMerging(model.autoMerging);
            this.exportingLocation(model.exportingLocation);
            this.jobStats(model.jobStats);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IdentityResolutionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getJobStartTime() {
            return this.jobStartTime;
        }

        public final void setJobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        @Override
        public final Builder jobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public final Instant getJobEndTime() {
            return this.jobEndTime;
        }

        public final void setJobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        @Override
        public final Builder jobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getJobExpirationTime() {
            return this.jobExpirationTime;
        }

        public final void setJobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
        }

        @Override
        public final Builder jobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
            return this;
        }

        public final AutoMerging.Builder getAutoMerging() {
            return this.autoMerging != null ? this.autoMerging.toBuilder() : null;
        }

        public final void setAutoMerging(AutoMerging.BuilderImpl autoMerging) {
            this.autoMerging = autoMerging != null ? autoMerging.build() : null;
        }

        @Override
        public final Builder autoMerging(AutoMerging autoMerging) {
            this.autoMerging = autoMerging;
            return this;
        }

        public final ExportingLocation.Builder getExportingLocation() {
            return this.exportingLocation != null ? this.exportingLocation.toBuilder() : null;
        }

        public final void setExportingLocation(ExportingLocation.BuilderImpl exportingLocation) {
            this.exportingLocation = exportingLocation != null ? exportingLocation.build() : null;
        }

        @Override
        public final Builder exportingLocation(ExportingLocation exportingLocation) {
            this.exportingLocation = exportingLocation;
            return this;
        }

        public final JobStats.Builder getJobStats() {
            return this.jobStats != null ? this.jobStats.toBuilder() : null;
        }

        public final void setJobStats(JobStats.BuilderImpl jobStats) {
            this.jobStats = jobStats != null ? jobStats.build() : null;
        }

        @Override
        public final Builder jobStats(JobStats jobStats) {
            this.jobStats = jobStats;
            return this;
        }

        @Override
        public GetIdentityResolutionJobResponse build() {
            return new GetIdentityResolutionJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityResolutionJobResponse> {
        public Builder domainName(String var1);

        public Builder jobId(String var1);

        public Builder status(String var1);

        public Builder status(IdentityResolutionJobStatus var1);

        public Builder message(String var1);

        public Builder jobStartTime(Instant var1);

        public Builder jobEndTime(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder jobExpirationTime(Instant var1);

        public Builder autoMerging(AutoMerging var1);

        default public Builder autoMerging(Consumer<AutoMerging.Builder> autoMerging) {
            return this.autoMerging((AutoMerging)((AutoMerging.Builder)AutoMerging.builder().applyMutation(autoMerging)).build());
        }

        public Builder exportingLocation(ExportingLocation var1);

        default public Builder exportingLocation(Consumer<ExportingLocation.Builder> exportingLocation) {
            return this.exportingLocation((ExportingLocation)((ExportingLocation.Builder)ExportingLocation.builder().applyMutation(exportingLocation)).build());
        }

        public Builder jobStats(JobStats var1);

        default public Builder jobStats(Consumer<JobStats.Builder> jobStats) {
            return this.jobStats((JobStats)((JobStats.Builder)JobStats.builder().applyMutation(jobStats)).build());
        }
    }
}

