/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.EventStreamDestinationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationSummary> {
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Uri").getter(DestinationSummary.getter(DestinationSummary::uri)).setter(DestinationSummary.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DestinationSummary.getter(DestinationSummary::statusAsString)).setter(DestinationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> UNHEALTHY_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UnhealthySince").getter(DestinationSummary.getter(DestinationSummary::unhealthySince)).setter(DestinationSummary.setter(Builder::unhealthySince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnhealthySince").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD, STATUS_FIELD, UNHEALTHY_SINCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DestinationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String uri;
    private final String status;
    private final Instant unhealthySince;

    private DestinationSummary(BuilderImpl builder) {
        this.uri = builder.uri;
        this.status = builder.status;
        this.unhealthySince = builder.unhealthySince;
    }

    public final String uri() {
        return this.uri;
    }

    public final EventStreamDestinationStatus status() {
        return EventStreamDestinationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant unhealthySince() {
        return this.unhealthySince;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unhealthySince());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationSummary)) {
            return false;
        }
        DestinationSummary other = (DestinationSummary)obj;
        return Objects.equals(this.uri(), other.uri()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.unhealthySince(), other.unhealthySince());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationSummary").add("Uri", (Object)this.uri()).add("Status", (Object)this.statusAsString()).add("UnhealthySince", (Object)this.unhealthySince()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "UnhealthySince": {
                return Optional.ofNullable(clazz.cast(this.unhealthySince()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Uri", URI_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("UnhealthySince", UNHEALTHY_SINCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationSummary, T> g) {
        return obj -> g.apply((DestinationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String uri;
        private String status;
        private Instant unhealthySince;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationSummary model) {
            this.uri(model.uri);
            this.status(model.status);
            this.unhealthySince(model.unhealthySince);
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EventStreamDestinationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUnhealthySince() {
            return this.unhealthySince;
        }

        public final void setUnhealthySince(Instant unhealthySince) {
            this.unhealthySince = unhealthySince;
        }

        @Override
        public final Builder unhealthySince(Instant unhealthySince) {
            this.unhealthySince = unhealthySince;
            return this;
        }

        public DestinationSummary build() {
            return new DestinationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationSummary> {
        public Builder uri(String var1);

        public Builder status(String var1);

        public Builder status(EventStreamDestinationStatus var1);

        public Builder unhealthySince(Instant var1);
    }
}

