/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CatalogItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CatalogItem> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CatalogItem.getter(CatalogItem::id)).setter(CatalogItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CatalogItem.getter(CatalogItem::name)).setter(CatalogItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(CatalogItem.getter(CatalogItem::code)).setter(CatalogItem.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CatalogItem.getter(CatalogItem::type)).setter(CatalogItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(CatalogItem.getter(CatalogItem::category)).setter(CatalogItem.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CatalogItem.getter(CatalogItem::description)).setter(CatalogItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ADDITIONAL_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInformation").getter(CatalogItem.getter(CatalogItem::additionalInformation)).setter(CatalogItem.setter(Builder::additionalInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build()}).build();
    private static final SdkField<String> IMAGE_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageLink").getter(CatalogItem.getter(CatalogItem::imageLink)).setter(CatalogItem.setter(Builder::imageLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageLink").build()}).build();
    private static final SdkField<String> LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Link").getter(CatalogItem.getter(CatalogItem::link)).setter(CatalogItem.setter(Builder::link)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Link").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(CatalogItem.getter(CatalogItem::createdAt)).setter(CatalogItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(CatalogItem.getter(CatalogItem::updatedAt)).setter(CatalogItem.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<String> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Price").getter(CatalogItem.getter(CatalogItem::price)).setter(CatalogItem.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(CatalogItem.getter(CatalogItem::attributes)).setter(CatalogItem.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, CODE_FIELD, TYPE_FIELD, CATEGORY_FIELD, DESCRIPTION_FIELD, ADDITIONAL_INFORMATION_FIELD, IMAGE_LINK_FIELD, LINK_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, PRICE_FIELD, ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CatalogItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String code;
    private final String type;
    private final String category;
    private final String description;
    private final String additionalInformation;
    private final String imageLink;
    private final String link;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String price;
    private final Map<String, String> attributes;

    private CatalogItem(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.code = builder.code;
        this.type = builder.type;
        this.category = builder.category;
        this.description = builder.description;
        this.additionalInformation = builder.additionalInformation;
        this.imageLink = builder.imageLink;
        this.link = builder.link;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.price = builder.price;
        this.attributes = builder.attributes;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String code() {
        return this.code;
    }

    public final String type() {
        return this.type;
    }

    public final String category() {
        return this.category;
    }

    public final String description() {
        return this.description;
    }

    public final String additionalInformation() {
        return this.additionalInformation;
    }

    public final String imageLink() {
        return this.imageLink;
    }

    public final String link() {
        return this.link;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String price() {
        return this.price;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.link());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CatalogItem)) {
            return false;
        }
        CatalogItem other = (CatalogItem)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.additionalInformation(), other.additionalInformation()) && Objects.equals(this.imageLink(), other.imageLink()) && Objects.equals(this.link(), other.link()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.price(), other.price()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public final String toString() {
        return ToString.builder((String)"CatalogItem").add("Id", (Object)(this.id() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Code", (Object)(this.code() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)(this.type() == null ? null : "*** Sensitive Data Redacted ***")).add("Category", (Object)(this.category() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalInformation", (Object)(this.additionalInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("ImageLink", (Object)(this.imageLink() == null ? null : "*** Sensitive Data Redacted ***")).add("Link", (Object)(this.link() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Price", (Object)(this.price() == null ? null : "*** Sensitive Data Redacted ***")).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AdditionalInformation": {
                return Optional.ofNullable(clazz.cast(this.additionalInformation()));
            }
            case "ImageLink": {
                return Optional.ofNullable(clazz.cast(this.imageLink()));
            }
            case "Link": {
                return Optional.ofNullable(clazz.cast(this.link()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Code", CODE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AdditionalInformation", ADDITIONAL_INFORMATION_FIELD);
        map.put("ImageLink", IMAGE_LINK_FIELD);
        map.put("Link", LINK_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        map.put("Price", PRICE_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CatalogItem, T> g) {
        return obj -> g.apply((CatalogItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String code;
        private String type;
        private String category;
        private String description;
        private String additionalInformation;
        private String imageLink;
        private String link;
        private Instant createdAt;
        private Instant updatedAt;
        private String price;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CatalogItem model) {
            this.id(model.id);
            this.name(model.name);
            this.code(model.code);
            this.type(model.type);
            this.category(model.category);
            this.description(model.description);
            this.additionalInformation(model.additionalInformation);
            this.imageLink(model.imageLink);
            this.link(model.link);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.price(model.price);
            this.attributes(model.attributes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAdditionalInformation() {
            return this.additionalInformation;
        }

        public final void setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        @Override
        public final Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final String getImageLink() {
            return this.imageLink;
        }

        public final void setImageLink(String imageLink) {
            this.imageLink = imageLink;
        }

        @Override
        public final Builder imageLink(String imageLink) {
            this.imageLink = imageLink;
            return this;
        }

        public final String getLink() {
            return this.link;
        }

        public final void setLink(String link) {
            this.link = link;
        }

        @Override
        public final Builder link(String link) {
            this.link = link;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getPrice() {
            return this.price;
        }

        public final void setPrice(String price) {
            this.price = price;
        }

        @Override
        public final Builder price(String price) {
            this.price = price;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public CatalogItem build() {
            return new CatalogItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CatalogItem> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder code(String var1);

        public Builder type(String var1);

        public Builder category(String var1);

        public Builder description(String var1);

        public Builder additionalInformation(String var1);

        public Builder imageLink(String var1);

        public Builder link(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder price(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

