/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.CostOptimizationHubRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.Filter;
import software.amazon.awssdk.services.costoptimizationhub.model.SummaryMetrics;
import software.amazon.awssdk.services.costoptimizationhub.model.SummaryMetricsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationSummariesRequest
extends CostOptimizationHubRequest
implements ToCopyableBuilder<Builder, ListRecommendationSummariesRequest> {
    private static final SdkField<Filter> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filter").getter(ListRecommendationSummariesRequest.getter(ListRecommendationSummariesRequest::filter)).setter(ListRecommendationSummariesRequest.setter(Builder::filter)).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<String> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupBy").getter(ListRecommendationSummariesRequest.getter(ListRecommendationSummariesRequest::groupBy)).setter(ListRecommendationSummariesRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRecommendationSummariesRequest.getter(ListRecommendationSummariesRequest::maxResults)).setter(ListRecommendationSummariesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metrics").getter(ListRecommendationSummariesRequest.getter(ListRecommendationSummariesRequest::metricsAsStrings)).setter(ListRecommendationSummariesRequest.setter(Builder::metricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRecommendationSummariesRequest.getter(ListRecommendationSummariesRequest::nextToken)).setter(ListRecommendationSummariesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, GROUP_BY_FIELD, MAX_RESULTS_FIELD, METRICS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecommendationSummariesRequest.memberNameToFieldInitializer();
    private final Filter filter;
    private final String groupBy;
    private final Integer maxResults;
    private final List<String> metrics;
    private final String nextToken;

    private ListRecommendationSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.groupBy = builder.groupBy;
        this.maxResults = builder.maxResults;
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
    }

    public final Filter filter() {
        return this.filter;
    }

    public final String groupBy() {
        return this.groupBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final List<SummaryMetrics> metrics() {
        return SummaryMetricsListCopier.copyStringToEnum(this.metrics);
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<String> metricsAsStrings() {
        return this.metrics;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metricsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationSummariesRequest)) {
            return false;
        }
        ListRecommendationSummariesRequest other = (ListRecommendationSummariesRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.groupBy(), other.groupBy()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metricsAsStrings(), other.metricsAsStrings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationSummariesRequest").add("Filter", (Object)this.filter()).add("GroupBy", (Object)this.groupBy()).add("MaxResults", (Object)this.maxResults()).add("Metrics", this.hasMetrics() ? this.metricsAsStrings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metricsAsStrings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filter", FILTER_FIELD);
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("metrics", METRICS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationSummariesRequest, T> g) {
        return obj -> g.apply((ListRecommendationSummariesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostOptimizationHubRequest.BuilderImpl
    implements Builder {
        private Filter filter;
        private String groupBy;
        private Integer maxResults;
        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationSummariesRequest model) {
            super(model);
            this.filter(model.filter);
            this.groupBy(model.groupBy);
            this.maxResults(model.maxResults);
            this.metricsWithStrings(model.metrics);
            this.nextToken(model.nextToken);
        }

        public final Filter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Filter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public final String getGroupBy() {
            return this.groupBy;
        }

        public final void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        @Override
        public final Builder groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = SummaryMetricsListCopier.copy(metrics);
        }

        @Override
        public final Builder metricsWithStrings(Collection<String> metrics) {
            this.metrics = SummaryMetricsListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsWithStrings(String ... metrics) {
            this.metricsWithStrings(Arrays.asList(metrics));
            return this;
        }

        @Override
        public final Builder metrics(Collection<SummaryMetrics> metrics) {
            this.metrics = SummaryMetricsListCopier.copyEnumToString(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(SummaryMetrics ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationSummariesRequest build() {
            return new ListRecommendationSummariesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostOptimizationHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationSummariesRequest> {
        public Builder filter(Filter var1);

        default public Builder filter(Consumer<Filter.Builder> filter) {
            return this.filter((Filter)((Filter.Builder)Filter.builder().applyMutation(filter)).build());
        }

        public Builder groupBy(String var1);

        public Builder maxResults(Integer var1);

        public Builder metricsWithStrings(Collection<String> var1);

        public Builder metricsWithStrings(String ... var1);

        public Builder metrics(Collection<SummaryMetrics> var1);

        public Builder metrics(SummaryMetrics ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

