/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costoptimizationhub.model.Order;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrderBy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrderBy> {
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dimension").getter(OrderBy.getter(OrderBy::dimension)).setter(OrderBy.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("order").getter(OrderBy.getter(OrderBy::orderAsString)).setter(OrderBy.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD, ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OrderBy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dimension;
    private final String order;

    private OrderBy(BuilderImpl builder) {
        this.dimension = builder.dimension;
        this.order = builder.order;
    }

    public final String dimension() {
        return this.dimension;
    }

    public final Order order() {
        return Order.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimension());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderBy)) {
            return false;
        }
        OrderBy other = (OrderBy)obj;
        return Objects.equals(this.dimension(), other.dimension()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OrderBy").add("Dimension", (Object)this.dimension()).add("Order", (Object)this.orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dimension": {
                return Optional.ofNullable(clazz.cast(this.dimension()));
            }
            case "order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("dimension", DIMENSION_FIELD);
        map.put("order", ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrderBy, T> g) {
        return obj -> g.apply((OrderBy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimension;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderBy model) {
            this.dimension(model.dimension);
            this.order(model.order);
        }

        public final String getDimension() {
            return this.dimension;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public OrderBy build() {
            return new OrderBy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrderBy> {
        public Builder dimension(String var1);

        public Builder order(String var1);

        public Builder order(Order var1);
    }
}

