/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costoptimizationhub.CostOptimizationHubAsyncClient;
import software.amazon.awssdk.services.costoptimizationhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesRequest;
import software.amazon.awssdk.services.costoptimizationhub.model.ListRecommendationSummariesResponse;
import software.amazon.awssdk.services.costoptimizationhub.model.RecommendationSummary;

public class ListRecommendationSummariesPublisher
implements SdkPublisher<ListRecommendationSummariesResponse> {
    private final CostOptimizationHubAsyncClient client;
    private final ListRecommendationSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendationSummariesPublisher(CostOptimizationHubAsyncClient client, ListRecommendationSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendationSummariesPublisher(CostOptimizationHubAsyncClient client, ListRecommendationSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendationSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendationSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendationSummary> items() {
        Function<ListRecommendationSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommendationSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommendationSummariesResponseFetcher
    implements AsyncPageFetcher<ListRecommendationSummariesResponse> {
        private ListRecommendationSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendationSummariesResponse> nextPage(ListRecommendationSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationSummariesPublisher.this.client.listRecommendationSummaries(ListRecommendationSummariesPublisher.this.firstRequest);
            }
            return ListRecommendationSummariesPublisher.this.client.listRecommendationSummaries((ListRecommendationSummariesRequest)((Object)ListRecommendationSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

