/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansPricing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansPricing> {
    private static final SdkField<Double> MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("monthlySavingsPlansEligibleCost").getter(SavingsPlansPricing.getter(SavingsPlansPricing::monthlySavingsPlansEligibleCost)).setter(SavingsPlansPricing.setter(Builder::monthlySavingsPlansEligibleCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlySavingsPlansEligibleCost").build()}).build();
    private static final SdkField<Double> ESTIMATED_MONTHLY_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedMonthlyCommitment").getter(SavingsPlansPricing.getter(SavingsPlansPricing::estimatedMonthlyCommitment)).setter(SavingsPlansPricing.setter(Builder::estimatedMonthlyCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyCommitment").build()}).build();
    private static final SdkField<Double> SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("savingsPercentage").getter(SavingsPlansPricing.getter(SavingsPlansPricing::savingsPercentage)).setter(SavingsPlansPricing.setter(Builder::savingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsPercentage").build()}).build();
    private static final SdkField<Double> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedOnDemandCost").getter(SavingsPlansPricing.getter(SavingsPlansPricing::estimatedOnDemandCost)).setter(SavingsPlansPricing.setter(Builder::estimatedOnDemandCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedOnDemandCost").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD, ESTIMATED_MONTHLY_COMMITMENT_FIELD, SAVINGS_PERCENTAGE_FIELD, ESTIMATED_ON_DEMAND_COST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("monthlySavingsPlansEligibleCost", MONTHLY_SAVINGS_PLANS_ELIGIBLE_COST_FIELD);
            this.put("estimatedMonthlyCommitment", ESTIMATED_MONTHLY_COMMITMENT_FIELD);
            this.put("savingsPercentage", SAVINGS_PERCENTAGE_FIELD);
            this.put("estimatedOnDemandCost", ESTIMATED_ON_DEMAND_COST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double monthlySavingsPlansEligibleCost;
    private final Double estimatedMonthlyCommitment;
    private final Double savingsPercentage;
    private final Double estimatedOnDemandCost;

    private SavingsPlansPricing(BuilderImpl builder) {
        this.monthlySavingsPlansEligibleCost = builder.monthlySavingsPlansEligibleCost;
        this.estimatedMonthlyCommitment = builder.estimatedMonthlyCommitment;
        this.savingsPercentage = builder.savingsPercentage;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
    }

    public final Double monthlySavingsPlansEligibleCost() {
        return this.monthlySavingsPlansEligibleCost;
    }

    public final Double estimatedMonthlyCommitment() {
        return this.estimatedMonthlyCommitment;
    }

    public final Double savingsPercentage() {
        return this.savingsPercentage;
    }

    public final Double estimatedOnDemandCost() {
        return this.estimatedOnDemandCost;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monthlySavingsPlansEligibleCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedOnDemandCost());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPricing)) {
            return false;
        }
        SavingsPlansPricing other = (SavingsPlansPricing)obj;
        return Objects.equals(this.monthlySavingsPlansEligibleCost(), other.monthlySavingsPlansEligibleCost()) && Objects.equals(this.estimatedMonthlyCommitment(), other.estimatedMonthlyCommitment()) && Objects.equals(this.savingsPercentage(), other.savingsPercentage()) && Objects.equals(this.estimatedOnDemandCost(), other.estimatedOnDemandCost());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansPricing").add("MonthlySavingsPlansEligibleCost", (Object)this.monthlySavingsPlansEligibleCost()).add("EstimatedMonthlyCommitment", (Object)this.estimatedMonthlyCommitment()).add("SavingsPercentage", (Object)this.savingsPercentage()).add("EstimatedOnDemandCost", (Object)this.estimatedOnDemandCost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "monthlySavingsPlansEligibleCost": {
                return Optional.ofNullable(clazz.cast(this.monthlySavingsPlansEligibleCost()));
            }
            case "estimatedMonthlyCommitment": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlyCommitment()));
            }
            case "savingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.savingsPercentage()));
            }
            case "estimatedOnDemandCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedOnDemandCost()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPricing, T> g) {
        return obj -> g.apply((SavingsPlansPricing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double monthlySavingsPlansEligibleCost;
        private Double estimatedMonthlyCommitment;
        private Double savingsPercentage;
        private Double estimatedOnDemandCost;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPricing model) {
            this.monthlySavingsPlansEligibleCost(model.monthlySavingsPlansEligibleCost);
            this.estimatedMonthlyCommitment(model.estimatedMonthlyCommitment);
            this.savingsPercentage(model.savingsPercentage);
            this.estimatedOnDemandCost(model.estimatedOnDemandCost);
        }

        public final Double getMonthlySavingsPlansEligibleCost() {
            return this.monthlySavingsPlansEligibleCost;
        }

        public final void setMonthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost) {
            this.monthlySavingsPlansEligibleCost = monthlySavingsPlansEligibleCost;
        }

        @Override
        public final Builder monthlySavingsPlansEligibleCost(Double monthlySavingsPlansEligibleCost) {
            this.monthlySavingsPlansEligibleCost = monthlySavingsPlansEligibleCost;
            return this;
        }

        public final Double getEstimatedMonthlyCommitment() {
            return this.estimatedMonthlyCommitment;
        }

        public final void setEstimatedMonthlyCommitment(Double estimatedMonthlyCommitment) {
            this.estimatedMonthlyCommitment = estimatedMonthlyCommitment;
        }

        @Override
        public final Builder estimatedMonthlyCommitment(Double estimatedMonthlyCommitment) {
            this.estimatedMonthlyCommitment = estimatedMonthlyCommitment;
            return this;
        }

        public final Double getSavingsPercentage() {
            return this.savingsPercentage;
        }

        public final void setSavingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(Double savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        public final Double getEstimatedOnDemandCost() {
            return this.estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(Double estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public SavingsPlansPricing build() {
            return new SavingsPlansPricing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansPricing> {
        public Builder monthlySavingsPlansEligibleCost(Double var1);

        public Builder estimatedMonthlyCommitment(Double var1);

        public Builder savingsPercentage(Double var1);

        public Builder estimatedOnDemandCost(Double var1);
    }
}

